/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.util;

import java.time.Duration;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class DurationMatcher
extends TypeSafeDiagnosingMatcher<Duration> {
    private Duration target;
    private Duration margin;

    public DurationMatcher(Duration target, Duration margin) {
        this.target = target;
        this.margin = margin;
    }

    public void describeTo(Description description) {
        description.appendText("Duration within ").appendValue((Object)this.margin).appendText(" of ").appendValue((Object)this.target);
    }

    protected boolean matchesSafely(Duration item, Description mismatchDescription) {
        Duration difference = item.minus(this.target).abs();
        mismatchDescription.appendValue((Object)item).appendText(" which is ").appendValue((Object)difference).appendText(" from ").appendValue((Object)this.target);
        return difference.compareTo(this.margin) <= 0;
    }

    public static DurationMatcher closeTo(Duration target, Duration margin) {
        return new DurationMatcher(target, margin);
    }

    public static DurationMatcher closeTo(Duration target) {
        return new DurationMatcher(target, Duration.ofMillis(100L));
    }
}

