/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.metrics.common;

import jakarta.enterprise.context.RequestScoped;
import java.time.Duration;
import org.eclipse.microprofile.fault.tolerance.tck.util.TestException;
import org.eclipse.microprofile.faulttolerance.Retry;

@RequestScoped
public class RetryMetricBean {
    @Retry(maxRetries=5)
    public void failSeveralTimes(int timesToFail, CallCounter counter) {
        counter.calls++;
        if (counter.calls <= timesToFail) {
            throw new TestException("call no. " + counter.calls);
        }
    }

    @Retry(maxRetries=-1, maxDuration=1000L, delay=0L, jitter=0L)
    public void failAfterDelay(Duration delay) throws InterruptedException {
        Thread.sleep(delay.toMillis());
        throw new TestException("Exception after duration: " + delay);
    }

    @Retry(maxRetries=5, abortOn={NonRetryableException.class})
    public void failSeveralTimesThenNonRetryable(int timesToFail, CallCounter counter) {
        counter.calls++;
        if (counter.calls <= timesToFail) {
            throw new TestException("call no. " + counter.calls);
        }
        throw new NonRetryableException();
    }

    @Retry(maxRetries=0)
    public void maxRetriesZero() {
        throw new TestException("Test exception for maxRetriesZero");
    }

    public static class CallCounter {
        private int calls = 0;
    }

    public static class NonRetryableException
    extends RuntimeException {
    }
}

