/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util;

import java.util.Optional;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.InMemoryMetricReader;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryMetricDefinition;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryMetricID;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class TelemetryLongMetric {
    private TelemetryMetricID metricId;
    private long baseline;

    public TelemetryLongMetric(TelemetryMetricID metricId) {
        this.metricId = metricId;
        this.baseline = 0L;
        MatcherAssert.assertThat((Object)((Object)metricId.type), (Matcher)Matchers.isOneOf((Object[])new TelemetryMetricDefinition.MetricType[]{TelemetryMetricDefinition.MetricType.COUNTER, TelemetryMetricDefinition.MetricType.GAUGE, TelemetryMetricDefinition.MetricType.UPDOWNCOUNTER}));
    }

    public long value() {
        InMemoryMetricReader reader = InMemoryMetricReader.current();
        return reader.readLongData(this.metricId);
    }

    public boolean isPresent() {
        InMemoryMetricReader exporter = InMemoryMetricReader.current();
        Optional latest = exporter.getMetric(this.metricId).flatMap(md -> InMemoryMetricReader.getLongPointData(md, this.metricId));
        return latest.isPresent();
    }

    public void baseline() {
        this.baseline = this.value();
    }

    public long delta() {
        return this.value() - this.baseline;
    }
}

