/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.health.tck;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.tck.DeploymentUtils;
import org.eclipse.microprofile.health.tck.TCKBase;
import org.eclipse.microprofile.health.tck.deployment.SuccessfulLiveness;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.shrinkwrap.api.Archive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HealthCheckResponseValidationTest
extends TCKBase {
    @Deployment
    public static Archive getDeployment() {
        return DeploymentUtils.createWarFileWithClasses(HealthCheckResponseValidationTest.class.getSimpleName(), SuccessfulLiveness.class);
    }

    @Test
    @RunAsClient
    public void testValidateConcreteHealthCheckResponse() throws Exception {
        TCKBase.Response response = this.getUrlHealthContents();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        JsonObject json = this.readJson(response);
        JsonArray checks = json.getJsonArray("checks");
        JsonObject check = checks.getJsonObject(0);
        ObjectMapper mapper = new ObjectMapper();
        mapper.findAndRegisterModules();
        HealthCheckResponse hcr = (HealthCheckResponse)mapper.readValue(check.toString(), HealthCheckResponse.class);
        Assert.assertEquals((String)hcr.getName(), (String)"successful-check", (String)String.format("Unexpected value for the HealthCheckResponse \"name\" property : %s", hcr.getName()));
        Assert.assertEquals((Object)hcr.getStatus(), (Object)HealthCheckResponse.Status.UP, (String)"Expected a successful check status for the HealthCheckResponse \"status\" property.");
    }
}

