/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.health.tck;

import javax.json.JsonArray;
import javax.json.JsonObject;
import org.eclipse.microprofile.health.tck.DeploymentUtils;
import org.eclipse.microprofile.health.tck.TCKBase;
import org.eclipse.microprofile.health.tck.deployment.FailedLiveness;
import org.eclipse.microprofile.health.tck.deployment.SuccessfulLiveness;
import org.eclipse.microprofile.health.tck.deployment.SuccessfulReadiness;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.shrinkwrap.api.Archive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MultipleLivenessFailedTest
extends TCKBase {
    @Deployment
    public static Archive getDeployment() {
        return DeploymentUtils.createWarFileWithClasses(MultipleLivenessFailedTest.class.getSimpleName(), FailedLiveness.class, SuccessfulLiveness.class, SuccessfulReadiness.class);
    }

    @Test
    @RunAsClient
    public void testFailureLivenessResponsePayload() {
        TCKBase.Response response = this.getUrlLiveContents();
        Assert.assertEquals((int)response.getStatus(), (int)503);
        JsonObject json = this.readJson(response);
        JsonArray checks = json.getJsonArray("checks");
        Assert.assertEquals((int)checks.size(), (int)2, (String)"Expected two check responses");
        block8: for (JsonObject check : checks.getValuesAs(JsonObject.class)) {
            String id;
            switch (id = check.getString("name")) {
                case "successful-check": {
                    this.verifySuccessStatus(check);
                    continue block8;
                }
                case "failed-check": {
                    this.verifyFailureStatus(check);
                    continue block8;
                }
            }
            Assert.fail((String)"Unexpected response payload structure");
        }
        this.assertOverallFailure(json);
    }

    @Test
    @RunAsClient
    public void testSuccessfulReadinessResponsePayload() {
        TCKBase.Response response = this.getUrlReadyContents();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        JsonObject json = this.readJson(response);
        JsonArray checks = json.getJsonArray("checks");
        Assert.assertEquals((int)checks.size(), (int)1, (String)"Expected a single check response");
        this.assertSuccessfulCheck(checks.getJsonObject(0), "successful-check");
        this.assertOverallSuccess(json);
    }
}

