/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.health.tck;

import javax.json.JsonArray;
import javax.json.JsonObject;
import org.eclipse.microprofile.health.tck.DeploymentUtils;
import org.eclipse.microprofile.health.tck.TCKBase;
import org.eclipse.microprofile.health.tck.deployment.CDIProducedProcedureCheck;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.shrinkwrap.api.Archive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CDIProducedProceduresTest
extends TCKBase {
    @Deployment
    public static Archive getDeployment() {
        return DeploymentUtils.createWarFileWithClasses(CDIProducedProceduresTest.class.getSimpleName(), CDIProducedProcedureCheck.class);
    }

    @Test
    @RunAsClient
    public void testSuccessfulLivenessResponsePayload() {
        TCKBase.Response response = this.getUrlLiveContents();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        JsonObject json = this.readJson(response);
        JsonArray checks = json.getJsonArray("checks");
        Assert.assertEquals((int)checks.size(), (int)1, (String)"Expected a single check response");
        this.assertSuccessfulCheck(checks.getJsonObject(0), "cdi-produced-successful-check");
        this.assertOverallSuccess(json);
    }

    @Test
    @RunAsClient
    public void testFailureReadinessResponsePayload() {
        TCKBase.Response response = this.getUrlReadyContents();
        Assert.assertEquals((int)response.getStatus(), (int)503);
        JsonObject json = this.readJson(response);
        JsonArray checks = json.getJsonArray("checks");
        Assert.assertEquals((int)checks.size(), (int)1, (String)"Expected a single check response");
        this.assertFailureCheck(checks.getJsonObject(0), "cdi-produced-failed-check");
        this.assertOverallFailure(json);
    }

    @Test
    @RunAsClient
    public void testSuccessStartupResponsePayload() {
        TCKBase.Response response = this.getUrlStartedContents();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        JsonObject json = this.readJson(response);
        JsonArray checks = json.getJsonArray("checks");
        Assert.assertEquals((int)checks.size(), (int)1, (String)"Expected a single check response");
        this.assertSuccessfulCheck(checks.getJsonObject(0), "cdi-produced-successful-check");
        this.assertOverallSuccess(json);
    }
}

