/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jaxrs;

import javax.annotation.security.RolesAllowed;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.json.Json;
import javax.json.JsonObject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.jwt.Claim;
import org.eclipse.microprofile.jwt.ClaimValue;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;

@Path(value="/endp")
@RolesAllowed(value={"Echoer", "Tester"})
@ApplicationScoped
public class ApplicationScopedEndpoint {
    @Inject
    private JsonWebToken jwt;
    @Inject
    @Claim(value="raw_token")
    private ClaimValue<String> rawToken;
    @Inject
    @Claim(value="raw_token")
    private Provider<String> providedRawToken;

    @GET
    @Path(value="/verifyInjectedRawTokenClaimValue")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedRawTokenClaimValue(@QueryParam(value="raw_token") String rt) {
        return ApplicationScopedEndpoint.verifyRawToken((String)this.rawToken.getValue(), rt);
    }

    @GET
    @Path(value="/verifyInjectedRawTokenJwt")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedRawTokenJwt(@QueryParam(value="raw_token") String rt) {
        return ApplicationScopedEndpoint.verifyRawToken(this.jwt.getRawToken(), rt);
    }

    @GET
    @Path(value="/verifyInjectedRawTokenProvider")
    @Produces(value={"application/json"})
    public JsonObject verifyInjectedRawTokenProvider(@QueryParam(value="raw_token") String rt) {
        return ApplicationScopedEndpoint.verifyRawToken((String)this.providedRawToken.get(), rt);
    }

    private static JsonObject verifyRawToken(String injectedRawToken, String rawTokenQueryParam) {
        String msg;
        boolean pass = false;
        if (injectedRawToken == null || injectedRawToken.length() == 0) {
            msg = Claims.raw_token.name() + "value is null or empty, FAIL";
        } else if (injectedRawToken.equals(rawTokenQueryParam)) {
            msg = Claims.raw_token.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.raw_token.name(), injectedRawToken, rawTokenQueryParam);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).add("injectedRawToken", injectedRawToken).build();
        return result;
    }
}

