/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jaxrs;

import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.EmptyTokenEndpoint;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.InvalidTokenTest;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.TCKApplication;
import org.eclipse.microprofile.jwt.tck.util.MpJwtTestVersion;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EmptyTokenTest
extends Arquillian {
    @ArquillianResource
    private URL baseURL;

    @Deployment
    public static WebArchive createDeployment() {
        URL config = InvalidTokenTest.class.getResource("/META-INF/microprofile-config-publickey-location.properties");
        URL publicKey = InvalidTokenTest.class.getResource("/publicKey.pem");
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"EmptyTokenTest.war")).addAsManifestResource((Asset)new StringAsset(MpJwtTestVersion.MPJWT_V_1_2.name()), "MPJWTTESTVERSION")).addAsResource(publicKey, "/publicKey.pem")).addClass(TCKApplication.class)).addClass(EmptyTokenEndpoint.class)).addAsWebInfResource("beans.xml", "beans.xml")).addAsManifestResource(config, "microprofile-config.properties");
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate that an empty JWT in injected in the endpoint")
    public void emptyToken() {
        String uri = this.baseURL.toExternalForm() + "endp/verifyEmptyToken";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri);
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Assert.assertTrue((boolean)reply.getBoolean("pass"));
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate that a token sent to an unauthenticated / unauthorized endpoint is verified")
    public void invalidToken() {
        String uri = this.baseURL.toExternalForm() + "endp/verifyEmptyToken";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)"Bearer something").get();
        Assert.assertEquals((int)response.getStatus(), (int)401);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate that a token sent to an unauthenticated / unauthorized endpoint is verified and injected as non-empty")
    public void validToken() throws Exception {
        String token = TokenUtils.generateTokenString((String)"/Token1.json");
        String uri = this.baseURL.toExternalForm() + "endp/verifyNonEmptyToken";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Assert.assertTrue((boolean)reply.getBoolean("pass"));
    }
}

