/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jaxrs;

import java.util.Optional;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.json.Json;
import javax.json.JsonObject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;

@Path(value="/endp")
@RequestScoped
@RolesAllowed(value={"Tester"})
public class RequiredClaimsEndpoint {
    @Inject
    private JsonWebToken rawTokenJson;

    @GET
    @Path(value="/verifyIssuer")
    @Produces(value={"application/json"})
    public JsonObject verifyIssuer(@QueryParam(value="iss") String iss) {
        String msg;
        boolean pass = false;
        String issValue = this.rawTokenJson.getIssuer();
        if (issValue == null || issValue.length() == 0) {
            msg = Claims.iss.name() + "value is null or empty, FAIL";
        } else if (issValue.equals(iss)) {
            msg = Claims.iss.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.iss.name(), issValue, iss);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyRawToken")
    @Produces(value={"application/json"})
    public JsonObject verifyRawToken(@QueryParam(value="raw_token") String rt) {
        String msg;
        boolean pass = false;
        String rawTokenValue = this.rawTokenJson.getRawToken();
        if (rawTokenValue == null || rawTokenValue.length() == 0) {
            msg = Claims.raw_token.name() + "value is null or empty, FAIL";
        } else if (rawTokenValue.equals(rt)) {
            msg = Claims.raw_token.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.raw_token.name(), rawTokenValue, rt);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyJTI")
    @Produces(value={"application/json"})
    public JsonObject verifyJTI(@QueryParam(value="jti") String jwtID) {
        String msg;
        boolean pass = false;
        String jtiValue = this.rawTokenJson.getTokenID();
        if (jtiValue == null || jtiValue.length() == 0) {
            msg = Claims.jti.name() + "value is null or empty, FAIL";
        } else if (jtiValue.equals(jwtID)) {
            msg = Claims.jti.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.jti.name(), jtiValue, jwtID);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyUPN")
    @Produces(value={"application/json"})
    public JsonObject verifyUPN(@QueryParam(value="upn") String upn) {
        String msg;
        boolean pass = false;
        String upnValue = this.rawTokenJson.getName();
        if (upnValue == null || upnValue.length() == 0) {
            msg = Claims.upn.name() + "value is null or empty, FAIL";
        } else if (upnValue.equals(upn)) {
            msg = Claims.upn.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.upn.name(), upnValue, upn);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifySUB")
    @Produces(value={"application/json"})
    public JsonObject verifySUB(@QueryParam(value="sub") String sub) {
        String msg;
        boolean pass = false;
        String subValue = this.rawTokenJson.getSubject();
        if (subValue == null || subValue.length() == 0) {
            msg = Claims.sub.name() + "value is null or empty, FAIL";
        } else if (subValue.equals(sub)) {
            msg = Claims.sub.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.sub.name(), subValue, sub);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyAudience")
    @Produces(value={"application/json"})
    public JsonObject verifyAudience(@QueryParam(value="aud") String audience) {
        String msg;
        boolean pass = false;
        Set audValue = this.rawTokenJson.getAudience();
        if (audValue != null) {
            msg = Claims.aud.name() + "value is NOT null, FAIL";
        } else {
            msg = Claims.aud.name() + " PASS";
            pass = true;
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyOptionalAudience")
    @Produces(value={"application/json"})
    public JsonObject verifyAudience2(@QueryParam(value="aud") String audience) {
        String msg;
        boolean pass = false;
        Optional audValue = this.rawTokenJson.claim("aud");
        if (audValue.isPresent()) {
            msg = Claims.aud.name() + "value IS present, FAIL";
        } else {
            msg = Claims.aud.name() + " PASS";
            pass = true;
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyIssuedAt")
    @Produces(value={"application/json"})
    public JsonObject verifyIssuedAt(@QueryParam(value="iat") Long iat) {
        String msg;
        boolean pass = false;
        Long iatValue = this.rawTokenJson.getIssuedAtTime();
        if (iatValue == null || iatValue.intValue() == 0) {
            msg = Claims.iat.name() + "value is null or empty, FAIL";
        } else if (iatValue.equals(iat)) {
            msg = Claims.iat.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.iat.name(), iatValue, iat);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyExpiration")
    @Produces(value={"application/json"})
    public JsonObject verifyExpiration(@QueryParam(value="exp") Long exp) {
        String msg;
        boolean pass = false;
        Long expValue = this.rawTokenJson.getExpirationTime();
        if (expValue == null || expValue.intValue() == 0) {
            msg = Claims.exp.name() + "value is null or empty, FAIL";
        } else if (expValue.equals(exp)) {
            msg = Claims.exp.name() + " PASS";
            pass = true;
        } else {
            msg = String.format("%s: %s != %s", Claims.exp.name(), expValue, exp);
        }
        JsonObject result = Json.createObjectBuilder().add("pass", pass).add("msg", msg).build();
        return result;
    }

    @GET
    @Path(value="/verifyTokenWithoutExpiration")
    public Response verifyTokenWithoutExpiration() {
        throw new RuntimeException("This method must not be invoked");
    }

    @GET
    @Path(value="/verifyTokenWithoutName")
    public Response verifyTokenWithoutName() {
        throw new RuntimeException("This method must not be invoked");
    }

    @GET
    @Path(value="/verifyTokenWithoutClaim")
    public Response verifyTokenWithoutClaim() {
        throw new RuntimeException("This method must not be invoked");
    }

    @GET
    @Path(value="/verifyTokenWithIatOlderThanExp")
    public Response verifyTokenWithIatOlderThanExp() {
        throw new RuntimeException("This method must not be invoked");
    }
}

