/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jaxrs;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Collections;
import java.util.HashMap;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.RequiredClaimsEndpoint;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.TCKApplication;
import org.eclipse.microprofile.jwt.tck.util.MpJwtTestVersion;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RequiredClaimsTest
extends Arquillian {
    private static String token;
    private static Long iatClaim;
    private static Long authTimeClaim;
    private static Long expClaim;
    @ArquillianResource
    private URL baseURL;

    @Deployment(testable=true)
    public static WebArchive createDeployment() throws IOException {
        URL config = RequiredClaimsTest.class.getResource("/META-INF/microprofile-config-publickey-location.properties");
        URL publicKey = RequiredClaimsTest.class.getResource("/publicKey.pem");
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"RequiredClaimsTest.war")).addAsManifestResource((Asset)new StringAsset(MpJwtTestVersion.MPJWT_V_1_0.name()), "MPJWTTESTVERSION")).addAsResource(publicKey, "/publicKey.pem")).addClass(RequiredClaimsEndpoint.class)).addClass(TCKApplication.class)).addAsWebInfResource("beans.xml", "beans.xml")).addAsManifestResource(config, "microprofile-config.properties");
        System.out.printf("WebArchive: %s\n", webArchive.toString(true));
        return webArchive;
    }

    @BeforeClass(alwaysRun=true)
    public static void generateToken() throws Exception {
        HashMap timeClaims = new HashMap();
        token = TokenUtils.generateTokenString((String)"/RequiredClaims.json", null, timeClaims);
        iatClaim = (Long)timeClaims.get(Claims.iat.name());
        authTimeClaim = (Long)timeClaims.get(Claims.auth_time.name());
        expClaim = (Long)timeClaims.get(Claims.exp.name());
    }

    @RunAsClient
    @Test(groups={"jwt"}, description="Verify that the token issuer claim is as expected")
    public void verifyIssuerClaim() throws Exception {
        Reporter.log((String)"Begin verifyIssuerClaim");
        String uri = this.baseURL.toExternalForm() + "endp/verifyIssuer";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.iss.name(), new Object[]{"https://server.example.com"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"jwt"}, description="Verify that the token sub claim is as expected")
    public void verifySubClaim() throws Exception {
        Reporter.log((String)"Begin verifySubClaim");
        String uri = this.baseURL.toExternalForm() + "endp/verifySUB";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.sub.name(), new Object[]{"24400320"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"jwt"}, description="Verify that the jti claim is as expected")
    public void verifyJTI() throws Exception {
        Reporter.log((String)"Begin verifyJTI\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyJTI";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.jti.name(), new Object[]{"a-f2b2180c"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"jwt"}, description="Verify that the uPN claim is as expected")
    public void verifyUPN() throws Exception {
        Reporter.log((String)"Begin verifyUPN\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyUPN";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.upn.name(), new Object[]{"jdoe@example.com"}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"jwt"}, description="Verify that the aud claim is as expected")
    public void verifyAudience() throws Exception {
        Reporter.log((String)"Begin verifyAudience\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyAudience";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.aud.name(), null).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"jwt"}, description="Verify that the aud claim is as expected")
    public void verifyOptionalAudience() throws Exception {
        Reporter.log((String)"Begin verifyOptionalAudience\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyOptionalAudience";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.aud.name(), null).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"jwt"}, description="Verify that the iat claim is as expected")
    public void verifyIssuedAt() throws Exception {
        Reporter.log((String)"Begin verifyIssuedAt\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyIssuedAt";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.iat.name(), new Object[]{iatClaim}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"jwt"}, description="Verify that the exp claim is as expected")
    public void verifyExpiration() throws Exception {
        Reporter.log((String)"Begin verifyExpiration\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyExpiration";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam(Claims.exp.name(), new Object[]{expClaim}).queryParam(Claims.auth_time.name(), new Object[]{authTimeClaim});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }

    @RunAsClient
    @Test(groups={"jwt"}, description="Verify that HTTP 401 status is returned if the token contains no exp claim")
    public void verifyTokenWithoutExpiration() throws Exception {
        RSAPrivateKey pk = TokenUtils.readPrivateKey((String)"/privateKey.pem");
        String tokenWithoutExp = TokenUtils.signClaims((PrivateKey)pk, (String)"1", (String)"/TokenWithoutExp.json", Collections.singleton(TokenUtils.InvalidClaims.EXP), null);
        Reporter.log((String)"Begin verifyTokenWithoutExpiration\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyTokenWithoutExpiration";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri);
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + tokenWithoutExp)).get();
        Assert.assertEquals((int)response.getStatus(), (int)401);
    }

    @RunAsClient
    @Test(groups={"jwt"}, description="Verify that HTTP 401 status is returned if the token contains no 'upn', 'preferred_username' and 'sub' claims")
    public void verifyTokenWithoutName() throws Exception {
        String tokenWithoutName = TokenUtils.signClaims((String)"/TokenWithoutName.json");
        Reporter.log((String)"Begin verifyTokenWithoutName\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyTokenWithoutName";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri);
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + tokenWithoutName)).get();
        Assert.assertEquals((int)response.getStatus(), (int)401);
    }

    @RunAsClient
    @Test(groups={"jwt"}, description="Verify that HTTP 401 status is returned if the token 'iat' claim is older than 'exp' claim")
    public void verifyTokenWithIatOlderThanExp() throws Exception {
        RSAPrivateKey pk = TokenUtils.readPrivateKey((String)"/privateKey.pem");
        String tokenWithIatOlderThanExp = TokenUtils.signClaims((PrivateKey)pk, (String)"1", (String)"/TokenWithIatOlderThanExp.json", Collections.singleton(TokenUtils.InvalidClaims.IAT), null);
        Reporter.log((String)"Begin verifyTokenWithIatOlderThanExp\n");
        String uri = this.baseURL.toExternalForm() + "endp/verifyTokenWithIatOlderThanExp";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri);
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + tokenWithIatOlderThanExp)).get();
        Assert.assertEquals((int)response.getStatus(), (int)401);
    }
}

