/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.container.jaxrs;

import java.io.IOException;
import java.net.URL;
import java.util.Base64;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.RolesEndpoint;
import org.eclipse.microprofile.jwt.tck.container.jaxrs.TCKApplication;
import org.eclipse.microprofile.jwt.tck.util.MpJwtTestVersion;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class RolesAllowedTest
extends Arquillian {
    private static String token;
    @ArquillianResource
    private URL baseURL;

    @Deployment(testable=true)
    public static WebArchive createDeployment() throws IOException {
        URL config = RolesAllowedTest.class.getResource("/META-INF/microprofile-config-publickey-location.properties");
        URL publicKey = RolesAllowedTest.class.getResource("/publicKey.pem");
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"RolesAllowedTest.war")).addAsManifestResource((Asset)new StringAsset(MpJwtTestVersion.MPJWT_V_1_0.name()), "MPJWTTESTVERSION")).addAsResource(publicKey, "/publicKey.pem")).addClass(RolesEndpoint.class)).addClass(TCKApplication.class)).addAsWebInfResource("beans.xml", "beans.xml")).addAsManifestResource(config, "microprofile-config.properties");
        System.out.printf("WebArchive: %s\n", webArchive.toString(true));
        return webArchive;
    }

    @BeforeClass(alwaysRun=true)
    public static void generateToken() throws Exception {
        token = TokenUtils.generateTokenString((String)"/Token1.json");
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with no token fails with HTTP_UNAUTHORIZED")
    public void callEchoNoAuth() throws Exception {
        Reporter.log((String)"callEchoNoAuth, expect HTTP_UNAUTHORIZED");
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).get();
        Assert.assertEquals((int)response.getStatus(), (int)401);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Attempting access with BASIC auth header should fail with HTTP_UNAUTHORIZED")
    public void callEchoBASIC() throws Exception {
        Reporter.log((String)"callEchoBASIC, expect HTTP_UNAUTHORIZED");
        byte[] tokenb = Base64.getEncoder().encode("jdoe@example.com:password".getBytes());
        String token = new String(tokenb);
        System.out.printf("basic: %s\n", token);
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("BASIC " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)401);
        String reply = (String)response.readEntity(String.class);
        System.out.println(reply);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with MP-JWT succeeds with HTTP_OK, and replies with hello, user={token upn claim}")
    public void callEcho() throws Exception {
        Reporter.log((String)"callEcho, expect HTTP_OK");
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String reply = (String)response.readEntity(String.class);
        Assert.assertEquals((String)reply, (String)"hello, user=jdoe@example.com");
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with MP-JWT which fails with HTTP_UNAUTHORIZED when token is signed and encrypted")
    public void callEchoSignToken() throws Exception {
        Reporter.log((String)"callEcho, expect HTTP_UNAUTHORIZED");
        String signEncryptToken = TokenUtils.signEncryptClaims((String)"/Token1.json");
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + signEncryptToken)).get();
        Assert.assertEquals((int)response.getStatus(), (int)401);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with MP-JWT which fails with HTTP_UNAUTHORIZED when token is encrypted")
    public void callEchoSignEncryptToken() throws Exception {
        Reporter.log((String)"callEcho, expect HTTP_UNAUTHORIZED");
        String encryptToken = TokenUtils.encryptClaims((String)"/Token1.json");
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + encryptToken)).get();
        Assert.assertEquals((int)response.getStatus(), (int)401);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with MP-JWT without a groups claim succeeds with HTTP_OK}")
    public void callEchoNoGroups() throws Exception {
        Reporter.log((String)"callEcho, expect HTTP_OK");
        String tokenNoGroups = TokenUtils.generateTokenString((String)"/TokenNoGroups.json");
        String uri = this.baseURL.toExternalForm() + "endp/echo-permit-all";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + tokenNoGroups)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String reply = (String)response.readEntity(String.class);
        Assert.assertEquals((String)reply, (String)"hello, permitAll, user=jdoe@example.com");
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with MP-JWT but no associated role fails with HTTP_FORBIDDEN")
    public void callEcho2() throws Exception {
        Reporter.log((String)"callEcho2, expect HTTP_FORBIDDEN");
        String uri = this.baseURL.toExternalForm() + "endp/echo2";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token)).get();
        String reply = (String)response.readEntity(String.class);
        Assert.assertEquals((int)response.getStatus(), (int)403);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with MP-JWT is able to access checkIsUserInRole with HTTP_OK")
    public void checkIsUserInRole() throws Exception {
        Reporter.log((String)"checkIsUserInRole, expect HTTP_OK");
        String uri = this.baseURL.toExternalForm() + "endp/checkIsUserInRole";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri);
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token)).get();
        String reply = (String)response.readEntity(String.class);
        Assert.assertEquals((int)response.getStatus(), (int)200);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with MP-JWT Token2 fails to access checkIsUserInRole with HTTP_FORBIDDEN")
    public void checkIsUserInRoleToken2() throws Exception {
        Reporter.log((String)"checkIsUserInRoleToken2, expect HTTP_FORBIDDEN");
        String token2 = TokenUtils.generateTokenString((String)"/Token2.json");
        String uri = this.baseURL.toExternalForm() + "endp/checkIsUserInRole";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri);
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token2)).get();
        String reply = (String)response.readEntity(String.class);
        Assert.assertEquals((int)response.getStatus(), (int)403);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with MP-JWT Token2 is able to access echoNeedsToken2Role with HTTP_OK")
    public void echoNeedsToken2Role() throws Exception {
        Reporter.log((String)"echoNeedsToken2Role, expect HTTP_FORBIDDEN");
        String token2 = TokenUtils.generateTokenString((String)"/Token2.json");
        String uri = this.baseURL.toExternalForm() + "endp/echoNeedsToken2Role";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token2)).get();
        String reply = (String)response.readEntity(String.class);
        Assert.assertEquals((int)response.getStatus(), (int)200);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with MP-JWT Token2 calling echo fails with HTTP_FORBIDDEN")
    public void echoWithToken2() throws Exception {
        Reporter.log((String)"echoWithToken2, expect HTTP_FORBIDDEN");
        String token2 = TokenUtils.generateTokenString((String)"/Token2.json");
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token2)).get();
        String reply = (String)response.readEntity(String.class);
        Assert.assertEquals((int)response.getStatus(), (int)403);
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request with MP-JWT SecurityContext.getUserPrincipal() is a JsonWebToken")
    public void getPrincipalClass() throws Exception {
        Reporter.log((String)"getPrincipalClass, expect HTTP_OK");
        String uri = this.baseURL.toExternalForm() + "endp/getPrincipalClass";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri);
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String reply = (String)response.readEntity(String.class);
        Assert.assertEquals((String)reply, (String)"isJsonWebToken:true");
    }

    @RunAsClient
    @Test(groups={"ee-security-optional"}, description="Validate a request without an MP-JWT to endpoint requiring role mapping has HTTP_OK")
    public void testNeedsGroup1Mapping() {
        Reporter.log((String)"testNeedsGroup1Mapping, expect HTTP_OK");
        String uri = this.baseURL.toExternalForm() + "endp/needsGroup1Mapping";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri);
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String reply = (String)response.readEntity(String.class);
        System.out.println(reply);
    }

    @RunAsClient
    @Test(groups={"cdi"}, description="Validate that accessing secured method has HTTP_OK and injected JsonWebToken principal")
    public void getInjectedPrincipal() throws Exception {
        Reporter.log((String)"getInjectedPrincipal, expect HTTP_OK");
        String uri = this.baseURL.toExternalForm() + "endp/getInjectedPrincipal";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri);
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String reply = (String)response.readEntity(String.class);
        Assert.assertEquals((String)reply, (String)"isJsonWebToken:true");
    }

    @RunAsClient
    @Test(groups={"jaxrs"}, description="Validate a request without an MP-JWT to unsecured endpoint has HTTP_OK with expected response")
    public void callHeartbeat() throws Exception {
        Reporter.log((String)"callHeartbeat, expect HTTP_OK");
        String uri = this.baseURL.toExternalForm() + "endp/heartbeat";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String reply = (String)response.readEntity(String.class);
        Assert.assertTrue((boolean)reply.startsWith("Heartbeat:"), (String)"Saw Heartbeat: ...");
    }

    @RunAsClient
    @Test(groups={"config"}, description="Validate a request with a valid JWT in a Cookie but no Token Header set fails with HTTP_UNAUTHORIZED")
    public void noTokenHeaderSetToCookie() throws Exception {
        String token = TokenUtils.generateTokenString((String)"/Token1.json");
        String uri = this.baseURL.toExternalForm() + "endp/echo";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("input", new Object[]{"hello"});
        Response response = echoEndpointTarget.request(new String[]{"text/plain"}).cookie("Bearer", token).get();
        Assert.assertEquals((int)response.getStatus(), (int)401);
    }
}

