/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.config.jwe;

import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URL;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.Properties;
import org.eclipse.microprofile.jwt.tck.config.JwksApplication;
import org.eclipse.microprofile.jwt.tck.config.SimpleTokenUtils;
import org.eclipse.microprofile.jwt.tck.config.jwe.PrivateKeyAsPEMClasspathTest;
import org.eclipse.microprofile.jwt.tck.config.jwe.PrivateKeyEndpoint;
import org.eclipse.microprofile.jwt.tck.util.MpJwtTestVersion;
import org.eclipse.microprofile.jwt.tck.util.TokenUtils;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.Reporter;
import org.testng.annotations.Test;

public class PrivateKeyAsJWKSClasspathTest
extends Arquillian {
    @ArquillianResource
    private URL baseURL;

    @Deployment
    public static WebArchive createLocationDeployment() throws IOException {
        URL publicKey = PrivateKeyAsPEMClasspathTest.class.getResource("/publicKey4k.pem");
        URL decryptorJwk = PrivateKeyAsJWKSClasspathTest.class.getResource("/decryptorPrivateKeySet.jwk");
        Properties configProps = new Properties();
        configProps.setProperty("mp.jwt.verify.publickey.location", "/publicKey4k.pem");
        configProps.setProperty("mp.jwt.decrypt.key.location", "/decryptorPrivateKeySet.jwk");
        configProps.setProperty("mp.jwt.verify.issuer", "https://server.example.com");
        StringWriter configSW = new StringWriter();
        configProps.store(configSW, "PrivateKeyAsJWKSClasspathTest microprofile-config.properties");
        StringAsset configAsset = new StringAsset(configSW.toString());
        WebArchive webArchive = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"PrivateKeyAsJWKSClasspathTest.war")).addAsManifestResource((Asset)new StringAsset(MpJwtTestVersion.MPJWT_V_1_2.name()), "MPJWTTESTVERSION")).addAsResource(publicKey, "/publicKey4k.pem")).addAsResource(decryptorJwk, "/decryptorPrivateKeySet.jwk")).addClass(PrivateKeyEndpoint.class)).addClass(JwksApplication.class)).addClass(SimpleTokenUtils.class)).addAsWebInfResource("beans.xml", "beans.xml")).addAsManifestResource((Asset)configAsset, "microprofile-config.properties");
        return webArchive;
    }

    @RunAsClient
    @Test(groups={"config"}, description="Validate specifying the mp.jwt.decrypt.key.location as resource path to a JWKS key")
    public void testKeyAsLocation() throws Exception {
        Reporter.log((String)"testKeyAsLocation, expect HTTP_OK");
        RSAPrivateKey signingKey = TokenUtils.readPrivateKey((String)"/privateKey4k.pem");
        PublicKey publicKey = TokenUtils.readJwkPublicKey((String)"/encryptorPublicKey.jwk");
        String kid = "mp-jwt-set";
        String token = TokenUtils.signEncryptClaims((PrivateKey)signingKey, null, (PublicKey)publicKey, (String)kid, (String)"/Token1.json", (boolean)true);
        String uri = this.baseURL.toExternalForm() + "jwks/endp/verifyKeyLocationAsJWKSResource";
        WebTarget echoEndpointTarget = ClientBuilder.newClient().target(uri).queryParam("kid", new Object[]{kid});
        Response response = echoEndpointTarget.request(new String[]{"application/json"}).header("Authorization", (Object)("Bearer " + token)).get();
        Assert.assertEquals((int)response.getStatus(), (int)200);
        String replyString = (String)response.readEntity(String.class);
        JsonReader jsonReader = Json.createReader((Reader)new StringReader(replyString));
        JsonObject reply = jsonReader.readObject();
        Reporter.log((String)reply.toString());
        Assert.assertTrue((boolean)reply.getBoolean("pass"), (String)reply.getString("msg"));
    }
}

