/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.jwt.tck.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Collections;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.tck.util.KeyManagementAlgorithm;
import org.eclipse.microprofile.jwt.tck.util.SignatureAlgorithm;
import org.jose4j.json.JsonUtil;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.NumericDate;

public class TokenUtils {
    private TokenUtils() {
    }

    @Deprecated
    public static String generateTokenString(String jsonResName) throws Exception {
        return TokenUtils.signClaims(jsonResName);
    }

    public static String signClaims(String jsonResName) throws Exception {
        return TokenUtils.signClaims(jsonResName, SignatureAlgorithm.RS256);
    }

    public static String signClaims(String jsonResName, SignatureAlgorithm algorithm) throws Exception {
        return TokenUtils.signClaims(jsonResName, algorithm, Collections.emptySet());
    }

    @Deprecated
    public static String generateTokenString(String jsonResName, Set<InvalidClaims> invalidClaims) throws Exception {
        return TokenUtils.signClaims(jsonResName, SignatureAlgorithm.RS256, invalidClaims);
    }

    public static String signClaims(String jsonResName, SignatureAlgorithm algorithm, Set<InvalidClaims> invalidClaims) throws Exception {
        return TokenUtils.signClaims(jsonResName, algorithm, invalidClaims, null);
    }

    @Deprecated
    public static String generateTokenString(String jsonResName, Set<InvalidClaims> invalidClaims, Map<String, Long> timeClaims) throws Exception {
        return TokenUtils.signClaims(jsonResName, SignatureAlgorithm.RS256, invalidClaims, timeClaims);
    }

    public static String signClaims(String jsonResName, SignatureAlgorithm algorithm, Set<InvalidClaims> invalidClaims, Map<String, Long> timeClaims) throws Exception {
        PrivateKey pk = null;
        pk = algorithm == SignatureAlgorithm.RS256 ? TokenUtils.readPrivateKey("/privateKey.pem") : TokenUtils.readECPrivateKey("/ecPrivateKey.pem");
        return TokenUtils.signClaims(pk, jsonResName, jsonResName, invalidClaims, timeClaims);
    }

    @Deprecated
    public static String generateTokenString(PrivateKey pk, String kid, String jsonResName, Set<InvalidClaims> invalidClaims, Map<String, Long> timeClaims) throws Exception {
        return TokenUtils.signClaims(pk, kid, jsonResName, invalidClaims, timeClaims);
    }

    public static String signClaims(PrivateKey pk, String kid, String jsonResName) throws Exception {
        return TokenUtils.signClaims(pk, kid, jsonResName, null, null);
    }

    public static String signClaims(PrivateKey pk, String kid, String jsonResName, Set<InvalidClaims> invalidClaims, Map<String, Long> timeClaims) throws Exception {
        if (invalidClaims == null) {
            invalidClaims = Collections.emptySet();
        }
        JwtClaims claims = TokenUtils.createJwtClaims(jsonResName, invalidClaims, timeClaims);
        JsonWebSignature jws = new JsonWebSignature();
        jws.setPayload(claims.toJson());
        if (kid != null) {
            jws.setKeyIdHeaderValue(kid);
        }
        jws.setHeader("typ", "JWT");
        if (invalidClaims.contains((Object)InvalidClaims.ALG)) {
            jws.setAlgorithmHeaderValue("HS256");
            jws.setKey((Key)KeyGenerator.getInstance("HMACSHA256").generateKey());
        } else {
            jws.setAlgorithmHeaderValue(pk instanceof RSAPrivateKey ? "RS256" : "ES256");
            if (invalidClaims.contains((Object)InvalidClaims.SIGNER)) {
                pk = TokenUtils.generateKeyPair(2048).getPrivate();
            }
            jws.setKey((Key)pk);
        }
        jws.setDoKeyValidation(false);
        return jws.getCompactSerialization();
    }

    public static String encryptClaims(String jsonResName) throws Exception {
        return TokenUtils.encryptClaims(jsonResName, Collections.emptySet());
    }

    public static String encryptClaims(String jsonResName, Set<InvalidClaims> invalidClaims) throws Exception {
        return TokenUtils.encryptClaims(jsonResName, invalidClaims, null);
    }

    public static String encryptClaims(String jsonResName, Set<InvalidClaims> invalidClaims, Map<String, Long> timeClaims) throws Exception {
        RSAPublicKey pk = TokenUtils.readPublicKey("/publicKey.pem");
        return TokenUtils.encryptClaims(pk, jsonResName, jsonResName, invalidClaims, timeClaims);
    }

    public static String encryptClaims(PublicKey pk, String jsonResName) throws Exception {
        return TokenUtils.encryptClaims(pk, jsonResName, jsonResName);
    }

    public static String encryptClaims(PublicKey pk, String kid, String jsonResName) throws Exception {
        return TokenUtils.encryptClaims(pk, kid, jsonResName, null, null);
    }

    public static String encryptClaims(PublicKey pk, String kid, String jsonResName, Set<InvalidClaims> invalidClaims, Map<String, Long> timeClaims) throws Exception {
        return TokenUtils.encryptClaims(pk, null, kid, jsonResName, invalidClaims, timeClaims);
    }

    public static String encryptClaims(PublicKey pk, KeyManagementAlgorithm keyAlgorithm, String kid, String jsonResName, Set<InvalidClaims> invalidClaims, Map<String, Long> timeClaims) throws Exception {
        if (invalidClaims == null) {
            invalidClaims = Collections.emptySet();
        }
        JwtClaims claims = TokenUtils.createJwtClaims(jsonResName, invalidClaims, timeClaims);
        Key key = null;
        if (invalidClaims.contains((Object)InvalidClaims.ENCRYPTOR)) {
            KeyPair keyPair = TokenUtils.generateKeyPair(2048);
            key = keyPair.getPublic();
        } else if (invalidClaims.contains((Object)InvalidClaims.ALG)) {
            KeyGenerator aes = KeyGenerator.getInstance("AES");
            aes.init(256);
            key = aes.generateKey();
        } else {
            key = pk;
        }
        return TokenUtils.encryptString(key, keyAlgorithm, kid, claims.toJson(), false);
    }

    public static String signEncryptClaims(String jsonResName) throws Exception {
        return TokenUtils.signEncryptClaims(jsonResName, SignatureAlgorithm.RS256);
    }

    public static String signEncryptClaims(String jsonResName, SignatureAlgorithm signatureAlgorithm) throws Exception {
        PrivateKey signingKey = null;
        signingKey = signatureAlgorithm == SignatureAlgorithm.RS256 ? TokenUtils.readPrivateKey("/privateKey.pem") : TokenUtils.readECPrivateKey("/ecPrivateKey.pem");
        RSAPublicKey encryptionKey = TokenUtils.readPublicKey("/publicKey.pem");
        return TokenUtils.signEncryptClaims(signingKey, encryptionKey, jsonResName);
    }

    public static String signEncryptClaims(PrivateKey signingKey, PublicKey encryptionKey, String jsonResName) throws Exception {
        return TokenUtils.signEncryptClaims(signingKey, jsonResName + "-signed", encryptionKey, jsonResName + "-encrypted", jsonResName);
    }

    public static String signEncryptClaims(PrivateKey signingKey, String signingKid, PublicKey encryptionKey, String encryptionKid, String jsonResName) throws Exception {
        return TokenUtils.signEncryptClaims(signingKey, signingKid, encryptionKey, encryptionKid, jsonResName, true);
    }

    public static String signEncryptClaims(PrivateKey signingKey, String signingKid, PublicKey encryptionKey, String encryptionKid, String jsonResName, boolean setContentType) throws Exception {
        return TokenUtils.signEncryptClaims(signingKey, signingKid, encryptionKey, null, encryptionKid, jsonResName, setContentType);
    }

    public static String signEncryptClaims(PrivateKey signingKey, String signingKid, PublicKey encryptionKey, KeyManagementAlgorithm keyAlgorithm, String encryptionKid, String jsonResName, boolean setContentType) throws Exception {
        String nestedJwt = TokenUtils.signClaims(signingKey, signingKid, jsonResName, null, null);
        return TokenUtils.encryptString(encryptionKey, keyAlgorithm, encryptionKid, nestedJwt, setContentType);
    }

    private static String encryptString(Key key, KeyManagementAlgorithm keyAlgorithm, String kid, String plainText, boolean setContentType) throws Exception {
        JsonWebEncryption jwe = new JsonWebEncryption();
        jwe.setPlaintext(plainText);
        if (kid != null) {
            jwe.setKeyIdHeaderValue(kid);
        }
        if (setContentType && plainText.split("\\.").length == 3) {
            jwe.setHeader("cty", "JWT");
        }
        jwe.setEncryptionMethodHeaderParameter("A256GCM");
        if (keyAlgorithm != null) {
            jwe.setAlgorithmHeaderValue(keyAlgorithm.getAlgorithm());
        } else if (key instanceof SecretKey) {
            int keyLength = ((SecretKey)key).getEncoded().length * 8;
            if (keyLength != 256 && keyLength != 192 && keyLength != 128) {
                throw new IllegalStateException("Invalid AES secret key length (valid values are 256, 192 or 128): " + keyLength);
            }
            jwe.setAlgorithmHeaderValue("A" + keyLength + "KW");
        } else {
            jwe.setAlgorithmHeaderValue("RSA-OAEP");
        }
        jwe.setKey(key);
        return jwe.getCompactSerialization();
    }

    private static JwtClaims createJwtClaims(String jsonResName, Set<InvalidClaims> invalidClaims, Map<String, Long> timeClaims) throws Exception {
        long iat;
        String content = TokenUtils.readJsonContent(jsonResName);
        JwtClaims claims = JwtClaims.parse((String)content);
        if (invalidClaims.contains((Object)InvalidClaims.ISSUER)) {
            claims.setIssuer("INVALID_ISSUER");
        }
        long currentTimeInSecs = TokenUtils.currentTimeInSecs();
        long exp = currentTimeInSecs + 300L;
        long authTime = iat = currentTimeInSecs;
        boolean expWasInput = false;
        if (timeClaims != null && timeClaims.containsKey(Claims.exp.name())) {
            exp = timeClaims.get(Claims.exp.name());
            expWasInput = true;
        }
        if (expWasInput) {
            authTime = iat = exp - 5L;
        } else if (invalidClaims.contains((Object)InvalidClaims.IAT)) {
            authTime = iat = exp + 5L;
        }
        claims.setIssuedAt(NumericDate.fromSeconds((long)iat));
        claims.setClaim(Claims.auth_time.name(), (Object)authTime);
        if (!invalidClaims.contains((Object)InvalidClaims.EXP)) {
            claims.setExpirationTime(NumericDate.fromSeconds((long)exp));
        }
        if (timeClaims != null) {
            timeClaims.put(Claims.iat.name(), iat);
            timeClaims.put(Claims.auth_time.name(), authTime);
            timeClaims.put(Claims.exp.name(), exp);
        }
        return claims;
    }

    private static String readJsonContent(String jsonResName) throws IOException {
        InputStream contentIS = TokenUtils.class.getResourceAsStream(jsonResName);
        if (contentIS == null) {
            throw new IllegalStateException("Failed to find resource: " + jsonResName);
        }
        try (Scanner s = new Scanner(contentIS);){
            s.useDelimiter("\\A");
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
    }

    public static String readResource(String resName) throws IOException {
        InputStream is = TokenUtils.class.getResourceAsStream(resName);
        StringWriter sw = new StringWriter();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String line = br.readLine();
            while (line != null) {
                sw.write(line);
                sw.write(10);
                line = br.readLine();
            }
        }
        return sw.toString();
    }

    public static RSAPrivateKey readPrivateKey(String pemResName) throws Exception {
        InputStream contentIS = TokenUtils.class.getResourceAsStream(pemResName);
        byte[] tmp = new byte[4096];
        int length = contentIS.read(tmp);
        return TokenUtils.decodePrivateKey(new String(tmp, 0, length));
    }

    public static ECPrivateKey readECPrivateKey(String pemResName) throws Exception {
        InputStream contentIS = TokenUtils.class.getResourceAsStream(pemResName);
        byte[] tmp = new byte[4096];
        int length = contentIS.read(tmp);
        return TokenUtils.decodeECPrivateKey(new String(tmp, 0, length));
    }

    public static RSAPublicKey readPublicKey(String pemResName) throws Exception {
        InputStream contentIS = TokenUtils.class.getResourceAsStream(pemResName);
        byte[] tmp = new byte[4096];
        int length = contentIS.read(tmp);
        return TokenUtils.decodePublicKey(new String(tmp, 0, length));
    }

    public static ECPublicKey readECPublicKey(String pemResName) throws Exception {
        InputStream contentIS = TokenUtils.class.getResourceAsStream(pemResName);
        byte[] tmp = new byte[4096];
        int length = contentIS.read(tmp);
        return TokenUtils.decodeECPublicKey(new String(tmp, 0, length));
    }

    public static PublicKey readJwkPublicKey(String jwkResName) throws Exception {
        JsonWebKey jwk = JsonWebKey.Factory.newJwk((Map)JsonUtil.parseJson((String)TokenUtils.readJsonContent(jwkResName)));
        return ((PublicJsonWebKey)PublicJsonWebKey.class.cast(jwk)).getPublicKey();
    }

    public static PrivateKey readJwkPrivateKey(String jwkResName) throws Exception {
        JsonWebKey jwk = JsonWebKey.Factory.newJwk((Map)JsonUtil.parseJson((String)TokenUtils.readJsonContent(jwkResName)));
        return ((PublicJsonWebKey)PublicJsonWebKey.class.cast(jwk)).getPrivateKey();
    }

    public static KeyPair generateKeyPair(int keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(keySize);
        return keyPairGenerator.genKeyPair();
    }

    public static RSAPrivateKey decodePrivateKey(String pemEncoded) throws Exception {
        byte[] encodedBytes = TokenUtils.toEncodedBytes(pemEncoded);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedBytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return (RSAPrivateKey)kf.generatePrivate(keySpec);
    }

    public static ECPrivateKey decodeECPrivateKey(String pemEncoded) throws Exception {
        byte[] encodedBytes = TokenUtils.toEncodedBytes(pemEncoded);
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedBytes);
        KeyFactory kf = KeyFactory.getInstance("EC");
        return (ECPrivateKey)kf.generatePrivate(keySpec);
    }

    public static RSAPublicKey decodePublicKey(String pemEncoded) throws Exception {
        byte[] encodedBytes = TokenUtils.toEncodedBytes(pemEncoded);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(encodedBytes);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return (RSAPublicKey)kf.generatePublic(spec);
    }

    public static ECPublicKey decodeECPublicKey(String pemEncoded) throws Exception {
        byte[] encodedBytes = TokenUtils.toEncodedBytes(pemEncoded);
        X509EncodedKeySpec spec = new X509EncodedKeySpec(encodedBytes);
        KeyFactory kf = KeyFactory.getInstance("EC");
        return (ECPublicKey)kf.generatePublic(spec);
    }

    private static byte[] toEncodedBytes(String pemEncoded) {
        String normalizedPem = TokenUtils.removeBeginEnd(pemEncoded);
        return Base64.getDecoder().decode(normalizedPem);
    }

    private static String removeBeginEnd(String pem) {
        pem = pem.replaceAll("-----BEGIN (.*)-----", "");
        pem = pem.replaceAll("-----END (.*)----", "");
        pem = pem.replaceAll("\r\n", "");
        pem = pem.replaceAll("\n", "");
        return pem.trim();
    }

    public static int currentTimeInSecs() {
        long currentTimeMS = System.currentTimeMillis();
        return (int)(currentTimeMS / 1000L);
    }

    public static enum InvalidClaims {
        ISSUER,
        IAT,
        EXP,
        SIGNER,
        ENCRYPTOR,
        ALG;

    }
}

