/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck.service;

import java.net.URI;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.eclipse.microprofile.lra.tck.service.LRAMetricService;
import org.eclipse.microprofile.lra.tck.service.LRAMetricType;
import org.eclipse.microprofile.lra.tck.service.LRATestService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;

@Dependent
public final class LRAMetricAssertions {
    @Inject
    private LRAMetricService lraMetricService;
    @Inject
    private LRATestService lraTestService;

    public void assertCompensated(String message, URI lraId, Class<?> participantClazz) {
        this.assertYes(message, LRAMetricType.Compensated, lraId, participantClazz);
    }

    public void assertNotCompensated(String message, URI lraId, Class<?> participantClazz) {
        this.assertNot(message, LRAMetricType.Compensated, lraId, participantClazz);
    }

    public void assertCompensatedEquals(String message, int expectedNumber, URI lraId, Class<?> participantClazz) {
        Assert.assertEquals((String)message, (long)expectedNumber, (long)this.lraMetricService.getMetric(LRAMetricType.Compensated, lraId, participantClazz));
    }

    public void assertCompensatedAllEquals(String message, int expectedNumber) {
        Assert.assertEquals((String)message, (long)expectedNumber, (long)this.lraMetricService.getMetricAll(LRAMetricType.Compensated));
    }

    public void assertCompleted(String message, URI lraId, Class<?> participantClazz) {
        this.assertYes(message, LRAMetricType.Completed, lraId, participantClazz);
    }

    public void assertNotCompleted(String message, URI lraId, Class<?> participantClazz) {
        this.assertNot(message, LRAMetricType.Completed, lraId, participantClazz);
    }

    public void assertCompletedEquals(String message, int expectedNumber, URI lraId, Class<?> participantClazz) {
        Assert.assertEquals((String)message, (long)expectedNumber, (long)this.lraMetricService.getMetric(LRAMetricType.Completed, lraId, participantClazz));
    }

    public void assertCompletedAllEquals(String message, int expectedNumber) {
        Assert.assertEquals((String)message, (long)expectedNumber, (long)this.lraMetricService.getMetricAll(LRAMetricType.Completed));
    }

    public void assertClosed(String message, URI lraId, Class<?> participantClazz) {
        this.assertYes(message, LRAMetricType.Closed, lraId, participantClazz);
    }

    public void assertNotClosed(String message, URI lraId, Class<?> participantClazz) {
        this.assertNot(message, LRAMetricType.Closed, lraId, participantClazz);
    }

    public void assertCancelled(String message, URI lraId, Class<?> participantClazz) {
        this.assertYes(message, LRAMetricType.Cancelled, lraId, participantClazz);
    }

    public void assertNotCancelled(String message, URI lraId, Class<?> participantClazz) {
        this.assertNot(message, LRAMetricType.Cancelled, lraId, participantClazz);
    }

    public void assertAfterLRA(String message, URI lraId, Class<?> participantClazz) {
        this.assertYes(message, LRAMetricType.AfterLRA, lraId, participantClazz);
    }

    public void assertNotAfterLRA(String message, URI lraId, Class<?> participantClazz) {
        this.assertNot(message, LRAMetricType.AfterLRA, lraId, participantClazz);
    }

    public void assertForget(String message, URI lraId, Class<?> participantClazz) {
        this.assertYes(message, LRAMetricType.Forget, lraId, participantClazz);
    }

    public void assertNotForget(String message, URI lraId, Class<?> participantClazz) {
        this.assertNot(message, LRAMetricType.Forget, lraId, participantClazz);
    }

    public void assertForgetEquals(String message, int expectedNumber, URI lraId, Class<?> participantClazz) {
        Assert.assertEquals((String)message, (long)expectedNumber, (long)this.lraMetricService.getMetric(LRAMetricType.Forget, lraId, participantClazz));
    }

    public void assertStatus(String message, URI lraId, Class<?> participantClazz) {
        this.assertYes(message, LRAMetricType.Status, lraId, participantClazz);
    }

    public void assertNotStatus(String message, URI lraId, Class<?> participantClazz) {
        this.assertNot(message, LRAMetricType.Status, lraId, participantClazz);
    }

    public void assertNested(String message, URI lraId, Class<?> participantClazz) {
        this.assertYes(message, LRAMetricType.Nested, lraId, participantClazz);
    }

    public void assertNotNested(String message, URI lraId, Class<?> participantClazz) {
        this.assertNot(message, LRAMetricType.Nested, lraId, participantClazz);
    }

    public void assertNestedEquals(String message, int expectedNumber, URI lraId, Class<?> participantClazz) {
        Assert.assertEquals((String)message, (long)expectedNumber, (long)this.lraMetricService.getMetric(LRAMetricType.Nested, lraId, participantClazz));
    }

    public void assertFinished(String message, URI lraId, Class<?> participantClazz) {
        Assert.assertTrue((String)message, (boolean)this.lraTestService.isLRAFinished(lraId, participantClazz.getName()));
    }

    private void assertYes(String message, LRAMetricType metricType, URI lraId, Class<?> participantClazz) {
        MatcherAssert.assertThat((String)message, (Object)this.lraMetricService.getMetric(metricType, lraId, participantClazz), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1)));
    }

    private void assertNot(String message, LRAMetricType metricType, URI lraId, Class<?> participantClazz) {
        Assert.assertEquals((String)message, (long)0L, (long)this.lraMetricService.getMetric(metricType, lraId, participantClazz));
    }
}

