/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck;

import org.eclipse.microprofile.lra.tck.JaxRsActivator;
import org.eclipse.microprofile.lra.tck.participant.invalid.LRAResourceWithoutCompensateOrAfteRLRA;
import org.eclipse.microprofile.lra.tck.participant.nonjaxrs.InvalidAfterLRASignatureListener;
import org.eclipse.microprofile.lra.tck.participant.nonjaxrs.InvalidArgumentTypesParticipant;
import org.eclipse.microprofile.lra.tck.participant.nonjaxrs.InvalidReturnTypeParticipant;
import org.eclipse.microprofile.lra.tck.participant.nonjaxrs.TooManyArgsParticipant;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.test.api.Deployer;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class TckInvalidSignaturesTests {
    private static final String INVALID_RETURN_TYPE_DEPLOYMENT = "nonjaxrs-return-type-deploy";
    private static final String TOO_MANY_ARGS_DEPLOYMENT = "too-many-args-deploy";
    private static final String INVALID_ARGUMENT_TYPE_DEPLOYMENT = "nonjaxrs-argument-type-deploy";
    private static final String INVALID_AFTER_LRA_SIGNATURE_DEPLOYMENT = "invalid-after-lra-deploy";
    private static final String INVALID_LRA_RESOURCE_DEPLOYMENT = "invalid-lra-resource-deploy";
    @Rule
    public DeploymentNameRule deploymentNameRule = new DeploymentNameRule();
    @ArquillianResource
    private Deployer deployer;

    @Deployment(name="nonjaxrs-return-type-deploy", managed=false)
    public static WebArchive deployInvalidReturnTypeParticipant() {
        return TckInvalidSignaturesTests.createArchive(InvalidReturnTypeParticipant.class);
    }

    @Deployment(name="too-many-args-deploy", managed=false)
    public static WebArchive deployTooManyArgsParticipant() {
        return TckInvalidSignaturesTests.createArchive(TooManyArgsParticipant.class);
    }

    @Deployment(name="nonjaxrs-argument-type-deploy", managed=false)
    public static WebArchive deployInvalidArgumentTypeParticipant() {
        return TckInvalidSignaturesTests.createArchive(InvalidArgumentTypesParticipant.class);
    }

    @Deployment(name="invalid-after-lra-deploy", managed=false)
    public static WebArchive deployInvalidAfterLRASignatureResource() {
        return TckInvalidSignaturesTests.createArchive(InvalidAfterLRASignatureListener.class);
    }

    @Deployment(name="invalid-lra-resource-deploy", managed=false)
    public static WebArchive deployInvalidLRAResource() {
        return TckInvalidSignaturesTests.createArchive(LRAResourceWithoutCompensateOrAfteRLRA.class);
    }

    private static WebArchive createArchive(Class<?> resourceClass) {
        String archiveName = resourceClass.getSimpleName();
        return (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(archiveName + ".war"))).addClasses(new Class[]{resourceClass, JaxRsActivator.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @After
    public void after() {
        this.deployer.undeploy(this.deploymentNameRule.deploymentName);
    }

    @Test
    public void invalidReturnTypeInParticipantMethodTest() {
        this.testInvalidDeployment(INVALID_RETURN_TYPE_DEPLOYMENT);
    }

    @Test
    public void tooManyArgsInParticipantMethodTest() {
        this.testInvalidDeployment(TOO_MANY_ARGS_DEPLOYMENT);
    }

    @Test
    public void invalidArgumentTypeInParticipantMethodTest() {
        this.testInvalidDeployment(INVALID_ARGUMENT_TYPE_DEPLOYMENT);
    }

    @Test
    public void invalidAfterLRASignatureTest() {
        this.testInvalidDeployment(INVALID_AFTER_LRA_SIGNATURE_DEPLOYMENT);
    }

    @Test
    public void invalidLRAResourceWithoutCompensateOrAfterLRATest() {
        this.testInvalidDeployment(INVALID_LRA_RESOURCE_DEPLOYMENT);
    }

    private void testInvalidDeployment(String deploymentName) {
        this.deploymentNameRule.deploymentName = deploymentName;
        Assert.assertThrows(DeploymentException.class, () -> this.deployer.deploy(deploymentName));
    }

    private static final class DeploymentNameRule
    extends TestName {
        String deploymentName;

        private DeploymentNameRule() {
        }
    }
}

