/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck.participant.api;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import org.eclipse.microprofile.lra.LRAResponse;
import org.eclipse.microprofile.lra.annotation.Compensate;
import org.eclipse.microprofile.lra.annotation.Complete;
import org.eclipse.microprofile.lra.annotation.Forget;
import org.eclipse.microprofile.lra.annotation.ParticipantStatus;
import org.eclipse.microprofile.lra.annotation.Status;
import org.eclipse.microprofile.lra.annotation.ws.rs.LRA;
import org.eclipse.microprofile.lra.annotation.ws.rs.Leave;
import org.eclipse.microprofile.lra.tck.LRAClientOps;
import org.eclipse.microprofile.lra.tck.LraTckConfigBean;
import org.eclipse.microprofile.lra.tck.participant.activity.Activity;
import org.eclipse.microprofile.lra.tck.participant.activity.ActivityStorage;
import org.eclipse.microprofile.lra.tck.participant.api.IllegalLRAStateException;
import org.eclipse.microprofile.lra.tck.participant.api.ResourceParent;
import org.eclipse.microprofile.lra.tck.participant.api.WrongHeaderException;
import org.eclipse.microprofile.lra.tck.service.LRAMetricService;
import org.eclipse.microprofile.lra.tck.service.LRAMetricType;
import org.eclipse.microprofile.lra.tck.service.LRATestService;

@ApplicationScoped
@Path(value="lraresource")
@LRA(value=LRA.Type.SUPPORTS, end=false)
public class LraResource
extends ResourceParent {
    public static final String LRA_RESOURCE_PATH = "lraresource";
    public static final String TRANSACTIONAL_WORK_PATH = "work";
    public static final String ACCEPT_WORK = "acceptWork";
    public static final String TIME_LIMIT = "/timeLimit";
    public static final String TIME_LIMIT_HALF_SEC = "/timeLimit2";
    public static final String CANCEL_PATH = "/cancel";
    static final String MANDATORY_LRA_RESOURCE_PATH = "/mandatory";
    private static final Logger LOGGER = Logger.getLogger(LraResource.class.getName());
    private static final String MISSING_LRA_DATA = "Missing LRA data";
    @Context
    private UriInfo context;
    @Inject
    private ActivityStorage activityStore;
    @Inject
    private LRAMetricService lraMetricService;
    @Inject
    private LraTckConfigBean configBean;
    @Inject
    LRATestService lraTestService;

    @GET
    @Path(value="/status")
    @Produces(value={"application/json"})
    @Status
    public Response status(@HeaderParam(value="Long-Running-Action") URI lraId, @HeaderParam(value="Long-Running-Action-Recovery") URI recoveryId) {
        this.assertHeaderPresent(lraId, "Long-Running-Action");
        this.assertHeaderPresent(recoveryId, "Long-Running-Action-Recovery");
        Activity activity = this.activityStore.getActivityAndAssertExistence(lraId, this.context);
        if (activity.getStatus() == null) {
            throw new IllegalLRAStateException(lraId, "LRA is not active");
        }
        if (activity.getAndDecrementAcceptCount() <= 0) {
            if (activity.getStatus() == ParticipantStatus.Completing) {
                activity.setStatus(ParticipantStatus.Completed);
            } else if (activity.getStatus() == ParticipantStatus.Compensating) {
                activity.setStatus(ParticipantStatus.Compensated);
            }
        }
        return Response.ok((Object)activity.getStatus().name()).build();
    }

    @PUT
    @Path(value="/leave")
    @Produces(value={"application/json"})
    @Leave
    public Response leaveWork(@HeaderParam(value="Long-Running-Action") URI lraId) {
        if (lraId != null) {
            this.activityStore.getActivityAndAssertExistence(lraId, this.context);
            this.activityStore.remove(lraId);
            return Response.ok((Object)lraId).build();
        }
        return Response.ok((Object)"non transactional").build();
    }

    @PUT
    @Path(value="/complete")
    @Produces(value={"application/json"})
    @Complete
    public Response completeWork(@HeaderParam(value="Long-Running-Action") URI lraId, @HeaderParam(value="Long-Running-Action-Recovery") URI recoveryId) {
        this.lraMetricService.incrementMetric(LRAMetricType.Completed, lraId, LraResource.class);
        this.assertHeaderPresent(lraId, "Long-Running-Action");
        this.assertHeaderPresent(recoveryId, "Long-Running-Action-Recovery");
        Activity activity = this.activityStore.getActivityAndAssertExistence(lraId, this.context);
        if (activity.getAndDecrementAcceptCount() > 0) {
            activity.setStatus(ParticipantStatus.Completing);
            activity.setStatusUrl(String.format("%s/%s/%s/status", this.context.getBaseUri(), LRA_RESOURCE_PATH, lraId));
            return LRAResponse.Builder.completing().location(URI.create(activity.getStatusUrl())).build();
        }
        activity.setStatus(ParticipantStatus.Completed);
        activity.setStatusUrl(String.format("%s/%s/activity/completed", this.context.getBaseUri(), lraId.toASCIIString()));
        LOGGER.info(String.format("LRA id '%s' was completed", lraId.toASCIIString()));
        return LRAResponse.completed((Object)activity.getStatusUrl());
    }

    @PUT
    @Path(value="/compensate")
    @Produces(value={"application/json"})
    @Compensate
    public Response compensateWork(@HeaderParam(value="Long-Running-Action") URI lraId, @HeaderParam(value="Long-Running-Action-Recovery") URI recoveryId) {
        this.assertHeaderPresent(lraId, "Long-Running-Action");
        this.assertHeaderPresent(recoveryId, "Long-Running-Action-Recovery");
        this.lraMetricService.incrementMetric(LRAMetricType.Compensated, lraId, LraResource.class);
        Activity activity = this.activityStore.getActivityAndAssertExistence(lraId, this.context);
        if (activity.getAndDecrementAcceptCount() > 0) {
            activity.setStatus(ParticipantStatus.Compensating);
            activity.setStatusUrl(String.format("%s/%s/%s/status", this.context.getBaseUri(), LRA_RESOURCE_PATH, lraId));
            return LRAResponse.Builder.compensating().location(URI.create(activity.getStatusUrl())).build();
        }
        activity.setStatus(ParticipantStatus.Compensated);
        activity.setStatusUrl(String.format("%s/%s/activity/compensated", this.context.getBaseUri(), lraId));
        LOGGER.info(String.format("LRA id '%s' was compensated", lraId));
        return LRAResponse.compensated((Object)activity.getStatusUrl());
    }

    @DELETE
    @Path(value="/forget")
    @Produces(value={"application/json"})
    @Forget
    public Response forgetWork(@HeaderParam(value="Long-Running-Action") URI lraId, @HeaderParam(value="Long-Running-Action-Recovery") URI recoveryId) {
        this.lraMetricService.incrementMetric(LRAMetricType.Forget, lraId, LraResource.class);
        this.assertHeaderPresent(lraId, "Long-Running-Action");
        this.assertHeaderPresent(recoveryId, "Long-Running-Action-Recovery");
        Activity activity = this.activityStore.getActivityAndAssertExistence(lraId, this.context);
        if (activity == null) {
            throw new IllegalStateException(String.format("Activity store does not contain LRA id '%s' while it was invoked forget method at ", this.context.getPath()));
        }
        this.activityStore.remove(activity.getLraId());
        activity.setStatus(ParticipantStatus.Completed);
        activity.setStatusUrl(String.format("%s/%s/activity/completed", this.context.getBaseUri(), lraId));
        LOGGER.info(String.format("LRA id '%s' was forgotten", lraId.toASCIIString()));
        return Response.ok((Object)activity.getStatusUrl()).build();
    }

    @PUT
    @Path(value="acceptWork")
    @LRA(value=LRA.Type.REQUIRED, end=false)
    public Response acceptWork(@HeaderParam(value="Long-Running-Action-Recovery") URI recoveryId, @HeaderParam(value="Long-Running-Action") URI lraId) {
        this.assertHeaderPresent(lraId, "Long-Running-Action");
        this.assertHeaderPresent(recoveryId, "Long-Running-Action-Recovery");
        Activity activity = this.storeActivity(lraId, recoveryId);
        activity.setAcceptedCount(1);
        return Response.ok((Object)lraId).build();
    }

    @PUT
    @Path(value="/supports")
    @LRA(value=LRA.Type.SUPPORTS, end=false)
    public Response supportsLRACall(@HeaderParam(value="Long-Running-Action") URI lraId) {
        this.assertHeaderPresent(lraId, "Long-Running-Action");
        this.storeActivity(lraId, null);
        return Response.ok((Object)lraId).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="/startViaApi")
    @LRA(value=LRA.Type.NOT_SUPPORTED)
    public Response subActivity(@HeaderParam(value="Long-Running-Action") URI lraId) {
        this.assertNotHeaderPresent(lraId);
        try (Client client = null;){
            URI lra;
            client = ClientBuilder.newClient();
            WebTarget target = client.target(this.context.getBaseUri());
            lraId = lra = new LRAClientOps(target).startLRA(null, "subActivity", 0L, ChronoUnit.SECONDS);
            this.storeActivity(lraId, null);
            String id = this.restPutInvocation(lra, "supports", "");
            if (!lraId.toASCIIString().equals(id)) {
                Response response = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)Entity.text((Object)"Unequal LRA ids")).build();
                return response;
            }
            Response response = Response.ok((Object)id).build();
            return response;
        }
    }

    @PUT
    @Path(value="work")
    @LRA(value=LRA.Type.REQUIRED, end=false)
    public Response activityWithLRA(@HeaderParam(value="Long-Running-Action-Recovery") URI recoveryId, @HeaderParam(value="Long-Running-Action") URI lraId) {
        this.assertHeaderPresent(lraId, "Long-Running-Action");
        this.assertHeaderPresent(recoveryId, "Long-Running-Action-Recovery");
        Activity activity = this.storeActivity(lraId, recoveryId);
        if (activity == null) {
            return Response.status((Response.Status)Response.Status.EXPECTATION_FAILED).entity((Object)MISSING_LRA_DATA).build();
        }
        return Response.ok((Object)lraId).header("Long-Running-Action-Recovery", (Object)recoveryId).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String restPutInvocation(URI lraURI, String path, String bodyText) {
        String id = null;
        Response response = ClientBuilder.newClient().target(this.context.getBaseUri()).path(LRA_RESOURCE_PATH).path(path).request().header("Long-Running-Action", (Object)lraURI).put(Entity.text((Object)bodyText));
        if (response.hasEntity()) {
            id = (String)response.readEntity(String.class);
        }
        try {
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new WebApplicationException("Error on REST PUT for LRA '" + lraURI + "' at path '" + path + "' and body '" + bodyText + "'", response);
            }
        }
        finally {
            response.close();
        }
        return id;
    }

    @PUT
    @Path(value="/mandatory")
    @Produces(value={"text/plain"})
    @LRA(value=LRA.Type.MANDATORY, end=false)
    public Response activityWithMandatoryLRA(@HeaderParam(value="Long-Running-Action-Recovery") URI recoveryId, @HeaderParam(value="Long-Running-Action") URI lraId) {
        return this.activityWithLRA(recoveryId, lraId);
    }

    @PUT
    @Path(value="/nestedActivity")
    @LRA(value=LRA.Type.NESTED, end=true)
    public Response nestedActivity(@HeaderParam(value="Long-Running-Action-Recovery") URI recoveryId, @HeaderParam(value="Long-Running-Action") URI nestedLRAId) {
        this.assertHeaderPresent(nestedLRAId, "Long-Running-Action");
        this.assertHeaderPresent(recoveryId, "Long-Running-Action-Recovery");
        this.storeActivity(nestedLRAId, recoveryId);
        return Response.ok((Object)nestedLRAId).build();
    }

    @PUT
    @Path(value="/cancel")
    @LRA(value=LRA.Type.MANDATORY, cancelOnFamily={Response.Status.Family.SERVER_ERROR})
    public Response cancelLRA(@HeaderParam(value="Long-Running-Action") URI lraId) {
        return Response.status((int)500).entity((Object)lraId).build();
    }

    @PUT
    @Path(value="/multiLevelNestedActivity")
    @LRA(value=LRA.Type.MANDATORY, end=false)
    public Response multiLevelNestedActivity(@HeaderParam(value="Long-Running-Action-Recovery") URI recoveryId, @HeaderParam(value="Long-Running-Action") URI nestedLRAId, @QueryParam(value="nestedCnt") @DefaultValue(value="1") Integer nestedCnt) {
        this.assertHeaderPresent(nestedLRAId, "Long-Running-Action");
        this.assertHeaderPresent(recoveryId, "Long-Running-Action-Recovery");
        this.storeActivity(nestedLRAId, recoveryId);
        CharSequence[] lras = new String[nestedCnt + 1];
        lras[0] = nestedLRAId.toASCIIString();
        IntStream.range(1, lras.length).forEach(arg_0 -> this.lambda$multiLevelNestedActivity$0((String[])lras, nestedLRAId, arg_0));
        return Response.ok((Object)String.join((CharSequence)",", lras)).build();
    }

    private Activity storeActivity(URI lraId, URI recoveryId) {
        String lra = lraId != null ? lraId.toASCIIString() : null;
        String rid = recoveryId != null ? recoveryId.toASCIIString() : null;
        LOGGER.fine(String.format("Storing information about LRA id '%s' and recoveryId '%s'", lra, rid));
        Activity activity = new Activity(lraId).setRecoveryUri(recoveryId).setStatus(null);
        return this.activityStore.add(activity);
    }

    @GET
    @Produces(value={"application/json"})
    @LRA(value=LRA.Type.NOT_SUPPORTED)
    public Response findAll() {
        List<Activity> results = this.activityStore.findAll();
        return Response.ok((Object)results.size()).build();
    }

    @GET
    @Path(value="/timeLimit")
    @Produces(value={"application/json"})
    @LRA(value=LRA.Type.REQUIRED, timeLimit=500L, timeUnit=ChronoUnit.MILLIS)
    public Response timeLimit(@HeaderParam(value="Long-Running-Action") URI lraId) {
        this.assertHeaderPresent(lraId, "Long-Running-Action");
        this.activityStore.add(new Activity(lraId));
        try {
            Thread.sleep(this.configBean.adjustTimeout(1000L));
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.FINE, "Interrupted because time limit elapsed", e);
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)lraId.toASCIIString()).build();
    }

    @GET
    @Path(value="/timeLimit2")
    @Produces(value={"application/json"})
    @LRA(value=LRA.Type.REQUIRED, timeLimit=500L, timeUnit=ChronoUnit.MILLIS)
    public Response timeLimitTest2(@HeaderParam(value="Long-Running-Action") URI lraId) {
        this.assertHeaderPresent(lraId, "Long-Running-Action");
        this.activityStore.add(new Activity(lraId));
        try {
            Thread.sleep(this.configBean.adjustTimeout(1000L));
            this.lraTestService.waitForCallbacks(lraId);
            this.restPutInvocation(lraId, MANDATORY_LRA_RESOURCE_PATH, "");
        }
        catch (WebApplicationException wae) {
            return Response.status((int)wae.getResponse().getStatus()).build();
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.FINE, "timeLimitTest2: Interrupted because time limit elapsed", e);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.status((Response.Status)Response.Status.OK).entity((Object)lraId.toASCIIString()).build();
    }

    @PUT
    @Path(value="/{LRAId}/compensate")
    @Produces(value={"application/json"})
    public Response compensate(@PathParam(value="LRAId") URI lraId) {
        Activity activity = this.activityStore.getActivityAndAssertExistence(lraId, this.context);
        activity.setStatus(ParticipantStatus.Compensated);
        activity.setStatusUrl(String.format("%s/%s/activity/compensated", this.context.getBaseUri(), lraId));
        return Response.ok((Object)activity.getStatusUrl()).build();
    }

    @PUT
    @Path(value="/{LRAId}/complete")
    @Produces(value={"application/json"})
    public Response complete(@PathParam(value="LRAId") URI lraId) {
        Activity activity = this.activityStore.getActivityAndAssertExistence(lraId, this.context);
        activity.setStatus(ParticipantStatus.Completed);
        activity.setStatusUrl(String.format("%s/%s/activity/completed", this.context.getBaseUri(), lraId));
        return Response.ok((Object)activity.getStatusUrl()).build();
    }

    @PUT
    @Path(value="/{LRAId}/forget")
    public void forget(@PathParam(value="LRAId") URI lraId) {
        Activity activity = this.activityStore.getActivityAndAssertExistence(lraId, this.context);
        this.activityStore.remove(activity.getLraId());
    }

    @GET
    @Path(value="/{LRAId}/completed")
    @Produces(value={"application/json"})
    public String completedStatus(@PathParam(value="LRAId") String lraId) {
        return ParticipantStatus.Completed.name();
    }

    @GET
    @Path(value="/{LRAId}/compensated")
    @Produces(value={"application/json"})
    public String compensatedStatus(@PathParam(value="LRAId") String lraId) {
        return ParticipantStatus.Compensated.name();
    }

    private void assertHeaderPresent(URI lraId, String headerName) {
        if (lraId == null) {
            throw new WrongHeaderException(String.format("%s: missing '%s' header", this.context.getPath(), headerName));
        }
    }

    private void assertNotHeaderPresent(URI lraId) {
        if (lraId != null) {
            throw new WrongHeaderException(String.format("%s: unexpected '%s' header", this.context.getPath(), "Long-Running-Action"));
        }
    }

    private /* synthetic */ void lambda$multiLevelNestedActivity$0(String[] lras, URI nestedLRAId, int i) {
        lras[i] = this.restPutInvocation(nestedLRAId, "nestedActivity", "");
    }
}

