/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck;

import jakarta.inject.Inject;
import org.eclipse.microprofile.metrics.ConcurrentGauge;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.SimpleTimer;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.RegistryType;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.junit.InSequence;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class MetricRegistryTest {
    @Inject
    @org.eclipse.microprofile.metrics.annotation.Metric(name="nameTest", absolute=true)
    private Counter nameTest;
    @Inject
    private Counter countTemp;
    @Inject
    private Histogram histoTemp;
    @Inject
    private Timer timerTemp;
    @Inject
    private SimpleTimer simpleTimerTemp;
    @Inject
    private ConcurrentGauge concurrentGaugeTemp;
    @Inject
    private Meter meterTemp;
    @Inject
    private MetricRegistry metrics;
    @Inject
    @RegistryType(type=MetricRegistry.Type.BASE)
    private MetricRegistry baseMetrics;
    @Inject
    @RegistryType(type=MetricRegistry.Type.VENDOR)
    private MetricRegistry vendorMetrics;

    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @Test
    @InSequence(value=1)
    public void nameTest() {
        Assert.assertNotNull((Object)this.metrics);
        Assert.assertNotNull((Object)this.metrics.getMetadata("nameTest"));
    }

    @Test
    @InSequence(value=2)
    public void registerTest() {
        this.metrics.register("regCountTemp", (Metric)this.countTemp);
        this.assertExists(Counter.class, new MetricID("regCountTemp"));
        this.metrics.register("regHistoTemp", (Metric)this.histoTemp);
        this.assertExists(Histogram.class, new MetricID("regHistoTemp"));
        this.metrics.register("regTimerTemp", (Metric)this.timerTemp);
        this.assertExists(Timer.class, new MetricID("regTimerTemp"));
        this.metrics.register("regSimpleTimerTemp", (Metric)this.simpleTimerTemp);
        this.assertExists(SimpleTimer.class, new MetricID("regSimpleTimerTemp"));
        this.metrics.register("regConcurrentGaugeTemp", (Metric)this.concurrentGaugeTemp);
        this.assertExists(ConcurrentGauge.class, new MetricID("regConcurrentGaugeTemp"));
        this.metrics.register("regMeterTemp", (Metric)this.meterTemp);
        this.assertExists(Meter.class, new MetricID("regMeterTemp"));
    }

    @Test
    @InSequence(value=3)
    public void removeTest() {
        this.metrics.remove("nameTest");
        Assert.assertNull((Object)this.metrics.getMetadata("nameTest"));
    }

    @Test
    @InSequence(value=4)
    public void useExistingMetaDataTest() {
        String displayName = "displayCounterFoo";
        String metricName = "counterFoo";
        this.metrics.counter(Metadata.builder().withName(metricName).withDisplayName(displayName).withType(MetricType.COUNTER).build());
        Tag purpleTag = new Tag("colour", "purple");
        this.metrics.counter(metricName, new Tag[]{purpleTag});
        this.assertExists(Counter.class, new MetricID(metricName));
        this.assertExists(Counter.class, new MetricID(metricName, new Tag[]{purpleTag}));
        Assert.assertEquals((Object)this.metrics.getMetadata(metricName).getDisplayName(), (Object)displayName);
    }

    @Test
    @InSequence(value=5)
    public void testMetricRegistryType() {
        Assert.assertEquals((Object)MetricRegistry.Type.APPLICATION, (Object)this.metrics.getType());
        Assert.assertEquals((Object)MetricRegistry.Type.BASE, (Object)this.baseMetrics.getType());
        Assert.assertEquals((Object)MetricRegistry.Type.VENDOR, (Object)this.vendorMetrics.getType());
    }

    private void assertExists(Class<? extends Metric> expected, MetricID metricID) {
        Assert.assertNotNull((String)("Metric expected to exist but was undefined: " + metricID), (Object)this.metrics.getMetric(metricID, expected));
    }

    @Test
    @InSequence(value=6)
    public void sanitizeMetadataTest() {
        Metadata metadata = Metadata.builder().withName("metric1").build();
        this.metrics.counter(metadata);
        Metadata actualMetadata = this.metrics.getMetadata("metric1");
        Assert.assertEquals((Object)MetricType.COUNTER, (Object)actualMetadata.getTypeRaw());
    }

    @Test(expected=Exception.class)
    @InSequence(value=7)
    public void conflictingMetadataTest() {
        Metadata metadata = Metadata.builder().withName("metric1").withType(MetricType.COUNTER).build();
        this.metrics.meter(metadata);
    }
}

