/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.test;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.function.Supplier;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Metric;
import org.eclipse.microprofile.metrics.annotation.Timed;

@ApplicationScoped
public class MetricAppBean {
    @Inject
    @Metric(description="red-description")
    private Counter redCount;
    @Inject
    @Metric(name="blue")
    private Counter blueCount;
    public static final String NO_TAG_COUNTER = "noTagCounter";
    public static final String TAGGED_COUNTER = "taggedCounter";
    public static final String NO_TAG_HISTOGRAM = "noTagHistogram";
    public static final String TAGGED_HISTOGRAM = "taggedHistogram";
    public static final String NO_TAG_TIMER = "noTagTimer";
    public static final String TAGGED_TIMER = "taggedTimer";
    public static final String NO_TAG_GAUGE = "noTagGauge";
    public static final String TAGGED_GAUGE = "taggedGauge";
    public static final String SHARED_METRIC_NAME = "sharedMetricName";
    @Inject
    @Metric(name="sharedMetricName", absolute=true, scope="customScopeD", unit="marshmallow")
    private Histogram histogramMetricNameScopeD;
    @Inject
    @Metric(name="semiColonTaggedCounter", tags={"scTag=semi;colons;are;bad"})
    private Counter semiColonTaggedCounter;
    @Inject
    @Metric(name="noTagCounter")
    private Counter counterNoTag;
    @Inject
    @Metric(name="taggedCounter", tags={"number=one"})
    private Counter counterNumberOneTag;
    @Inject
    @Metric(name="taggedCounter", tags={"number=two"})
    private Counter counterNumberTwoTag;
    @Inject
    @Metric(name="noTagHistogram", absolute=true, unit="marshmallow")
    private Histogram histogramNoTag;
    @Inject
    @Metric(name="taggedHistogram", absolute=true, unit="marshmallow", tags={"number=one"})
    private Histogram histogramOneTag;
    @Inject
    @Metric(name="taggedHistogram", absolute=true, unit="marshmallow", tags={"number=two"})
    private Histogram histogramTwoTag;
    @Inject
    @Metric(name="noTagTimer", absolute=true)
    private Timer timerNoTag;
    @Inject
    @Metric(name="taggedTimer", absolute=true, tags={"number=one"})
    private Timer timerOneTag;
    @Inject
    @Metric(name="taggedTimer", absolute=true, tags={"number=two"})
    private Timer timerTwoTag;
    @Inject
    @Metric(absolute=true)
    private Counter greenCount;
    @Inject
    @Metric(name="purple", absolute=true, tags={"app=myShop"})
    private Counter purpleCount;
    @Inject
    @Metric(absolute=true, unit="jellybeans", description="jellybeans-description")
    private Histogram jellybeanHistogram;
    @Inject
    private MetricRegistry metrics;

    @Counted(name="sharedMetricName", absolute=true, scope="customScopeA")
    public void countMeMetricNameScopeA() {
    }

    @Timed(name="sharedMetricName", absolute=true, scope="customScopeB")
    public void timeMeMetricNameScopeB() {
    }

    @org.eclipse.microprofile.metrics.annotation.Gauge(name="sharedMetricName", absolute=true, scope="customScopeC", unit="jelly")
    public long gaugeMeMetricNameScopeC() {
        return 123L;
    }

    @org.eclipse.microprofile.metrics.annotation.Gauge(name="noTagGauge", absolute=true, unit="none")
    public long gaugeMeTagged() {
        return 1000L;
    }

    @org.eclipse.microprofile.metrics.annotation.Gauge(name="taggedGauge", absolute=true, unit="none", tags={"number=one"})
    public long gaugeMeTaggedOne() {
        return 1000L;
    }

    @org.eclipse.microprofile.metrics.annotation.Gauge(name="taggedGauge", absolute=true, unit="none", tags={"number=two"})
    public long gaugeMeTaggedTwo() {
        return 1000L;
    }

    public void countMe() {
        Counter counter = this.metrics.counter("metricTest.test1.count");
        counter.inc();
    }

    @Counted(name="metricTest.test1.countMeA", absolute=true, description="count-me-a-description")
    public void countMeA() {
    }

    @Counted(name="metricTest.test1.countMeB", absolute=true, unit="jellybean")
    public long countMeB() {
        return 666666L;
    }

    public void gaugeMe() {
        Gauge gauge = this.metrics.getGauge(new MetricID("metricTest.test1.gauge"));
        if (gauge == null) {
            Supplier<Long> gaugeSupp = () -> 19L;
            Metadata metadata = Metadata.builder().withName("metricTest.test1.gauge").withUnit("gigabytes").build();
            this.metrics.gauge(metadata, gaugeSupp, new Tag[0]);
        }
    }

    @org.eclipse.microprofile.metrics.annotation.Gauge(unit="kibibits", description="gauge-me-a-description")
    public long gaugeMeA() {
        return 1000L;
    }

    @org.eclipse.microprofile.metrics.annotation.Gauge(unit="hands")
    public long gaugeMeB() {
        return 7777777L;
    }

    public void histogramMe() {
        Metadata metadata = Metadata.builder().withName("metricTest.test1.histogram").withUnit("bytes").build();
        Histogram histogram = this.metrics.histogram(metadata);
        for (int i = 0; i < 500; ++i) {
            histogram.update(i);
            histogram.update(999 - i);
        }
        Metadata metadata2 = Metadata.builder().withName("metricTest.test1.histogram2").withUnit("none").build();
        Histogram histogram2 = this.metrics.histogram(metadata2);
        histogram2.update(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeMe() {
        Timer timer = this.metrics.timer("metricTest.test1.timer");
        Timer.Context context = timer.time();
        try {
            Thread.sleep((long)(Math.random() * 1000.0));
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            context.stop();
        }
    }

    @Timed
    public void timeMeA() {
    }

    public void createPromMetrics() {
        this.metrics.counter("pm_counter-with-dashes");
        this.metrics.counter("pm_counter#hash_x'y_");
        this.metrics.counter("pm_counter-umlaut-\u00e4\u00f6\u00fc");
        this.metrics.counter("pm_counter+accent_\u00ea_");
    }
}

