/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.metrics.tck.config;

import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Snapshot;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.tck.config.TimerConfigFieldBean;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class TimerConfigFieldBeanTest {
    private static final String TIMER_NAME_1 = MetricRegistry.name(TimerConfigFieldBean.class, (String[])new String[]{"injectedTimerCustomPercentiles"});
    private static final String TIMER_NAME_2 = MetricRegistry.name(TimerConfigFieldBean.class, (String[])new String[]{"injectedTimerNoPercentiles"});
    private static final String TIMER_NAME_3 = MetricRegistry.name(TimerConfigFieldBean.class, (String[])new String[]{"injectedTimerCustomBucketsDefaultPercentiles"});
    private static final String TIMER_NAME_4 = MetricRegistry.name(TimerConfigFieldBean.class, (String[])new String[]{"injectedTimerCustomBucketsCustomPercentiles"});
    private static final String TIMER_NAME_5 = MetricRegistry.name(TimerConfigFieldBean.class, (String[])new String[]{"injectedTimerCustomBucketsNoPercentiles"});
    private static final String TIMER_NAME_6 = "injected.precedence.timer";
    private static final String TIMER_NAME_7 = "injected.precedence.override.timer";
    @Inject
    private MetricRegistry registry;
    @Inject
    private TimerConfigFieldBean bean;

    @Deployment
    static Archive<?> createTestArchive() {
        WebArchive jar = (WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClass(TimerConfigFieldBean.class)).addAsWebInfResource("META-INF/beans.xml", "beans.xml")).addAsManifestResource("META-INF/microprofile-config-timerConfigFieldBeanTest.properties", "microprofile-config.properties");
        System.out.println(jar.toString(true));
        return jar;
    }

    @Test
    public void checkTimerCustomPercentiles() {
        Timer timer = this.registry.getTimer(new MetricID(TIMER_NAME_1));
        Snapshot.PercentileValue[] percentiles = timer.getSnapshot().percentileValues();
        MatcherAssert.assertThat((String)"Configured percentiles length do not match", (Object)percentiles.length, (Matcher)Matchers.equalTo((Object)2));
        List percentilesList = Stream.of(percentiles).map(pv -> pv.getPercentile()).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Configured percentiles do not match", percentilesList, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)0.4), Matchers.equalTo((Object)0.2)}));
    }

    @Test
    public void checkTimerNoPercentiles() {
        Timer timer = this.registry.getTimer(new MetricID(TIMER_NAME_2));
        Snapshot.PercentileValue[] percentiles = timer.getSnapshot().percentileValues();
        MatcherAssert.assertThat((String)"Configured percentiles length do not match", (Object)percentiles.length, (Matcher)Matchers.equalTo((Object)0));
    }

    @Test
    public void checkTimerCustomBucketsDefaultPercentiles() {
        Timer timer = this.registry.getTimer(new MetricID(TIMER_NAME_3));
        Snapshot.PercentileValue[] percentiles = timer.getSnapshot().percentileValues();
        MatcherAssert.assertThat((String)"Configured percentiles length do not match", (Object)percentiles.length, (Matcher)Matchers.equalTo((Object)6));
        List percentilesList = Stream.of(percentiles).map(pv -> pv.getPercentile()).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Configured percentiles do not match", percentilesList, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)0.5), Matchers.equalTo((Object)0.75), Matchers.equalTo((Object)0.95), Matchers.equalTo((Object)0.98), Matchers.equalTo((Object)0.99), Matchers.equalTo((Object)0.999)}));
        Snapshot.HistogramBucket[] buckets = timer.getSnapshot().bucketValues();
        MatcherAssert.assertThat((String)"Configured buckets length do not match", (Object)buckets.length, (Matcher)Matchers.equalTo((Object)2));
        List bucketsList = Stream.of(buckets).map(bucket -> TimeUnit.MILLISECONDS.convert((long)bucket.getBucket(), TimeUnit.NANOSECONDS)).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Configured buckets do not match", bucketsList, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)100L), Matchers.equalTo((Object)2000L)}));
    }

    @Test
    public void checkTimerCustomBucketsCustomPercentiles() {
        Timer timer = this.registry.getTimer(new MetricID(TIMER_NAME_4));
        Snapshot.PercentileValue[] percentiles = timer.getSnapshot().percentileValues();
        MatcherAssert.assertThat((String)"Configured percentiles length do not match", (Object)percentiles.length, (Matcher)Matchers.equalTo((Object)2));
        List percentilesList = Stream.of(percentiles).map(pv -> pv.getPercentile()).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Configured percentiles do not match", percentilesList, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)0.7), Matchers.equalTo((Object)0.8)}));
        Snapshot.HistogramBucket[] buckets = timer.getSnapshot().bucketValues();
        MatcherAssert.assertThat((String)"Configured buckets length do not match", (Object)buckets.length, (Matcher)Matchers.equalTo((Object)2));
        List bucketsList = Stream.of(buckets).map(bucket -> TimeUnit.MILLISECONDS.convert((long)bucket.getBucket(), TimeUnit.NANOSECONDS)).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Configured buckets do not match", bucketsList, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)120L), Matchers.equalTo((Object)150L)}));
    }

    @Test
    public void checkTimerCustomBucketsNoPercentiles() {
        Timer timer = this.registry.getTimer(new MetricID(TIMER_NAME_5));
        Snapshot.PercentileValue[] percentiles = timer.getSnapshot().percentileValues();
        MatcherAssert.assertThat((String)"Configured percentiles length do not match", (Object)percentiles.length, (Matcher)Matchers.equalTo((Object)0));
        Snapshot.HistogramBucket[] buckets = timer.getSnapshot().bucketValues();
        MatcherAssert.assertThat((String)"Configured buckets length do not match", (Object)buckets.length, (Matcher)Matchers.equalTo((Object)2));
        List bucketsList = Stream.of(buckets).map(bucket -> TimeUnit.MILLISECONDS.convert((long)bucket.getBucket(), TimeUnit.NANOSECONDS)).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Configured buckets do not match", bucketsList, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)2000L), Matchers.equalTo((Object)555L)}));
    }

    @Test
    public void checkPrecedenceTimer() {
        Timer timer = this.registry.getTimer(new MetricID(TIMER_NAME_6));
        Snapshot.PercentileValue[] percentiles = timer.getSnapshot().percentileValues();
        MatcherAssert.assertThat((String)"Configured percentiles length do not match", (Object)percentiles.length, (Matcher)Matchers.equalTo((Object)2));
        List percentilesList = Stream.of(percentiles).map(pv -> pv.getPercentile()).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Configured percentiles do not match", percentilesList, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)0.9), Matchers.equalTo((Object)0.8)}));
        Snapshot.HistogramBucket[] buckets = timer.getSnapshot().bucketValues();
        MatcherAssert.assertThat((String)"Configured buckets length do not match", (Object)buckets.length, (Matcher)Matchers.equalTo((Object)2));
        List bucketsList = Stream.of(buckets).map(bucket -> TimeUnit.MILLISECONDS.convert((long)bucket.getBucket(), TimeUnit.NANOSECONDS)).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Configured buckets do not match", bucketsList, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalTo((Object)23L), Matchers.equalTo((Object)455L)}));
    }

    @Test
    public void checkPrecedenceOverrideTimer() {
        Timer timer = this.registry.getTimer(new MetricID(TIMER_NAME_7));
        Snapshot.PercentileValue[] percentiles = timer.getSnapshot().percentileValues();
        MatcherAssert.assertThat((String)"Configured percentiles length do not match", (Object)percentiles.length, (Matcher)Matchers.equalTo((Object)1));
        List percentilesList = Stream.of(percentiles).map(pv -> pv.getPercentile()).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Configured percentiles do not match", percentilesList, (Matcher)Matchers.contains((Matcher)Matchers.equalTo((Object)0.2)));
        Snapshot.HistogramBucket[] buckets = timer.getSnapshot().bucketValues();
        MatcherAssert.assertThat((String)"Configured buckets length do not match", (Object)buckets.length, (Matcher)Matchers.equalTo((Object)1));
        List bucketsList = Stream.of(buckets).map(bucket -> TimeUnit.MILLISECONDS.convert((long)bucket.getBucket(), TimeUnit.NANOSECONDS)).collect(Collectors.toList());
        MatcherAssert.assertThat((String)"Configured buckets do not match", bucketsList, (Matcher)Matchers.contains((Matcher)Matchers.equalTo((Object)32000L)));
    }
}

