/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.opentracing.tck;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.opentracing.tck.OpenTracingBaseTests;
import org.eclipse.microprofile.opentracing.tck.tracer.TestSpanTree;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.RunAsClient;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.annotations.Test;

public class OpenTracingSkipPatternTests
extends OpenTracingBaseTests {
    @Deployment
    public static WebArchive createDeployment() {
        return (WebArchive)OpenTracingBaseTests.createDeployment().addAsServiceProvider(ConfigSource.class, new Class[]{TestConfiguration.class});
    }

    @Test
    @RunAsClient
    private void testSkipSimple() {
        Response response = this.executeRemoteWebServiceRaw("testServices", "skipSimple", Response.Status.NO_CONTENT);
        response.close();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        this.assertEqualTrees(spans, new TestSpanTree());
    }

    @Test
    @RunAsClient
    private void testSkipFoo() {
        Response response = this.executeRemoteWebServiceRaw("skipAll", "simple", Response.Status.OK);
        response.close();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        this.assertEqualTrees(spans, new TestSpanTree());
    }

    @Test
    @RunAsClient
    private void testSkipFooBar() {
        Response response = this.executeRemoteWebServiceRaw("skipAll", "simple/nested", Response.Status.OK);
        response.close();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        this.assertEqualTrees(spans, new TestSpanTree());
    }

    @Test
    @RunAsClient
    private void testExplicitlyTraced() {
        Response response = this.executeRemoteWebServiceRaw("skipAll", "explicitlyTraced", Response.Status.OK);
        response.close();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        this.assertEqualTrees(spans, new TestSpanTree());
    }

    @Test
    @RunAsClient
    private void testHealthNotTraced() {
        Client client = ClientBuilder.newClient();
        String url = String.format("%s/health", this.baseUrl());
        OpenTracingSkipPatternTests.debug("Executing " + url);
        client.target(url).request().get();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        this.assertEqualTrees(spans, new TestSpanTree());
    }

    @Test
    @RunAsClient
    private void testOpenAPINotTraced() {
        Client client = ClientBuilder.newClient();
        String url = String.format("%s/openapi", this.baseUrl());
        OpenTracingSkipPatternTests.debug("Executing " + url);
        client.target(url).request().get();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        this.assertEqualTrees(spans, new TestSpanTree());
    }

    @Test
    @RunAsClient
    private void testMetricsNotTraced() {
        Client client = ClientBuilder.newClient();
        String url = String.format("%s/metrics", this.baseUrl());
        OpenTracingSkipPatternTests.debug("Executing " + url);
        client.target(url).request().get();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        this.assertEqualTrees(spans, new TestSpanTree());
    }

    @Test
    @RunAsClient
    private void testMetricsBaseNotTraced() {
        Client client = ClientBuilder.newClient();
        String url = String.format("%s/metrics/base", this.baseUrl());
        OpenTracingSkipPatternTests.debug("Executing " + url);
        client.target(url).request().get();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        this.assertEqualTrees(spans, new TestSpanTree());
    }

    @Test
    @RunAsClient
    private void testMetricsVendorNotTraced() {
        Client client = ClientBuilder.newClient();
        String url = String.format("%s/metrics/vendor", this.baseUrl());
        OpenTracingSkipPatternTests.debug("Executing " + url);
        client.target(url).request().get();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        this.assertEqualTrees(spans, new TestSpanTree());
    }

    @Test
    @RunAsClient
    private void testMetricsApplicationNotTraced() {
        Client client = ClientBuilder.newClient();
        String url = String.format("%s/metrics/application", this.baseUrl());
        OpenTracingSkipPatternTests.debug("Executing " + url);
        client.target(url).request().get();
        TestSpanTree spans = this.executeRemoteWebServiceTracerTree();
        this.assertEqualTrees(spans, new TestSpanTree());
    }

    private String baseUrl() {
        return String.format("http://%s:%d", this.deploymentURL.getHost(), this.deploymentURL.getPort());
    }

    public static class TestConfiguration
    implements ConfigSource {
        private Map<String, String> propMap = new HashMap<String, String>();

        public TestConfiguration() {
            this.propMap.put("mp.opentracing.server.skip-pattern", "/skipAll/.*|/testServices/skipSimple");
        }

        public Map<String, String> getProperties() {
            return this.propMap;
        }

        public String getValue(String s) {
            return this.propMap.get(s);
        }

        public String getName() {
            return this.getClass().getName();
        }

        public Set<String> getPropertyNames() {
            return this.getProperties().keySet();
        }
    }
}

