/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.channel;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;

@ApplicationScoped
public class MyBeanEmittingPayloadsWithAck {
    @Inject
    @Channel(value="foo")
    private Emitter<String> emitter;
    private final List<String> list = new CopyOnWriteArrayList<String>();
    private final List<CompletionStage<Void>> csList = new CopyOnWriteArrayList<CompletionStage<Void>>();

    public Emitter<String> emitter() {
        return this.emitter;
    }

    public List<String> list() {
        return this.list;
    }

    public void run() {
        this.csList.add(this.emitter.send((Object)"a"));
        this.csList.add(this.emitter.send((Object)"b"));
        this.csList.add(this.emitter.send((Object)"c"));
        this.emitter.complete();
    }

    List<CompletionStage<Void>> getCompletionStage() {
        return this.csList;
    }

    @Incoming(value="foo")
    @Acknowledgment(value=Acknowledgment.Strategy.MANUAL)
    public CompletionStage<Void> consume(Message<String> s) {
        this.list.add((String)s.getPayload());
        if (!"c".equals(s.getPayload())) {
            return s.ack();
        }
        return new CompletableFuture<Void>();
    }
}

