/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.scope;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;

@ApplicationScoped
public class ApplicationBeans {
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private int id;
    private List<Integer> list = new ArrayList<Integer>();
    private static final List<Integer> STATIC_LIST = new ArrayList<Integer>();

    @PostConstruct
    private void init() {
        this.id = COUNTER.getAndIncrement();
    }

    @Outgoing(value="source")
    public Publisher<Integer> source() {
        return ReactiveStreams.of((Object)this.id).buildRs();
    }

    @Incoming(value="source")
    @Outgoing(value="output")
    public int process(int i) {
        return i + 1;
    }

    @Incoming(value="output")
    public void sink(int v) {
        this.list.add(v);
        STATIC_LIST.add(v);
    }

    public List<Integer> getList() {
        return this.list;
    }

    public static List<Integer> getStaticList() {
        return STATIC_LIST;
    }
}

