/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.signatures.publishers;

import io.reactivex.Flowable;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.eclipse.microprofile.reactive.messaging.tck.TckBase;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;

@ApplicationScoped
public class PublisherBean {
    private static final Map<String, AtomicInteger> COUNTERS = new ConcurrentHashMap<String, AtomicInteger>();
    private AtomicInteger generatorPayload = new AtomicInteger();
    private AtomicInteger generatorMessage = new AtomicInteger();
    private AtomicInteger generatorAsyncMessage = new AtomicInteger();
    private AtomicInteger generatorAsyncPayload = new AtomicInteger();

    private static void increment(String counter) {
        COUNTERS.computeIfAbsent(counter, x -> new AtomicInteger(0)).incrementAndGet();
    }

    static Map<String, AtomicInteger> getCounters() {
        return COUNTERS;
    }

    @Outgoing(value="publisher-message")
    public Publisher<Message<String>> getAPublisherProducingMessage() {
        PublisherBean.increment("publisher-message");
        return ReactiveStreams.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).flatMap(i -> ReactiveStreams.of((Object[])new Integer[]{i, i})).map(i -> Integer.toString(i)).map(Message::of).buildRs();
    }

    @Outgoing(value="publisher-payload")
    public Publisher<String> getAPublisherProducingPayload() {
        PublisherBean.increment("publisher-payload");
        return ReactiveStreams.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).flatMap(i -> ReactiveStreams.of((Object[])new Integer[]{i, i})).map(i -> Integer.toString(i)).buildRs();
    }

    @Outgoing(value="publisher-builder-message")
    public PublisherBuilder<Message<String>> getAPublisherBuilderProducingMessage() {
        PublisherBean.increment("publisher-builder-message");
        return ReactiveStreams.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).flatMap(i -> ReactiveStreams.of((Object[])new Integer[]{i, i})).map(i -> Integer.toString(i)).map(Message::of);
    }

    @Outgoing(value="publisher-builder-payload")
    public PublisherBuilder<String> getAPublisherBuilderProducingPayload() {
        PublisherBean.increment("publisher-builder-payload");
        return ReactiveStreams.of((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10}).flatMap(i -> ReactiveStreams.of((Object[])new Integer[]{i, i})).map(i -> Integer.toString(i));
    }

    @Outgoing(value="publisher-flowable-message")
    public Flowable<Message<String>> getASubclassOfPublisherProducingMessage() {
        PublisherBean.increment("publisher-flowable-message");
        return this.getASubclassOfPublisherProducingPayload().map(Message::of);
    }

    @Outgoing(value="publisher-flowable-payload")
    public Flowable<String> getASubclassOfPublisherProducingPayload() {
        PublisherBean.increment("publisher-flowable-payload");
        return Flowable.range((int)1, (int)10).flatMap(i -> Flowable.just((Object)i, (Object)i)).map(i -> Integer.toString(i));
    }

    @Outgoing(value="generator-payload")
    public int getPayloads() {
        PublisherBean.increment("generator-payload");
        return this.generatorPayload.incrementAndGet();
    }

    @Outgoing(value="generator-message")
    public Message<Integer> getMessage() {
        PublisherBean.increment("generator-message");
        return Message.of((Object)this.generatorMessage.incrementAndGet());
    }

    @Outgoing(value="generator-message-async")
    public CompletionStage<Message<Integer>> getMessageAsync() {
        PublisherBean.increment("generator-message-async");
        return CompletableFuture.supplyAsync(() -> Message.of((Object)this.generatorAsyncMessage.incrementAndGet()), TckBase.EXECUTOR);
    }

    @Outgoing(value="generator-payload-async")
    public CompletionStage<Integer> getPayloadAsync() {
        PublisherBean.increment("generator-payload-async");
        return CompletableFuture.supplyAsync(() -> this.generatorAsyncPayload.incrementAndGet(), TckBase.EXECUTOR);
    }
}

