/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.signatures.publishers;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.ApplicationScoped;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.tck.signatures.publishers.PublisherBean;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Subscriber;

@ApplicationScoped
public class VerifierForPublisherBean {
    private Map<String, List<String>> collector = new ConcurrentHashMap<String, List<String>>();
    private static final List<String> EXPECTED = Arrays.asList("1", "1", "2", "2", "3", "3", "4", "4", "5", "5", "6", "6", "7", "7", "8", "8", "9", "9", "10", "10");

    @Incoming(value="publisher-flowable-message")
    public void getMessageFromASubclassOfPublisher(String value) {
        this.add("publisher-flowable-message", value);
    }

    @Incoming(value="publisher-flowable-payload")
    public void getPayloadFromASubclassOfPublisher(String value) {
        this.add("publisher-flowable-payload", value);
    }

    @Incoming(value="publisher-builder-message")
    public void getMessageFromAPublisherBuilder(String value) {
        this.add("publisher-builder-message", value);
    }

    @Incoming(value="publisher-builder-payload")
    public void getPayloadFromPublisherBuilder(String value) {
        this.add("publisher-builder-payload", value);
    }

    @Incoming(value="publisher-payload")
    public void getPayloadFromPublisher(String value) {
        this.add("publisher-payload", value);
    }

    @Incoming(value="publisher-message")
    public void getMessageFromPublisher(String value) {
        this.add("publisher-message", value);
    }

    @Incoming(value="generator-payload")
    public Subscriber<Integer> getFromInfinitePayloadGenerator() {
        return ReactiveStreams.builder().limit(10L).flatMap(i -> ReactiveStreams.of((Object[])new Integer[]{i, i})).map(i -> Integer.toString(i)).forEach(s -> this.add("generator-payload", (String)s)).build();
    }

    @Incoming(value="generator-message")
    public Subscriber<Message<Integer>> getFromInfiniteMessageGenerator() {
        return ReactiveStreams.builder().limit(10L).map(Message::getPayload).flatMap(i -> ReactiveStreams.of((Object[])new Integer[]{i, i})).map(i -> Integer.toString(i)).forEach(s -> this.add("generator-message", (String)s)).build();
    }

    @Incoming(value="generator-payload-async")
    public Subscriber<Integer> getFromInfiniteAsyncPayloadGenerator() {
        return ReactiveStreams.builder().limit(10L).flatMap(i -> ReactiveStreams.of((Object[])new Integer[]{i, i})).map(i -> Integer.toString(i)).forEach(s -> this.add("generator-payload-async", (String)s)).build();
    }

    @Incoming(value="generator-message-async")
    public Subscriber<Message<Integer>> getFromInfiniteAsyncMessageGenerator() {
        return ReactiveStreams.builder().limit(10L).map(Message::getPayload).flatMap(i -> ReactiveStreams.of((Object[])new Integer[]{i, i})).map(i -> Integer.toString(i)).forEach(s -> this.add("generator-message-async", (String)s)).build();
    }

    private void add(String key, String value) {
        this.collector.computeIfAbsent(key, x -> new CopyOnWriteArrayList()).add(value);
    }

    void verify() {
        Awaitility.await().until(() -> this.collector.size() == 10);
        ((MapAssert)Assertions.assertThat(this.collector).hasSize(10)).allSatisfy((k, v) -> {
            ListAssert cfr_ignored_0 = (ListAssert)Assertions.assertThat((List)v).containsExactlyElementsOf(EXPECTED);
        });
        Map<String, AtomicInteger> counters = PublisherBean.getCounters();
        Assertions.assertThat((AtomicInteger)counters.get("publisher-message")).hasValue(1);
        Assertions.assertThat((AtomicInteger)counters.get("publisher-payload")).hasValue(1);
        Assertions.assertThat((AtomicInteger)counters.get("publisher-builder-message")).hasValue(1);
        Assertions.assertThat((AtomicInteger)counters.get("publisher-builder-payload")).hasValue(1);
        int limit = 10;
        Assertions.assertThat((AtomicInteger)counters.get("generator-payload")).hasValueGreaterThanOrEqualTo(limit);
        Assertions.assertThat((AtomicInteger)counters.get("generator-message")).hasValueGreaterThanOrEqualTo(limit);
        Assertions.assertThat((AtomicInteger)counters.get("generator-payload-async")).hasValueGreaterThanOrEqualTo(limit);
        Assertions.assertThat((AtomicInteger)counters.get("generator-message-async")).hasValueGreaterThanOrEqualTo(limit);
    }
}

