/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.acknowledgement;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.eclipse.microprofile.reactive.messaging.tck.ArchiveExtender;
import org.eclipse.microprofile.reactive.messaging.tck.TckBase;
import org.eclipse.microprofile.reactive.messaging.tck.acknowledgement.EmitterBean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;

public class AsynchronousPayloadProcessorAckTest
extends TckBase {
    @Inject
    private EmitterBean bean;
    @Inject
    private MessageProcessor processor;
    @Inject
    private Sink sink;

    @Deployment
    public static Archive<JavaArchive> deployment() {
        JavaArchive archive = (JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{EmitterBean.class, Sink.class, MessageProcessor.class, ArchiveExtender.class})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        ServiceLoader.load(ArchiveExtender.class).iterator().forEachRemaining(ext -> ext.extend(archive));
        return archive;
    }

    @Test
    public void testThatMessagesAreAckedAfterSuccessfulProcessingOfPayload() throws InterruptedException, TimeoutException, ExecutionException {
        this.sink.reset();
        this.processor.disableFailureMode();
        Emitter<String> emitter = this.bean.getEmitter();
        ConcurrentHashMap.KeySetView acked = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView nacked = ConcurrentHashMap.newKeySet();
        this.run(acked, nacked, emitter);
        Awaitility.await().until(() -> this.sink.list().size() == 10);
        Assertions.assertThat(acked).hasSize(10);
        Assertions.assertThat(nacked).hasSize(0);
    }

    @Test
    public void testThatMessagesAreNackedAfterFailingProcessingOfPayload() throws InterruptedException, TimeoutException, ExecutionException {
        this.sink.reset();
        Emitter<String> emitter = this.bean.getEmitter();
        this.processor.enableFailureMode();
        ConcurrentHashMap.KeySetView acked = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView nacked = ConcurrentHashMap.newKeySet();
        List<Throwable> throwables = this.run(acked, nacked, emitter);
        Awaitility.await().until(() -> this.sink.list().size() == 7);
        Assertions.assertThat(acked).hasSize(7);
        Assertions.assertThat(nacked).hasSize(3);
        Assertions.assertThat(throwables).hasSize(3);
    }

    private List<Throwable> run(Set<String> acked, Set<String> nacked, Emitter<String> emitter) throws InterruptedException, TimeoutException, ExecutionException {
        CopyOnWriteArrayList<Throwable> reasons = new CopyOnWriteArrayList<Throwable>();
        CompletableFuture.allOf((CompletableFuture[])Stream.of("a", "b", "c", "d", "e", "f", "g", "h", "i", "j").map(i -> CompletableFuture.runAsync(() -> emitter.send(Message.of((Object)i, () -> {
            acked.add((String)i);
            return CompletableFuture.completedFuture(null);
        }, t -> {
            reasons.add((Throwable)t);
            nacked.add((String)i);
            return CompletableFuture.completedFuture(null);
        }))).thenApply(x -> i)).toArray(CompletableFuture[]::new)).get(10L, TimeUnit.SECONDS);
        return reasons;
    }

    @ApplicationScoped
    public static class MessageProcessor {
        private boolean failureModeEnabled = false;

        public void enableFailureMode() {
            this.failureModeEnabled = true;
        }

        public void disableFailureMode() {
            this.failureModeEnabled = false;
        }

        @Incoming(value="data")
        @Outgoing(value="out")
        public CompletionStage<String> process(String s) {
            if (this.failureModeEnabled) {
                if (s.equalsIgnoreCase("b")) {
                    throw new IllegalArgumentException("b");
                }
                if (s.equalsIgnoreCase("f")) {
                    return null;
                }
                if (s.equalsIgnoreCase("c")) {
                    CompletableFuture<String> cf = new CompletableFuture<String>();
                    cf.completeExceptionally(new IllegalArgumentException("c"));
                    return cf;
                }
            }
            return CompletableFuture.completedFuture(s.toUpperCase());
        }
    }

    @ApplicationScoped
    public static class Sink {
        private final List<String> list = new CopyOnWriteArrayList<String>();

        @Incoming(value="out")
        public void consume(String s) {
            this.list.add(s);
        }

        public List<String> list() {
            return this.list;
        }

        public void reset() {
            this.list.clear();
        }
    }
}

