/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.channel.overflow;

import jakarta.inject.Inject;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.reactive.messaging.tck.TckBase;
import org.eclipse.microprofile.reactive.messaging.tck.channel.overflow.BeanUsingBufferOverflowStrategy;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;

public class BufferOverflowStrategyOverflowTest
extends TckBase {
    @Inject
    private BeanUsingBufferOverflowStrategy bean;

    @Deployment
    public static Archive<JavaArchive> deployment() {
        return BufferOverflowStrategyOverflowTest.getBaseArchive().addClasses(new Class[]{BeanUsingBufferOverflowStrategy.class});
    }

    @Test
    public void testOverflow() {
        this.bean.tryEmitThousand();
        Assertions.assertThat((int)(this.bean.accepted().size() + this.bean.rejected().size())).isEqualTo(1000);
        Assertions.assertThat(this.bean.rejected()).isNotEmpty();
        Assertions.assertThat(this.bean.accepted()).containsAll((Iterable)IntStream.range(0, 300).mapToObj(Integer::toString).collect(Collectors.toList()));
        Awaitility.await().until(() -> this.bean.output().size() == this.bean.accepted().size());
        Assertions.assertThat(this.bean.accepted()).containsExactlyElementsOf(this.bean.accepted());
        Assertions.assertThat((Throwable)this.bean.failure()).isNull();
    }
}

