/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.api;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreamsFactory;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.eclipse.microprofile.reactive.streams.operators.spi.Graph;
import org.eclipse.microprofile.reactive.streams.operators.spi.ReactiveStreamsEngine;
import org.eclipse.microprofile.reactive.streams.operators.spi.Stage;
import org.eclipse.microprofile.reactive.streams.operators.spi.SubscriberWithCompletionStage;
import org.eclipse.microprofile.reactive.streams.operators.spi.UnsupportedStageException;
import org.eclipse.microprofile.reactive.streams.operators.tck.api.AbstractReactiveStreamsApiVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.api.Mocks;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ProcessorBuilderVerification
extends AbstractReactiveStreamsApiVerification {
    public ProcessorBuilderVerification(ReactiveStreamsFactory rs) {
        super(rs);
    }

    @Test
    public void map() {
        Graph graph = this.graphFor(this.builder().map(i -> i + 1));
        Assert.assertEquals(this.getAddedStage(Stage.Map.class, graph).getMapper().apply(1), (Object)2);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void mapNullFunction() {
        this.builder().map(null);
    }

    @Test
    public void peek() {
        AtomicInteger peeked = new AtomicInteger();
        Graph graph = this.graphFor(this.builder().peek(peeked::set));
        this.getAddedStage(Stage.Peek.class, graph).getConsumer().accept(1);
        Assert.assertEquals((int)peeked.get(), (int)1);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void peekNullConsumer() {
        this.builder().peek(null);
    }

    @Test
    public void filter() {
        Graph graph = this.graphFor(this.builder().filter(i -> i < 3));
        Assert.assertTrue((boolean)this.getAddedStage(Stage.Filter.class, graph).getPredicate().test(1));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void filterNullPredicate() {
        this.builder().filter(null);
    }

    @Test
    public void distinct() {
        Graph graph = this.graphFor(this.builder().distinct());
        this.getAddedStage(Stage.Distinct.class, graph);
    }

    @Test
    public void flatMap() {
        Graph graph = this.graphFor(this.builder().flatMap(i -> this.rs.empty()));
        Function flatMap = this.getAddedStage(Stage.FlatMap.class, graph).getMapper();
        Object result = flatMap.apply(1);
        Assert.assertTrue((boolean)(result instanceof Graph));
        Graph innerGraph = (Graph)result;
        Assert.assertEquals((int)innerGraph.getStages().size(), (int)1);
        this.assertEmptyStage((Stage)innerGraph.getStages().iterator().next());
    }

    @Test
    public void flatMapToBuilderFromDifferentReactiveStreamsImplementation() {
        Graph graph = this.graphFor(this.builder().flatMap(i -> Mocks.EMPTY_PUBLISHER_BUILDER));
        Function flatMap = this.getAddedStage(Stage.FlatMap.class, graph).getMapper();
        Object result = flatMap.apply(1);
        Assert.assertTrue((boolean)(result instanceof Graph));
        Assert.assertSame(result, (Object)Mocks.EMPTY_PUBLISHER_GRAPH);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void flatMapNullMapper() {
        this.builder().flatMap(null);
    }

    @Test
    public void flatMapRsPublisher() {
        Graph graph = this.graphFor(this.builder().flatMapRsPublisher(i -> Mocks.PUBLISHER));
        Function flatMap = this.getAddedStage(Stage.FlatMap.class, graph).getMapper();
        Object result = flatMap.apply(1);
        Assert.assertTrue((boolean)(result instanceof Graph));
        Graph innerGraph = (Graph)result;
        Assert.assertEquals((int)innerGraph.getStages().size(), (int)1);
        Stage inner = (Stage)innerGraph.getStages().iterator().next();
        Assert.assertTrue((boolean)(inner instanceof Stage.PublisherStage));
        Assert.assertEquals((Object)((Stage.PublisherStage)inner).getRsPublisher(), (Object)Mocks.PUBLISHER);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void flatMapRsPublisherNullMapper() {
        this.builder().flatMapRsPublisher(null);
    }

    @Test
    public void flatMapCompletionStage() throws Exception {
        Graph graph = this.graphFor(this.builder().flatMapCompletionStage(i -> CompletableFuture.completedFuture(i + 1)));
        CompletionStage result = (CompletionStage)this.getAddedStage(Stage.FlatMapCompletionStage.class, graph).getMapper().apply(1);
        Assert.assertEquals(result.toCompletableFuture().get(1L, TimeUnit.SECONDS), (Object)2);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void flatMapCompletionStageNullMapper() {
        this.builder().flatMapCompletionStage(null);
    }

    @Test
    public void flatMapIterable() {
        Graph graph = this.graphFor(this.builder().flatMapIterable(i -> Arrays.asList(i, i + 1)));
        Assert.assertEquals(this.getAddedStage(Stage.FlatMapIterable.class, graph).getMapper().apply(1), Arrays.asList(1, 2));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void flatMapIterableNullMapper() {
        this.builder().flatMapIterable(null);
    }

    @Test
    public void limit() {
        Graph graph = this.graphFor(this.builder().limit(3L));
        Assert.assertEquals((long)this.getAddedStage(Stage.Limit.class, graph).getLimit(), (long)3L);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void limitNegative() {
        this.builder().limit(-1L);
    }

    @Test
    public void skip() {
        Graph graph = this.graphFor(this.builder().skip(3L));
        Assert.assertEquals((long)this.getAddedStage(Stage.Skip.class, graph).getSkip(), (long)3L);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void skipNegative() {
        this.builder().skip(-1L);
    }

    @Test
    public void takeWhile() {
        Graph graph = this.graphFor(this.builder().takeWhile(i -> i < 3));
        Assert.assertTrue((boolean)this.getAddedStage(Stage.TakeWhile.class, graph).getPredicate().test(1));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void takeWhileNullPredicate() {
        this.builder().takeWhile(null);
    }

    @Test
    public void dropWhile() {
        Graph graph = this.graphFor(this.builder().dropWhile(i -> i < 3));
        Assert.assertTrue((boolean)this.getAddedStage(Stage.DropWhile.class, graph).getPredicate().test(1));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void dropWhileNullPredicate() {
        this.builder().dropWhile(null);
    }

    @Test
    public void forEach() {
        AtomicInteger received = new AtomicInteger();
        Graph graph = this.graphFor(this.builder().forEach(received::set));
        Collector collector = this.getAddedStage(Stage.Collect.class, graph).getCollector();
        Object container = collector.supplier().get();
        collector.accumulator().accept(container, 1);
        Assert.assertEquals((int)received.get(), (int)1);
        Assert.assertNull(collector.finisher().apply(container));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void forEachNullConsumer() {
        this.builder().forEach(null);
    }

    @Test
    public void ignore() {
        Graph graph = this.graphFor(this.builder().ignore());
        Collector collector = this.getAddedStage(Stage.Collect.class, graph).getCollector();
        Object container = collector.supplier().get();
        collector.accumulator().accept(container, 1);
        Assert.assertNull(collector.finisher().apply(container));
    }

    @Test
    public void cancel() {
        Graph graph = this.graphFor(this.builder().cancel());
        this.getAddedStage(Stage.Cancel.class, graph);
    }

    @Test
    public void reduceWithIdentity() {
        Graph graph = this.graphFor(this.builder().reduce((Object)1, (a, b) -> a - b));
        Collector collector = this.getAddedStage(Stage.Collect.class, graph).getCollector();
        Object container1 = collector.supplier().get();
        Assert.assertEquals(collector.finisher().apply(container1), (Object)1);
        Object container2 = collector.supplier().get();
        collector.accumulator().accept(container2, 3);
        Assert.assertEquals(collector.finisher().apply(container2), (Object)-2);
    }

    @Test
    public void reduceWithIdentityNullIdentityAllowed() {
        this.builder().reduce(null, (a, b) -> a);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void reduceWithIdentityNullAccumulator() {
        this.builder().reduce((Object)1, null);
    }

    @Test
    public void reduce() {
        Graph graph = this.graphFor(this.builder().reduce((a, b) -> a - b));
        Collector collector = this.getAddedStage(Stage.Collect.class, graph).getCollector();
        Object container1 = collector.supplier().get();
        Assert.assertEquals(collector.finisher().apply(container1), Optional.empty());
        Object container2 = collector.supplier().get();
        collector.accumulator().accept(container2, 2);
        Assert.assertEquals(collector.finisher().apply(container2), Optional.of(2));
        Object container3 = collector.supplier().get();
        collector.accumulator().accept(container3, 5);
        collector.accumulator().accept(container3, 2);
        Assert.assertEquals(collector.finisher().apply(container3), Optional.of(3));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void reduceNullAccumulator() {
        this.builder().reduce(null);
    }

    @Test
    public void findFirst() {
        Graph graph = this.graphFor(this.builder().findFirst());
        this.getAddedStage(Stage.FindFirst.class, graph);
    }

    @Test
    public void collect() {
        Collector collector = Collectors.toList();
        Graph graph = this.graphFor(this.builder().collect(collector));
        Assert.assertSame((Object)this.getAddedStage(Stage.Collect.class, graph).getCollector(), collector);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void collectNull() {
        this.builder().collect(null);
    }

    @Test
    public void collectComponents() {
        Supplier<Object> supplier = () -> null;
        BiConsumer<Object, Object> accumulator = (a, b) -> {};
        Graph graph = this.graphFor(this.builder().collect(supplier, accumulator));
        Collector collector = this.getAddedStage(Stage.Collect.class, graph).getCollector();
        Assert.assertSame(collector.supplier(), supplier);
        Assert.assertSame(collector.accumulator(), accumulator);
        Object myObject = new Object();
        Assert.assertSame(collector.finisher().apply(myObject), (Object)myObject);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void collectComponentsSupplierNull() {
        this.builder().collect(null, (a, b) -> {});
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void collectComponentsAccumulatorNull() {
        this.builder().collect(() -> null, null);
    }

    @Test
    public void toList() {
        Graph graph = this.graphFor(this.builder().toList());
        Collector collector = this.getAddedStage(Stage.Collect.class, graph).getCollector();
        Object container = collector.supplier().get();
        collector.accumulator().accept(container, 1);
        collector.accumulator().accept(container, 2);
        collector.accumulator().accept(container, 3);
        Assert.assertEquals(collector.finisher().apply(container), Arrays.asList(1, 2, 3));
    }

    @Test
    public void toSubscriber() {
        Graph graph = this.graphFor(this.builder().to(Mocks.SUBSCRIBER));
        Assert.assertSame((Object)this.getAddedStage(Stage.SubscriberStage.class, graph).getRsSubscriber(), (Object)Mocks.SUBSCRIBER);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void toSubscriberNull() {
        this.builder().to((Subscriber)null);
    }

    @Test
    public void to() {
        Graph graph = this.graphFor(this.builder().to(this.rs.fromSubscriber(Mocks.SUBSCRIBER)));
        Assert.assertSame((Object)this.getAddedStage(Stage.SubscriberStage.class, graph).getRsSubscriber(), (Object)Mocks.SUBSCRIBER);
    }

    @Test
    public void toBuilderFromDifferentReactiveStreamsImplementation() {
        Graph graph = this.graphFor(this.builder().to(Mocks.SUBSCRIBER_BUILDER));
        Assert.assertEquals((int)graph.getStages().size(), (int)3);
        Iterator stages = graph.getStages().iterator();
        Assert.assertTrue((boolean)(stages.next() instanceof Stage.Map));
        Assert.assertTrue((boolean)(stages.next() instanceof Stage.Distinct));
        Assert.assertTrue((boolean)(stages.next() instanceof Stage.Cancel));
    }

    @Test
    public void toMultipleStages() {
        Graph graph = this.graphFor(this.builder().to(this.rs.builder().map(Function.identity()).cancel()));
        Assert.assertEquals((int)graph.getStages().size(), (int)3);
        Iterator stages = graph.getStages().iterator();
        Assert.assertTrue((boolean)(stages.next() instanceof Stage.Map));
        Assert.assertTrue((boolean)(stages.next() instanceof Stage.Map));
        Assert.assertTrue((boolean)(stages.next() instanceof Stage.Cancel));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void toNull() {
        this.builder().to((SubscriberBuilder)null);
    }

    @Test
    public void viaProcessor() {
        Graph graph = this.graphFor(this.builder().via(Mocks.PROCESSOR));
        Assert.assertSame((Object)this.getAddedStage(Stage.ProcessorStage.class, graph).getRsProcessor(), (Object)Mocks.PROCESSOR);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void viaProcessorNull() {
        this.builder().via((Processor)null);
    }

    @Test
    public void via() {
        Graph graph = this.graphFor(this.builder().via(this.rs.fromProcessor(Mocks.PROCESSOR)));
        Assert.assertSame((Object)this.getAddedStage(Stage.ProcessorStage.class, graph).getRsProcessor(), (Object)Mocks.PROCESSOR);
    }

    @Test
    public void viaBuilderFromDifferentReactiveStreamsImplementation() {
        Graph graph = this.graphFor(this.builder().via(Mocks.PROCESSOR_BUILDER));
        Assert.assertEquals((int)graph.getStages().size(), (int)3);
        Iterator stages = graph.getStages().iterator();
        Assert.assertTrue((boolean)(stages.next() instanceof Stage.Map));
        Assert.assertTrue((boolean)(stages.next() instanceof Stage.Distinct));
        Assert.assertTrue((boolean)(stages.next() instanceof Stage.Limit));
    }

    @Test
    public void viaEmpty() {
        Graph graph = this.graphFor(this.builder().via(this.rs.builder()));
        Assert.assertEquals((int)graph.getStages().size(), (int)1);
        Assert.assertTrue((boolean)(graph.getStages().iterator().next() instanceof Stage.Map));
    }

    @Test
    public void viaMultipleStages() {
        Graph graph = this.graphFor(this.builder().via(this.rs.builder().map(Function.identity()).filter(t -> true)));
        Assert.assertEquals((int)graph.getStages().size(), (int)3);
        Iterator stages = graph.getStages().iterator();
        Assert.assertTrue((boolean)(stages.next() instanceof Stage.Map));
        Assert.assertTrue((boolean)(stages.next() instanceof Stage.Map));
        Assert.assertTrue((boolean)(stages.next() instanceof Stage.Filter));
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void viaNull() {
        this.builder().via((ProcessorBuilder)null);
    }

    @Test
    public void onError() {
        Consumer<Object> consumer = t -> {};
        Graph graph = this.graphFor(this.builder().onError(consumer));
        Assert.assertSame((Object)this.getAddedStage(Stage.OnError.class, graph).getConsumer(), consumer);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void onErrorNullConsumer() {
        this.builder().onError(null);
    }

    @Test
    public void onErrorResume() {
        Graph graph = this.graphFor(this.builder().onErrorResume(t -> 2));
        Assert.assertEquals(this.getAddedStage(Stage.OnErrorResume.class, graph).getFunction().apply(new RuntimeException()), (Object)2);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void onErrorResumeNull() {
        this.builder().onErrorResume(null);
    }

    @Test
    public void onErrorResumeWith() {
        Graph graph = this.graphFor(this.builder().onErrorResumeWith(t -> this.rs.empty()));
        Graph resumeWith = (Graph)this.getAddedStage(Stage.OnErrorResumeWith.class, graph).getFunction().apply(new RuntimeException());
        Assert.assertEquals((int)resumeWith.getStages().size(), (int)1);
        this.assertEmptyStage((Stage)resumeWith.getStages().iterator().next());
    }

    @Test
    public void onErrorResumeWithToBuilderFromDifferentReactiveStreamsImplementation() {
        Graph graph = this.graphFor(this.builder().onErrorResumeWith(t -> Mocks.EMPTY_PUBLISHER_BUILDER));
        Graph resumeWith = (Graph)this.getAddedStage(Stage.OnErrorResumeWith.class, graph).getFunction().apply(new RuntimeException());
        Assert.assertSame((Object)resumeWith, (Object)Mocks.EMPTY_PUBLISHER_GRAPH);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void onErrorResumeWithNull() {
        this.builder().onErrorResumeWith(null);
    }

    @Test
    public void onErrorResumeWithRsPublisher() {
        Graph graph = this.graphFor(this.builder().onErrorResumeWithRsPublisher(t -> Mocks.PUBLISHER));
        Graph resumeWith = (Graph)this.getAddedStage(Stage.OnErrorResumeWith.class, graph).getFunction().apply(new RuntimeException());
        Assert.assertEquals((int)resumeWith.getStages().size(), (int)1);
        Assert.assertSame((Object)((Stage.PublisherStage)resumeWith.getStages().iterator().next()).getRsPublisher(), (Object)Mocks.PUBLISHER);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void onErrorResumeWithRsPublisherNull() {
        this.builder().onErrorResumeWithRsPublisher(null);
    }

    @Test
    public void onTerminate() {
        Runnable action = () -> {};
        Graph graph = this.graphFor(this.builder().onTerminate(action));
        Assert.assertSame((Object)this.getAddedStage(Stage.OnTerminate.class, graph).getAction(), (Object)action);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void onTerminateNull() {
        this.builder().onTerminate(null);
    }

    @Test
    public void onComplete() {
        Runnable action = () -> {};
        Graph graph = this.graphFor(this.builder().onComplete(action));
        Assert.assertSame((Object)this.getAddedStage(Stage.OnComplete.class, graph).getAction(), (Object)action);
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void onCompleteNull() {
        this.builder().onComplete(null);
    }

    @Test
    public void buildRs() {
        final AtomicReference builtGraph = new AtomicReference();
        Processor processor = this.builder().distinct().buildRs(new ReactiveStreamsEngine(){

            public <T> Publisher<T> buildPublisher(Graph graph) throws UnsupportedStageException {
                throw new RuntimeException("Wrong method invoked");
            }

            public <T, R> SubscriberWithCompletionStage<T, R> buildSubscriber(Graph graph) throws UnsupportedStageException {
                throw new RuntimeException("Wrong method invoked");
            }

            public <T, R> Processor<T, R> buildProcessor(Graph graph) throws UnsupportedStageException {
                builtGraph.set(graph);
                return Mocks.PROCESSOR;
            }

            public <T> CompletionStage<T> buildCompletion(Graph graph) throws UnsupportedStageException {
                throw new RuntimeException("Wrong method invoked");
            }
        });
        Assert.assertSame((Object)processor, (Object)Mocks.PROCESSOR);
        this.getAddedStage(Stage.Distinct.class, (Graph)builtGraph.get());
    }

    @Test(expectedExceptions={NullPointerException.class})
    public void buildRsNull() {
        this.builder().buildRs(null);
    }

    @Test
    public void builderShouldBeImmutable() {
        ProcessorBuilder<Integer, Integer> builder = this.builder();
        ProcessorBuilder mapped = builder.map(Function.identity());
        ProcessorBuilder distinct = builder.distinct();
        SubscriberBuilder cancelled = builder.cancel();
        this.getAddedStage(Stage.Map.class, this.graphFor(mapped));
        this.getAddedStage(Stage.Distinct.class, this.graphFor(distinct));
        this.getAddedStage(Stage.Cancel.class, this.graphFor(cancelled));
    }

    private ProcessorBuilder<Integer, Integer> builder() {
        return this.rs.builder().map(Function.identity());
    }

    private <S extends Stage> S getAddedStage(Class<S> clazz, Graph graph) {
        Assert.assertEquals((int)graph.getStages().size(), (int)2, (String)"Graph does not have two stages");
        Iterator stages = graph.getStages().iterator();
        Stage first = (Stage)stages.next();
        Assert.assertTrue((boolean)(first instanceof Stage.Map), (String)("First stage " + first + " is not a " + Stage.Map.class));
        Stage second = (Stage)stages.next();
        Assert.assertTrue((boolean)clazz.isInstance(second), (String)("Second stage " + second + " is not a " + clazz));
        return (S)((Stage)clazz.cast(second));
    }
}

