/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.spi;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreamsFactory;
import org.eclipse.microprofile.reactive.streams.operators.spi.ReactiveStreamsEngine;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.ReactiveStreamsSpiVerification;
import org.reactivestreams.Publisher;
import org.reactivestreams.tck.IdentityProcessorVerification;
import org.reactivestreams.tck.PublisherVerification;
import org.reactivestreams.tck.SubscriberBlackboxVerification;
import org.reactivestreams.tck.SubscriberWhiteboxVerification;
import org.reactivestreams.tck.TestEnvironment;

abstract class AbstractStageVerification {
    protected final ReactiveStreamsFactory rs;
    private final ReactiveStreamsEngine engine;
    private final TestEnvironment environment;
    private final ScheduledExecutorService executorService;

    AbstractStageVerification(ReactiveStreamsSpiVerification.VerificationDeps deps) {
        this.rs = deps.rs();
        this.engine = deps.engine();
        this.environment = deps.testEnvironment();
        this.executorService = deps.executorService();
    }

    ReactiveStreamsEngine getEngine() {
        return this.engine;
    }

    ScheduledExecutorService getExecutorService() {
        return this.executorService;
    }

    abstract List<Object> reactiveStreamsTckVerifiers();

    <T> T await(CompletionStage<T> future) {
        try {
            return future.toCompletableFuture().get(this.environment.defaultTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Future timed out after " + this.environment.defaultTimeoutMillis() + "ms", e);
        }
    }

    PublisherBuilder<Integer> infiniteStream() {
        return this.rs.fromIterable(() -> {
            AtomicInteger value = new AtomicInteger();
            return IntStream.generate(value::incrementAndGet).boxed().iterator();
        });
    }

    <T> PublisherBuilder<T> idlePublisher() {
        return this.rs.fromCompletionStage(new CompletableFuture());
    }

    abstract class StageSubscriberBlackboxVerification<T>
    extends SubscriberBlackboxVerification<T> {
        StageSubscriberBlackboxVerification() {
            super(AbstractStageVerification.this.environment);
        }
    }

    abstract class StageSubscriberWhiteboxVerification<T>
    extends SubscriberWhiteboxVerification<T> {
        StageSubscriberWhiteboxVerification() {
            super(AbstractStageVerification.this.environment);
        }
    }

    abstract class StageProcessorVerification<T>
    extends IdentityProcessorVerification<T> {
        StageProcessorVerification() {
            super(AbstractStageVerification.this.environment);
        }

        public ExecutorService publisherExecutorService() {
            return AbstractStageVerification.this.executorService;
        }

        public Publisher<T> createFailedPublisher() {
            return AbstractStageVerification.this.rs.failed((Throwable)new RuntimeException("failed")).buildRs(AbstractStageVerification.this.engine);
        }

        public long maxSupportedSubscribers() {
            return 1L;
        }
    }

    abstract class StagePublisherVerification<T>
    extends PublisherVerification<T> {
        StagePublisherVerification() {
            super(AbstractStageVerification.this.environment);
        }

        public Publisher<T> createFailedPublisher() {
            return AbstractStageVerification.this.rs.failed((Throwable)new RuntimeException("failed")).buildRs(AbstractStageVerification.this.engine);
        }
    }
}

