/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.eclipse.microprofile.reactive.streams.operators.SubscriberBuilder;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.AbstractStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.QuietRuntimeException;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.ReactiveStreamsSpiVerification;
import org.reactivestreams.Subscriber;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CollectStageVerification
extends AbstractStageVerification {
    CollectStageVerification(ReactiveStreamsSpiVerification.VerificationDeps deps) {
        super(deps);
    }

    @Test
    public void toListStageShouldReturnAList() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3}).toList().run(this.getEngine()))), Arrays.asList(1, 2, 3));
    }

    @Test
    public void toListStageShouldReturnEmpty() {
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of(new Object[0]).toList().run(this.getEngine()))), Collections.emptyList());
    }

    @Test
    public void collectShouldAccumulateResult() {
        Assert.assertEquals((int)((AtomicInteger)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3}).collect(() -> new AtomicInteger(0), AtomicInteger::addAndGet).run(this.getEngine()))).get(), (int)6);
    }

    @Test
    public void collectShouldSupportEmptyStreams() {
        Assert.assertEquals((int)((AtomicInteger)this.await(this.rs.empty().collect(() -> new AtomicInteger(42), AtomicInteger::addAndGet).run(this.getEngine()))).get(), (int)42);
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void collectShouldPropagateUpstreamErrors() {
        this.await(this.rs.failed((Throwable)new QuietRuntimeException("failed")).collect(() -> new AtomicInteger(0), AtomicInteger::addAndGet).run(this.getEngine()));
    }

    @Test
    public void finisherFunctionShouldBeInvoked() {
        Assert.assertEquals((String)((String)this.await(this.rs.of((Object[])new String[]{"1", "2", "3"}).collect(Collectors.joining(", ")).run(this.getEngine()))), (String)"1, 2, 3");
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void toListStageShouldPropagateUpstreamErrors() {
        this.await(this.rs.failed((Throwable)new QuietRuntimeException("failed")).toList().run(this.getEngine()));
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void collectStageShouldPropagateErrorsFromSupplierThroughCompletionStage() {
        CompletableFuture cancelled = new CompletableFuture();
        CompletionStage result = null;
        try {
            result = this.infiniteStream().onTerminate(() -> cancelled.complete(null)).collect(Collector.of(() -> {
                throw new QuietRuntimeException("failed");
            }, (a, b) -> {}, (a, b) -> a + b, Function.identity(), new Collector.Characteristics[0])).run(this.getEngine());
        }
        catch (Exception e) {
            Assert.fail((String)"Exception thrown directly from stream, it should have been captured by the returned CompletionStage", (Throwable)e);
        }
        this.await(cancelled);
        this.await(result);
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void collectStageShouldPropagateErrorsFromAccumulator() {
        CompletableFuture cancelled = new CompletableFuture();
        CompletionStage result = this.infiniteStream().onTerminate(() -> cancelled.complete(null)).collect(Collector.of(() -> "", (a, b) -> {
            throw new QuietRuntimeException("failed");
        }, (a, b) -> a + b, Function.identity(), new Collector.Characteristics[0])).run(this.getEngine());
        this.await(cancelled);
        this.await(result);
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp="failed")
    public void collectStageShouldPropagateErrorsFromFinisher() {
        CompletionStage result = this.rs.of((Object[])new Integer[]{1, 2, 3}).collect(Collector.of(() -> 0, (a, b) -> {}, (a, b) -> a + b, r -> {
            throw new QuietRuntimeException("failed");
        }, new Collector.Characteristics[0])).run(this.getEngine());
        this.await(result);
    }

    @Test
    public void collectStageBuilderShouldBeReusable() {
        SubscriberBuilder toList = this.rs.builder().toList();
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{1, 2, 3}).to(toList).run(this.getEngine()))), Arrays.asList(1, 2, 3));
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new Integer[]{4, 5, 6}).to(toList).run(this.getEngine()))), Arrays.asList(4, 5, 6));
    }

    @Override
    List<Object> reactiveStreamsTckVerifiers() {
        return Arrays.asList(new Object[]{new ToListSubscriberVerification(), new CollectSubscriberVerification()});
    }

    class ToListSubscriberVerification
    extends AbstractStageVerification.StageSubscriberBlackboxVerification<Integer> {
        ToListSubscriberVerification() {
        }

        public Subscriber<Integer> createSubscriber() {
            return CollectStageVerification.this.rs.builder().toList().build(CollectStageVerification.this.getEngine());
        }

        public Integer createElement(int element) {
            return element;
        }
    }

    class CollectSubscriberVerification
    extends AbstractStageVerification.StageSubscriberBlackboxVerification<Integer> {
        CollectSubscriberVerification() {
        }

        public Subscriber<Integer> createSubscriber() {
            return CollectStageVerification.this.rs.builder().collect(() -> new AtomicInteger(0), AtomicInteger::addAndGet).build(CollectStageVerification.this.getEngine());
        }

        public Integer createElement(int element) {
            return element;
        }
    }
}

