/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.LongStream;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreamsFactory;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.AbstractStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.QuietRuntimeException;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.ReactiveStreamsSpiVerification;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.testng.Assert;
import org.testng.annotations.Test;

public class OnErrorResumeStageVerification
extends AbstractStageVerification {
    OnErrorResumeStageVerification(ReactiveStreamsSpiVerification.VerificationDeps deps) {
        super(deps);
    }

    @Test
    public void onErrorResumeShouldCatchErrorFromSource() {
        AtomicReference exception = new AtomicReference();
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.failed((Throwable)new QuietRuntimeException("failed")).onErrorResume(err -> {
            exception.set(err);
            return "foo";
        }).toList().run(this.getEngine()))), Collections.singletonList("foo"));
        Assert.assertEquals((String)((Throwable)exception.get()).getMessage(), (String)"failed");
    }

    @Test
    public void onErrorResumeWithShouldCatchErrorFromSource() {
        AtomicReference exception = new AtomicReference();
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.failed((Throwable)new QuietRuntimeException("failed")).onErrorResumeWith(err -> {
            exception.set(err);
            return this.rs.of((Object[])new String[]{"foo", "bar"});
        }).toList().run(this.getEngine()))), Arrays.asList("foo", "bar"));
        Assert.assertEquals((String)((Throwable)exception.get()).getMessage(), (String)"failed");
    }

    @Test
    public void onErrorResumeWithRsPublisherShouldCatchErrorFromSource() {
        AtomicReference exception = new AtomicReference();
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.failed((Throwable)new QuietRuntimeException("failed")).onErrorResumeWithRsPublisher(err -> {
            exception.set(err);
            return this.rs.of((Object[])new String[]{"foo", "bar"}).buildRs(this.getEngine());
        }).toList().run(this.getEngine()))), Arrays.asList("foo", "bar"));
        Assert.assertEquals((String)((Throwable)exception.get()).getMessage(), (String)"failed");
    }

    @Test
    public void onErrorResumeShouldCatchErrorFromStage() {
        AtomicReference exception = new AtomicReference();
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new String[]{"a", "b", "c"}).map(word -> {
            if (word.equals("b")) {
                throw new QuietRuntimeException("failed");
            }
            return word.toUpperCase();
        }).onErrorResume(err -> {
            exception.set(err);
            return "foo";
        }).toList().run(this.getEngine()))), Arrays.asList("A", "foo"));
        Assert.assertEquals((String)((Throwable)exception.get()).getMessage(), (String)"failed");
    }

    @Test
    public void onErrorResumeWithShouldCatchErrorFromStage() {
        AtomicReference exception = new AtomicReference();
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new String[]{"a", "b", "c"}).map(word -> {
            if (word.equals("b")) {
                throw new QuietRuntimeException("failed");
            }
            return word.toUpperCase();
        }).onErrorResumeWith(err -> {
            exception.set(err);
            return this.rs.of((Object[])new String[]{"foo", "bar"});
        }).toList().run(this.getEngine()))), Arrays.asList("A", "foo", "bar"));
        Assert.assertEquals((String)((Throwable)exception.get()).getMessage(), (String)"failed");
    }

    @Test
    public void onErrorResumeWithRsPublisherShouldCatchErrorFromStage() {
        AtomicReference exception = new AtomicReference();
        Assert.assertEquals((Collection)((Collection)this.await(this.rs.of((Object[])new String[]{"a", "b", "c"}).map(word -> {
            if (word.equals("b")) {
                throw new QuietRuntimeException("failed");
            }
            return word.toUpperCase();
        }).onErrorResumeWithRsPublisher(err -> {
            exception.set(err);
            return this.rs.of((Object[])new String[]{"foo", "bar"}).buildRs(this.getEngine());
        }).toList().run(this.getEngine()))), Arrays.asList("A", "foo", "bar"));
        Assert.assertEquals((String)((Throwable)exception.get()).getMessage(), (String)"failed");
    }

    @Test(expectedExceptions={RuntimeException.class})
    public void onErrorResumeStageShouldPropagateRuntimeExceptions() {
        this.await(this.rs.failed((Throwable)new Exception("source-failure")).onErrorResume(t -> {
            throw new QuietRuntimeException("failed");
        }).toList().run(this.getEngine()));
    }

    @Test(expectedExceptions={RuntimeException.class})
    public void onErrorResumeWithStageShouldPropagateRuntimeExceptions() {
        this.await(this.rs.failed((Throwable)new Exception("source-failure")).onErrorResumeWith(t -> {
            throw new QuietRuntimeException("failed");
        }).toList().run(this.getEngine()));
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp=".*failed.*")
    public void onErrorResumeWithRsPublisherStageShouldPropagateRuntimeExceptions() {
        this.await(this.rs.failed((Throwable)new QuietRuntimeException("source-failure")).onErrorResumeWithRsPublisher(t -> {
            throw new QuietRuntimeException("failed");
        }).toList().run(this.getEngine()));
    }

    @Test(expectedExceptions={QuietRuntimeException.class}, expectedExceptionsMessageRegExp=".*boom.*")
    public void onErrorResumeWithShouldBeAbleToInjectAFailure() {
        this.await(this.rs.failed((Throwable)new QuietRuntimeException("failed")).onErrorResumeWith(err -> this.rs.failed((Throwable)new QuietRuntimeException("boom"))).toList().run(this.getEngine()));
    }

    @Test(expectedExceptions={RuntimeException.class}, expectedExceptionsMessageRegExp=".*boom.*")
    public void onErrorResumeWithRsPublisherShouldBeAbleToInjectAFailure() {
        this.await(this.rs.failed((Throwable)new QuietRuntimeException("failed")).onErrorResumeWithRsPublisher(err -> this.rs.failed((Throwable)new QuietRuntimeException("boom")).buildRs(this.getEngine())).toList().run(this.getEngine()));
    }

    @Override
    List<Object> reactiveStreamsTckVerifiers() {
        return Arrays.asList(new Object[]{new OnErrorResumeWithVerification(), new OnErrorResumeVerification(), new OnErrorResumeWithPublisherVerification()});
    }

    public class OnErrorResumeWithVerification
    extends AbstractStageVerification.StageProcessorVerification<Integer> {
        public Processor<Integer, Integer> createIdentityProcessor(int bufferSize) {
            return OnErrorResumeStageVerification.this.rs.builder().onErrorResumeWith(arg_0 -> ((ReactiveStreamsFactory)OnErrorResumeStageVerification.this.rs).failed(arg_0)).map(Function.identity()).buildRs(OnErrorResumeStageVerification.this.getEngine());
        }

        @Override
        public Publisher<Integer> createFailedPublisher() {
            return OnErrorResumeStageVerification.this.rs.failed((Throwable)new RuntimeException("failed")).onErrorResumeWith(t -> {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException((Throwable)t);
            }).buildRs(OnErrorResumeStageVerification.this.getEngine());
        }

        public Integer createElement(int element) {
            return element;
        }
    }

    public class OnErrorResumeVerification
    extends AbstractStageVerification.StageProcessorVerification<Integer> {
        public Processor<Integer, Integer> createIdentityProcessor(int bufferSize) {
            return OnErrorResumeStageVerification.this.rs.builder().onErrorResume(t -> {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException((Throwable)t);
            }).map(Function.identity()).buildRs(OnErrorResumeStageVerification.this.getEngine());
        }

        @Override
        public Publisher<Integer> createFailedPublisher() {
            return OnErrorResumeStageVerification.this.rs.failed((Throwable)new RuntimeException("failed")).onErrorResume(t -> {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new RuntimeException((Throwable)t);
            }).buildRs(OnErrorResumeStageVerification.this.getEngine());
        }

        public Integer createElement(int element) {
            return element;
        }
    }

    public class OnErrorResumeWithPublisherVerification
    extends AbstractStageVerification.StagePublisherVerification<Long> {
        public Publisher<Long> createPublisher(long elements) {
            return OnErrorResumeStageVerification.this.rs.failed((Throwable)new Exception("BOOM")).onErrorResumeWith(t -> OnErrorResumeStageVerification.this.rs.fromIterable(() -> LongStream.rangeClosed(1L, elements).boxed().iterator())).buildRs(OnErrorResumeStageVerification.this.getEngine());
        }
    }
}

