/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.spi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreamsFactory;
import org.eclipse.microprofile.reactive.streams.operators.spi.ReactiveStreamsEngine;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.AbstractStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.CancelStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.CollectStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.ConcatStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.CoupledStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.DistinctStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.DropWhileStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.EmptyProcessorVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.FilterStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.FindFirstStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.FlatMapCompletionStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.FlatMapIterableStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.FlatMapStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.FromCompletionStageNullableVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.FromCompletionStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.LimitStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.MapStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.OfStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.OnErrorResumeStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.OnStagesVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.PeekStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.SkipStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.SubscriberStageVerification;
import org.eclipse.microprofile.reactive.streams.operators.tck.spi.TakeWhileStageVerification;
import org.reactivestreams.tck.TestEnvironment;

public class ReactiveStreamsSpiVerification {
    private final TestEnvironment testEnvironment;
    private final ReactiveStreamsFactory rs;
    private final ReactiveStreamsEngine engine;
    private final ScheduledExecutorService executorService;

    public ReactiveStreamsSpiVerification(TestEnvironment testEnvironment, ReactiveStreamsFactory rs, ReactiveStreamsEngine engine, ScheduledExecutorService executorService) {
        this.testEnvironment = testEnvironment;
        this.rs = rs;
        this.engine = engine;
        this.executorService = executorService;
    }

    public List<Object> allTests() {
        List<Function> stageVerifications = Arrays.asList(OfStageVerification::new, MapStageVerification::new, FlatMapStageVerification::new, FilterStageVerification::new, FindFirstStageVerification::new, CollectStageVerification::new, TakeWhileStageVerification::new, FlatMapCompletionStageVerification::new, FlatMapIterableStageVerification::new, ConcatStageVerification::new, EmptyProcessorVerification::new, CancelStageVerification::new, SubscriberStageVerification::new, PeekStageVerification::new, DistinctStageVerification::new, OnStagesVerification::new, LimitStageVerification::new, SkipStageVerification::new, DropWhileStageVerification::new, OnErrorResumeStageVerification::new, FromCompletionStageVerification::new, FromCompletionStageNullableVerification::new, CoupledStageVerification::new);
        ArrayList<Object> allTests = new ArrayList<Object>();
        VerificationDeps deps = new VerificationDeps();
        for (Function creator : stageVerifications) {
            AbstractStageVerification stageVerification = (AbstractStageVerification)creator.apply(deps);
            allTests.add(stageVerification);
            allTests.addAll(stageVerification.reactiveStreamsTckVerifiers());
        }
        return allTests;
    }

    public class VerificationDeps {
        ReactiveStreamsFactory rs() {
            return ReactiveStreamsSpiVerification.this.rs;
        }

        ReactiveStreamsEngine engine() {
            return ReactiveStreamsSpiVerification.this.engine;
        }

        TestEnvironment testEnvironment() {
            return ReactiveStreamsSpiVerification.this.testEnvironment;
        }

        ScheduledExecutorService executorService() {
            return ReactiveStreamsSpiVerification.this.executorService;
        }
    }
}

