/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.streams.operators.tck.spi;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.testng.Assert;

class ScheduledPublisher
implements Publisher<Integer> {
    private final int id;
    private AtomicBoolean published = new AtomicBoolean(false);
    private final AtomicInteger activePublishers;
    private final Supplier<ScheduledExecutorService> supplier;

    ScheduledPublisher(int id, AtomicInteger activePublishers, Supplier<ScheduledExecutorService> supplier) {
        this.id = id;
        this.activePublishers = activePublishers;
        this.supplier = supplier;
    }

    public void subscribe(final Subscriber<? super Integer> subscriber) {
        Assert.assertEquals((int)this.activePublishers.incrementAndGet(), (int)1);
        subscriber.onSubscribe(new Subscription(){

            public void request(long n) {
                if (ScheduledPublisher.this.published.compareAndSet(false, true)) {
                    ScheduledPublisher.this.getExecutorService().schedule(() -> {
                        subscriber.onNext((Object)ScheduledPublisher.this.id);
                        ScheduledPublisher.this.getExecutorService().schedule(() -> {
                            ScheduledPublisher.this.activePublishers.decrementAndGet();
                            subscriber.onComplete();
                        }, 100L, TimeUnit.MILLISECONDS);
                    }, 100L, TimeUnit.MILLISECONDS);
                }
            }

            public void cancel() {
            }
        });
    }

    private ScheduledExecutorService getExecutorService() {
        return this.supplier.get();
    }
}

