/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.ext;

import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

public class ResponseExceptionMapperTest {
    @Test
    public void testHandles() {
        MultivaluedHashMap headers = new MultivaluedHashMap();
        DummyResponseExceptionMapper mapper = new DummyResponseExceptionMapper();
        Assert.assertTrue((boolean)mapper.handles(500, (MultivaluedMap)headers));
        Assert.assertTrue((boolean)mapper.handles(400, (MultivaluedMap)headers));
        AssertJUnit.assertFalse((boolean)mapper.handles(300, (MultivaluedMap)headers));
    }

    @Test
    public void testGetPriority() {
        DummyResponseExceptionMapper mapper = new DummyResponseExceptionMapper();
        AssertJUnit.assertEquals((int)5000, (int)mapper.getPriority());
    }

    @Test
    public void testGetPriorityWithAnnotation() {
        PriorityResponseExceptionMapper mapper = new PriorityResponseExceptionMapper();
        AssertJUnit.assertEquals((int)4000, (int)mapper.getPriority());
    }

    @Priority(value=4000)
    private static class PriorityResponseExceptionMapper
    implements ResponseExceptionMapper<WebApplicationException> {
        private PriorityResponseExceptionMapper() {
        }

        public WebApplicationException toThrowable(Response response) {
            return new WebApplicationException(response);
        }
    }

    private static class DummyResponseExceptionMapper
    implements ResponseExceptionMapper<WebApplicationException> {
        private DummyResponseExceptionMapper() {
        }

        public WebApplicationException toThrowable(Response response) {
            return new WebApplicationException(response);
        }
    }
}

