/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.interfaces.RootResource;
import org.eclipse.microprofile.rest.client.tck.interfaces.SubResource;
import org.eclipse.microprofile.rest.client.tck.providers.ReturnWithURLRequestFilter;
import org.eclipse.microprofile.rest.client.tck.providers.TestResponseExceptionMapper;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

public class SubResourceTest
extends Arquillian {
    @Deployment
    public static Archive<?> createDeployment() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(SubResourceTest.class.getSimpleName() + ".war"))).addClasses(new Class[]{RootResource.class, SubResource.class, TestResponseExceptionMapper.class})).addPackage(ReturnWithURLRequestFilter.class.getPackage());
    }

    @BeforeTest
    public void resetHandlers() {
        TestResponseExceptionMapper.reset();
    }

    @Test
    public void canInvokeMethodOnSubResourceInterface() throws Exception {
        ReturnWithURLRequestFilter filter = new ReturnWithURLRequestFilter();
        RestClientBuilder builder = (RestClientBuilder)RestClientBuilder.newBuilder().register((Object)filter);
        RootResource client = (RootResource)builder.baseUri(new URI("http://localhost/stub")).build(RootResource.class);
        SubResource subClient = client.sub();
        Assert.assertNotNull((Object)subClient, (String)"SubResource interface is null");
        Response response = subClient.getFromSub();
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response status code");
        String responseStr = (String)response.readEntity(String.class);
        Assert.assertNotNull((Object)responseStr, (String)"Response entity is null");
        Assert.assertTrue((responseStr.contains("GET ") && responseStr.contains("/root/sub") ? 1 : 0) != 0, (String)("Did not invoke expected method/URI. Expected GET .../root/sub ; got " + responseStr));
    }

    @Test
    public void exceptionMappedOnSubResourceInterface() throws Exception {
        ReturnWithURLRequestFilter filter = new ReturnWithURLRequestFilter();
        RestClientBuilder builder = (RestClientBuilder)((RestClientBuilder)RestClientBuilder.newBuilder().register((Object)filter)).register(TestResponseExceptionMapper.class);
        RootResource client = (RootResource)builder.baseUri(new URI("http://localhost/stub")).build(RootResource.class);
        SubResource subClient = client.sub();
        Assert.assertNotNull((Object)subClient, (String)"SubResource interface is null");
        try {
            Response response = subClient.getFromSub();
            Assert.fail((String)("A " + WebApplicationException.class + " should have been thrown via the registered " + TestResponseExceptionMapper.class));
        }
        catch (WebApplicationException w) {
            Assert.assertEquals((String)w.getMessage(), (String)"A 200 OK was received, but I'm throwing an exception", (String)("The message should be sourced from " + TestResponseExceptionMapper.class));
            Assert.assertTrue((boolean)TestResponseExceptionMapper.isHandlesCalled(), (String)("The handles method should have been called on " + TestResponseExceptionMapper.class));
            Assert.assertTrue((boolean)TestResponseExceptionMapper.isThrowableCalled(), (String)("The toThrowable method should have been called on " + TestResponseExceptionMapper.class));
        }
    }
}

