/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.metrics.tck.application.cdi;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.sdk.autoconfigure.spi.metrics.ConfigurableMetricExporterProvider;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import jakarta.inject.Inject;
import org.eclipse.microprofile.telemetry.metrics.tck.application.TestLibraries;
import org.eclipse.microprofile.telemetry.metrics.tck.application.exporter.InMemoryMetricExporter;
import org.eclipse.microprofile.telemetry.metrics.tck.application.exporter.InMemoryMetricExporterProvider;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LongGaugeTest
extends Arquillian {
    private static final String gaugeName = "testLongGauge";
    private static final String gaugeDescription = "Testing long gauge";
    private static final String gaugeUnit = "ms";
    @Inject
    private Meter sdkMeter;
    @Inject
    private InMemoryMetricExporter metricExporter;

    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{InMemoryMetricExporter.class, InMemoryMetricExporterProvider.class})).addAsLibrary((Archive)TestLibraries.AWAITILITY_LIB)).addAsServiceProvider(ConfigurableMetricExporterProvider.class, new Class[]{InMemoryMetricExporterProvider.class})).addAsResource((Asset)new StringAsset("otel.sdk.disabled=false\notel.metrics.exporter=in-memory\notel.logs.exporter=none\notel.traces.exporter=none\notel.metric.export.interval=3000"), "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @BeforeMethod
    void setUp() {
        if (this.metricExporter != null) {
            this.metricExporter.reset();
        }
    }

    @Test
    void testLongGauge() throws InterruptedException {
        Assert.assertNotNull((Object)this.sdkMeter.gaugeBuilder(gaugeName).ofLongs().setDescription(gaugeDescription).setUnit(gaugeUnit).buildWithCallback(measurement -> measurement.record(1L, Attributes.empty())));
        MetricData metric = this.metricExporter.getMetricData(gaugeName).get(0);
        Assert.assertEquals((Object)metric.getType(), (Object)MetricDataType.LONG_GAUGE);
        Assert.assertEquals((String)metric.getDescription(), (String)gaugeDescription);
        Assert.assertEquals((String)metric.getUnit(), (String)gaugeUnit);
        Assert.assertEquals((long)((LongPointData)metric.getLongGaugeData().getPoints().stream().findFirst().get()).getValue(), (long)1L);
    }
}

