/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck.rest;

import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.semconv.ResourceAttributes;
import io.opentelemetry.semconv.SemanticAttributes;
import jakarta.inject.Inject;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.eclipse.microprofile.telemetry.tracing.tck.BasicHttpClient;
import org.eclipse.microprofile.telemetry.tracing.tck.ConfigAsset;
import org.eclipse.microprofile.telemetry.tracing.tck.TestLibraries;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporter;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporterProvider;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RestSpanTest
extends Arquillian {
    private static final String TEST_SERVICE_NAME = "org/eclipse/microprofile/telemetry/tracing/tck";
    private static final String TEST_SERVICE_VERSION = "0.1.0-TEST";
    @ArquillianResource
    private URL url;
    @Inject
    private InMemorySpanExporter spanExporter;
    private BasicHttpClient basicClient;

    @Deployment
    public static WebArchive createDeployment() {
        ConfigAsset config = new ConfigAsset().add("otel.service.name", TEST_SERVICE_NAME).add("otel.resource.attributes", ResourceAttributes.SERVICE_VERSION.getKey() + "=0.1.0-TEST").add("otel.sdk.disabled", "false").add("otel.metrics.exporter", "none").add("otel.traces.exporter", "in-memory");
        return (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses(new Class[]{InMemorySpanExporter.class, InMemorySpanExporterProvider.class, BasicHttpClient.class})).addAsLibrary((Archive)TestLibraries.AWAITILITY_LIB)).addAsServiceProvider(ConfigurableSpanExporterProvider.class, new Class[]{InMemorySpanExporterProvider.class})).addAsResource((Asset)config, "META-INF/microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
    }

    @BeforeMethod
    void setUp() {
        if (this.spanExporter != null) {
            this.spanExporter.reset();
            this.basicClient = new BasicHttpClient(this.url);
        }
    }

    private void assertServerSpan(SpanData server, String path) {
        this.assertServerSpan(server, path, 200);
    }

    private void assertServerSpan(SpanData server, String path, int statusCode) {
        Assert.assertEquals((Object)server.getKind(), (Object)SpanKind.SERVER);
        Assert.assertEquals((int)((Long)server.getAttributes().get(SemanticAttributes.HTTP_RESPONSE_STATUS_CODE)).intValue(), (int)statusCode);
        Assert.assertEquals((String)((String)server.getAttributes().get(SemanticAttributes.HTTP_REQUEST_METHOD)), (String)"GET");
        Assert.assertEquals((String)((String)server.getAttributes().get(SemanticAttributes.URL_SCHEME)), (String)this.url.getProtocol());
        if (server.getAttributes().get(SemanticAttributes.URL_QUERY) != null) {
            Assert.assertEquals((String)((String)server.getAttributes().get(SemanticAttributes.URL_PATH) + "?" + (String)server.getAttributes().get(SemanticAttributes.URL_QUERY)), (String)(this.url.getPath() + path));
        } else {
            Assert.assertEquals((String)((String)server.getAttributes().get(SemanticAttributes.URL_PATH)), (String)(this.url.getPath() + path));
        }
        Assert.assertNotNull((Object)server.getAttributes().get(SemanticAttributes.HTTP_ROUTE));
        Assert.assertEquals((String)((String)server.getAttributes().get(SemanticAttributes.SERVER_ADDRESS)), (String)this.url.getHost());
        if (this.url.getPort() != this.url.getDefaultPort()) {
            Assert.assertEquals((int)((Long)server.getAttributes().get(SemanticAttributes.SERVER_PORT)).intValue(), (int)this.url.getPort());
        }
    }

    @Test
    void span() throws URISyntaxException, IOException {
        Assert.assertEquals((int)this.basicClient.get("/span"), (int)200);
        List<SpanData> spanItems = this.spanExporter.getFinishedSpanItems(1);
        Assert.assertEquals((int)spanItems.size(), (int)1);
        SpanData span = spanItems.get(0);
        this.assertServerSpan(span, "span");
        Assert.assertEquals((String)((String)span.getResource().getAttribute(ResourceAttributes.SERVICE_NAME)), (String)TEST_SERVICE_NAME);
        Assert.assertEquals((String)((String)span.getResource().getAttribute(ResourceAttributes.SERVICE_VERSION)), (String)TEST_SERVICE_VERSION);
        InstrumentationScopeInfo libraryInfo = span.getInstrumentationScopeInfo();
        Assert.assertNotNull((Object)libraryInfo.getName());
    }

    @Test
    void spanName() {
        Assert.assertEquals((int)this.basicClient.get("/span/1"), (int)200);
        List<SpanData> spanItems = this.spanExporter.getFinishedSpanItems(1);
        Assert.assertEquals((int)spanItems.size(), (int)1);
        SpanData span = spanItems.get(0);
        this.assertServerSpan(span, "span/1");
        Assert.assertFalse((boolean)span.getName().contains("span/1"), (String)"Span name should not contain full path when using @PathParam");
        Assert.assertTrue((boolean)((String)span.getAttributes().get(SemanticAttributes.HTTP_ROUTE)).contains("span/{name}"), (String)"Route should contain path template");
    }

    @Test
    void spanNameWithoutQueryString() {
        Assert.assertEquals((int)this.basicClient.get("/span/1?id=1"), (int)200);
        List<SpanData> spanItems = this.spanExporter.getFinishedSpanItems(1);
        Assert.assertEquals((int)spanItems.size(), (int)1);
        SpanData span = spanItems.get(0);
        this.assertServerSpan(span, "span/1?id=1");
        Assert.assertFalse((boolean)span.getName().contains("=1"), (String)"Span name should not contain query when using @QueryParam");
        Assert.assertFalse((boolean)((String)span.getAttributes().get(SemanticAttributes.HTTP_ROUTE)).contains("=1"), (String)"Route should not contain query when using @QueryParam");
    }

    @ApplicationPath(value="/")
    public static class RestApplication
    extends Application {
    }

    @Path(value="/")
    public static class SpanResource {
        @GET
        @Path(value="/span")
        public Response span() {
            return Response.ok().build();
        }

        @GET
        @Path(value="/span/{name}")
        public Response spanName(@PathParam(value="name") String name) {
            return Response.ok().build();
        }
    }
}

