/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.generator.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.FeatureCall;
import org.eclipse.mita.base.types.Enumerator;
import org.eclipse.mita.platform.AbstractSystemResource;
import org.eclipse.mita.platform.ConfigurationItem;
import org.eclipse.mita.program.ConfigurationItemValue;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.generator.CompilationContext;
import org.eclipse.mita.program.generator.IComponentConfiguration;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.xtext.xbase.lib.Procedures;

public class MapBasedComponentConfiguration
implements IComponentConfiguration {
    private final Map<String, ConfigItemValue> configurationItems;

    public MapBasedComponentConfiguration(AbstractSystemResource resource, CompilationContext context, SystemResourceSetup setup) {
        String _name;
        HashMap<String, ConfigItemValue> _hashMap = new HashMap<String, ConfigItemValue>();
        this.configurationItems = _hashMap;
        EList _configurationItems = resource.getConfigurationItems();
        for (ConfigurationItem configItem : _configurationItems) {
            Expression defaultValue = configItem.getDefaultValue();
            if (defaultValue == null) continue;
            _name = configItem.getName();
            ConfigItemValue _configItemValue = new ConfigItemValue(defaultValue, true);
            this.configurationItems.put(_name, _configItemValue);
        }
        if (setup != null) {
            EList<ConfigurationItemValue> _configurationItemValues = setup.getConfigurationItemValues();
            for (ConfigurationItemValue value : _configurationItemValues) {
                _name = value.getItem().getName();
                Expression _value = value.getValue();
                ConfigItemValue _configItemValue = new ConfigItemValue(_value, false);
                this.configurationItems.put(_name, _configItemValue);
            }
        }
    }

    @Override
    public boolean exists(String key) {
        return this.configurationItems.containsKey(key);
    }

    @Override
    public Boolean getBoolean(String key) {
        Object expr;
        Expression _expression = this.getExpression(key);
        Object _reduce = null;
        if (_expression != null) {
            _reduce = MapBasedComponentConfiguration.reduce(_expression);
        }
        if ((expr = _reduce) instanceof Boolean) {
            return (Boolean)expr;
        }
        return null;
    }

    @Override
    public Enumerator getEnumerator(String key) {
        Object expr;
        Expression _expression = this.getExpression(key);
        Object _reduce = null;
        if (_expression != null) {
            _reduce = MapBasedComponentConfiguration.reduce(_expression);
        }
        if ((expr = _reduce) instanceof Enumerator) {
            return (Enumerator)expr;
        }
        return null;
    }

    @Override
    public Integer getInteger(String key) {
        Object expr;
        Expression _expression = this.getExpression(key);
        Object _reduce = null;
        if (_expression != null) {
            _reduce = MapBasedComponentConfiguration.reduce(_expression);
        }
        if ((expr = _reduce) instanceof Integer) {
            return (Integer)expr;
        }
        return null;
    }

    @Override
    public Iterable<String> getKeys() {
        return this.configurationItems.keySet();
    }

    @Override
    public String getString(String key) {
        Object expr;
        Expression _expression = this.getExpression(key);
        Object _reduce = null;
        if (_expression != null) {
            _reduce = MapBasedComponentConfiguration.reduce(_expression);
        }
        if ((expr = _reduce) instanceof String) {
            return (String)expr;
        }
        return null;
    }

    @Override
    public boolean isDefault(String key) throws NoSuchElementException {
        return this.configurationItems.get((Object)key).isDefault;
    }

    @Override
    public Expression getExpression(String key) {
        ConfigItemValue _orDefault = this.configurationItems.getOrDefault(key, null);
        Expression _value = null;
        if (_orDefault != null) {
            _value = _orDefault.value;
        }
        return _value;
    }

    protected static Object reduce(Expression expression) {
        EObject _xifexpression = null;
        if (expression instanceof FeatureCall) {
            _xifexpression = ((FeatureCall)expression).getFeature();
        } else {
            EObject _xifexpression_1 = null;
            if (expression instanceof ElementReferenceExpression) {
                _xifexpression_1 = ((ElementReferenceExpression)expression).getReference();
            } else {
                Object _xifexpression_2 = null;
                if (expression != null) {
                    Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

                        public void apply(EObject x) {
                        }
                    };
                    _xifexpression_2 = StaticValueInferrer.infer((EObject)expression, (Procedures.Procedure1<? super EObject>)_function);
                } else {
                    _xifexpression_2 = null;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    private static class ConfigItemValue {
        public final Expression value;
        public final boolean isDefault;

        public ConfigItemValue(Expression value, boolean isDefault) {
            this.value = value;
            this.isDefault = isDefault;
        }
    }
}

