/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.inferrer;

import com.google.common.base.Objects;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mita.base.expressions.Argument;
import org.eclipse.mita.base.expressions.ArgumentExpression;
import org.eclipse.mita.base.expressions.AssignmentExpression;
import org.eclipse.mita.base.expressions.BoolLiteral;
import org.eclipse.mita.base.expressions.DoubleLiteral;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.FeatureCall;
import org.eclipse.mita.base.expressions.FloatLiteral;
import org.eclipse.mita.base.expressions.IntLiteral;
import org.eclipse.mita.base.expressions.inferrer.ExpressionsTypeInferrer;
import org.eclipse.mita.base.types.AnonymousProductType;
import org.eclipse.mita.base.types.HasAccessors;
import org.eclipse.mita.base.types.Operation;
import org.eclipse.mita.base.types.Parameter;
import org.eclipse.mita.base.types.Property;
import org.eclipse.mita.base.types.StructureType;
import org.eclipse.mita.base.types.SumAlternative;
import org.eclipse.mita.base.types.SumType;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypeParameter;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.base.types.validation.IValidationIssueAcceptor;
import org.eclipse.mita.platform.Modality;
import org.eclipse.mita.platform.SystemResourceAlias;
import org.eclipse.mita.program.ArrayAccessExpression;
import org.eclipse.mita.program.ArrayLiteral;
import org.eclipse.mita.program.DereferenceExpression;
import org.eclipse.mita.program.ForEachLoopIteratorVariableDeclaration;
import org.eclipse.mita.program.ForEachStatement;
import org.eclipse.mita.program.FunctionDefinition;
import org.eclipse.mita.program.GeneratedFunctionDefinition;
import org.eclipse.mita.program.InterpolatedStringExpression;
import org.eclipse.mita.program.IsDeconstructionCase;
import org.eclipse.mita.program.IsDeconstructor;
import org.eclipse.mita.program.ModalityAccess;
import org.eclipse.mita.program.NewInstanceExpression;
import org.eclipse.mita.program.ProgramBlock;
import org.eclipse.mita.program.ReferenceExpression;
import org.eclipse.mita.program.ReturnStatement;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.ValueRange;
import org.eclipse.mita.program.VariableDeclaration;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.mita.program.scoping.ExtensionMethodHelper;
import org.eclipse.mita.program.validation.ProgramDslTypeValidator;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class ProgramDslTypeInferrer
extends ExpressionsTypeInferrer {
    public static final String VARIABLE_DECLARATION = "Cannot assign a value of type %s to a variable of type %s.";
    public static final String NO_RETURN_TYPE_INFERRED = "Could not infer common return type from operation's return statements";
    public static final String DEREFERENCE_OF_NON_REFERENCE_MSG = "Can not dereference non-reference types.";
    public static final String DEREFERENCE_OF_NON_REFERENCE_CODE = "DEREFERENCE_OF_NON_REFERENCE_CODE";
    public static final String INTEGER_VALUE_OUT_OF_RANGE_MSG = "Value is out of range. Must be %d <= x <= %d.";
    public static final String INTEGER_VALUE_OUT_OF_RANGE_CODE = "value_out_of_range";
    public static final String INT_LITERAL_TYPE = "int32";
    public static final String DOUBLE_LITERAL_TYPE = "double";
    public static final String FLOAT_LITERAL_TYPE = "float";
    public static final String BOOL_LITERAL_TYPE = "bool";
    public static final String ARRAY_LITERAL_TYPE = "array";
    @Inject
    @Extension
    private ExtensionMethodHelper _extensionMethodHelper;
    @Inject
    @Extension
    private ProgramDslTypeValidator programDslTypeValidator;

    protected ITypeSystemInferrer.InferenceResult inferTypeDispatch(EObject object) {
        ITypeSystemInferrer.InferenceResult result = super.inferTypeDispatch(object);
        if (result != null && result.getType().isAbstract()) {
            Type _type_2;
            ITypeSystemInferrer.InferenceResult _switchResult = null;
            Type _type = result.getType();
            boolean _matched = false;
            Type _type_1 = this.registry.getType("real");
            if (Objects.equal((Object)_type, (Object)_type_1)) {
                _matched = true;
                return ITypeSystemInferrer.InferenceResult.from((Type)this.registry.getType(DOUBLE_LITERAL_TYPE));
            }
            if (!_matched && Objects.equal((Object)_type, (Object)(_type_2 = this.registry.getType("boolean")))) {
                _matched = true;
                return ITypeSystemInferrer.InferenceResult.from((Type)this.registry.getType(BOOL_LITERAL_TYPE));
            }
            if (!_matched) {
                _switchResult = result;
            }
            return _switchResult;
        }
        return result;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(DoubleLiteral literal) {
        return ITypeSystemInferrer.InferenceResult.from((Type)this.registry.getType(DOUBLE_LITERAL_TYPE));
    }

    public ITypeSystemInferrer.InferenceResult doInfer(IntLiteral literal) {
        return ITypeSystemInferrer.InferenceResult.from((Type)this.registry.getType("integer"));
    }

    public ITypeSystemInferrer.InferenceResult doInfer(FloatLiteral literal) {
        return ITypeSystemInferrer.InferenceResult.from((Type)this.registry.getType(FLOAT_LITERAL_TYPE));
    }

    public ITypeSystemInferrer.InferenceResult doInfer(BoolLiteral literal) {
        return ITypeSystemInferrer.InferenceResult.from((Type)this.registry.getType(BOOL_LITERAL_TYPE));
    }

    public ITypeSystemInferrer.InferenceResult doInfer(ArrayLiteral literal) {
        ITypeSystemInferrer.InferenceResult outer = ITypeSystemInferrer.InferenceResult.from((Type)this.registry.getType(ARRAY_LITERAL_TYPE));
        ITypeSystemInferrer.InferenceResult inner = this.inferTypeDispatch((EObject)IterableExtensions.head(literal.getValues()));
        List _bindings = outer.getBindings();
        _bindings.add(inner);
        return outer;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(DereferenceExpression e) {
        ITypeSystemInferrer.InferenceResult refType = this.inferTypeDispatch((EObject)e.getExpression());
        if (refType != null && ((Object[])Conversions.unwrapArray((Object)refType.getBindings(), Object.class)).length > 0) {
            return (ITypeSystemInferrer.InferenceResult)IterableExtensions.head((Iterable)refType.getBindings());
        }
        IValidationIssueAcceptor.ValidationIssue _validationIssue = new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR, DEREFERENCE_OF_NON_REFERENCE_MSG, (EObject)e, null, DEREFERENCE_OF_NON_REFERENCE_CODE);
        this.acceptor.accept(_validationIssue);
        return null;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(ReferenceExpression e) {
        ITypeSystemInferrer.InferenceResult innerType = this.inferTypeDispatch((EObject)e.getVariable());
        ITypeSystemInferrer.InferenceResult outerType = this.getResultFor("reference");
        outerType.getBindings().add(innerType);
        return outerType;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(SignalInstance e) {
        TypeSpecifier _typeSpecifier = e.getTypeSpecifier();
        ITypeSystemInferrer.InferenceResult _inferTypeDispatch = null;
        if (_typeSpecifier != null) {
            _inferTypeDispatch = this.inferTypeDispatch((EObject)_typeSpecifier);
        }
        ITypeSystemInferrer.InferenceResult explicitType = _inferTypeDispatch;
        ITypeSystemInferrer.InferenceResult originalItemType = this.inferTypeDispatch((EObject)e.getInstanceOf());
        ITypeSystemInferrer.InferenceResult _xifexpression = null;
        if (explicitType != null) {
            ITypeSystemInferrer.InferenceResult _xblockexpression = null;
            this.assertAssignable(explicitType, originalItemType, String.format(VARIABLE_DECLARATION, explicitType, originalItemType));
            _xifexpression = _xblockexpression = explicitType;
        } else {
            _xifexpression = originalItemType;
        }
        ITypeSystemInferrer.InferenceResult typeSpec = _xifexpression;
        ITypeSystemInferrer.InferenceResult siginstType = this.getResultFor("siginst");
        siginstType.getBindings().add(typeSpec);
        return siginstType;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(NewInstanceExpression e) {
        return this.inferTypeDispatch((EObject)e.getType());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(Modality e) {
        ITypeSystemInferrer.InferenceResult result = this.getResultFor("modality");
        result.getBindings().add(this.inferTypeDispatch((EObject)e.getTypeSpecifier()));
        return result;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(ModalityAccess e) {
        Modality _modality = null;
        if (e != null) {
            _modality = e.getModality();
        }
        TypeSpecifier _typeSpecifier = null;
        if (_modality != null) {
            _typeSpecifier = _modality.getTypeSpecifier();
        }
        ITypeSystemInferrer.InferenceResult _inferTypeDispatch = null;
        if (_typeSpecifier != null) {
            _inferTypeDispatch = this.inferTypeDispatch((EObject)_typeSpecifier);
        }
        return _inferTypeDispatch;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(AnonymousProductType typ) {
        boolean _equals;
        int _length = ((Object[])Conversions.unwrapArray((Object)typ.getTypeSpecifiers(), Object.class)).length;
        boolean bl = _equals = _length == 1;
        if (_equals) {
            return this.inferTypeDispatch((EObject)IterableExtensions.head((Iterable)typ.getTypeSpecifiers()));
        }
        return super.doInfer((Type)typ);
    }

    public ITypeSystemInferrer.InferenceResult doInfer(IsDeconstructor deconstructor) {
        ITypeSystemInferrer.InferenceResult result = this.inferTypeDispatch((EObject)deconstructor.getProductMember());
        if (result == null) {
            EObject _eContainer = deconstructor.eContainer();
            IsDeconstructionCase isCase = (IsDeconstructionCase)_eContainer;
            Type rType = isCase.getProductType().realType();
            Object _xifexpression = null;
            _xifexpression = rType instanceof HasAccessors ? ((HasAccessors)rType).accessorsTypes() : Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Type[]{rType}));
            EList types = _xifexpression;
            int idx = isCase.getDeconstructors().indexOf((Object)deconstructor);
            result = this.inferTypeDispatch((EObject)types.get(idx));
        }
        return result;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(VariableDeclaration e) {
        boolean _tripleEquals;
        ITypeSystemInferrer.InferenceResult explicitType = this.inferTypeDispatch((EObject)e.getTypeSpecifier());
        Expression _initialization = e.getInitialization();
        boolean bl = _tripleEquals = _initialization == null;
        if (_tripleEquals) {
            return explicitType;
        }
        ITypeSystemInferrer.InferenceResult implicitType = this.inferTypeDispatch((EObject)e.getInitialization());
        if (explicitType != null) {
            this.assertAssignable(explicitType, implicitType, String.format(VARIABLE_DECLARATION, implicitType, explicitType));
            this.assertWithinRange(explicitType, e.getInitialization(), e);
            return explicitType;
        }
        return this.replace(implicitType, e);
    }

    public ITypeSystemInferrer.InferenceResult replace(ITypeSystemInferrer.InferenceResult result, VariableDeclaration object) {
        boolean _isSame;
        Type _type = null;
        if (result != null) {
            _type = result.getType();
        }
        if (_isSame = this.registry.isSame(_type, this.registry.getType("integer"))) {
            return this.doInferIntegerByUse(object, result);
        }
        if (result != null && !result.getBindings().isEmpty()) {
            Functions.Function1<ITypeSystemInferrer.InferenceResult, ITypeSystemInferrer.InferenceResult> _function = new Functions.Function1<ITypeSystemInferrer.InferenceResult, ITypeSystemInferrer.InferenceResult>(){

                public ITypeSystemInferrer.InferenceResult apply(ITypeSystemInferrer.InferenceResult it) {
                    return ProgramDslTypeInferrer.this.replace(it, null);
                }
            };
            return ITypeSystemInferrer.InferenceResult.from((Type)result.getType(), (List)ListExtensions.map((List)result.getBindings(), (Functions.Function1)_function));
        }
        return result;
    }

    protected ITypeSystemInferrer.InferenceResult doInferIntegerByUse(VariableDeclaration declaration, ITypeSystemInferrer.InferenceResult original) {
        ITypeSystemInferrer.InferenceResult _xblockexpression = null;
        if (declaration != null) {
            ITypeSystemInferrer.InferenceResult firstUsage;
            EStructuralFeature.Setting _head = (EStructuralFeature.Setting)IterableExtensions.head((Iterable)EcoreUtil.UsageCrossReferencer.find((EObject)declaration, (Resource)declaration.eResource()));
            EObject _eObject = null;
            if (_head != null) {
                _eObject = _head.getEObject();
            }
            ITypeSystemInferrer.InferenceResult _inferByUsage = null;
            if (_eObject != null) {
                _inferByUsage = this.inferByUsage(_eObject);
            }
            if ((firstUsage = _inferByUsage) != null) {
                IValidationIssueAcceptor.ListBasedValidationIssueAcceptor issueAcceptor = new IValidationIssueAcceptor.ListBasedValidationIssueAcceptor();
                this.programDslTypeValidator.assertAssignable(firstUsage, original, "", (IValidationIssueAcceptor)issueAcceptor);
                boolean _isEmpty = issueAcceptor.getTraces().isEmpty();
                if (_isEmpty) {
                    return firstUsage;
                }
            }
        }
        _xblockexpression = ITypeSystemInferrer.InferenceResult.from((Type)this.registry.getType(INT_LITERAL_TYPE));
        return _xblockexpression;
    }

    protected ITypeSystemInferrer.InferenceResult _inferByUsage(EObject reference) {
        return ITypeSystemInferrer.InferenceResult.from((Type)this.registry.getType(INT_LITERAL_TYPE));
    }

    protected ITypeSystemInferrer.InferenceResult _inferByUsage(ElementReferenceExpression reference) {
        Argument argument = (Argument)EcoreUtil2.getContainerOfType((EObject)reference, Argument.class);
        if (argument != null) {
            return this.inferByUsage(argument, reference);
        }
        Property typedElement = (Property)EcoreUtil2.getContainerOfType((EObject)reference, Property.class);
        if (typedElement != null) {
            return this.inferTypeDispatch((EObject)typedElement);
        }
        return null;
    }

    protected ITypeSystemInferrer.InferenceResult inferByUsage(Argument argument, ElementReferenceExpression use) {
        boolean _tripleNotEquals;
        ITypeSystemInferrer.InferenceResult _xifexpression = null;
        Parameter _parameter = argument.getParameter();
        boolean bl = _tripleNotEquals = _parameter != null;
        if (_tripleNotEquals) {
            _xifexpression = this.inferTypeDispatch((EObject)argument.getParameter().getType());
        } else {
            ITypeSystemInferrer.InferenceResult _xifexpression_1 = null;
            EObject _eContainer = argument.eContainer();
            if (_eContainer instanceof ArgumentExpression) {
                int index;
                ITypeSystemInferrer.InferenceResult _xblockexpression = null;
                EObject _eContainer_1 = argument.eContainer();
                ArgumentExpression argumentExpression = (ArgumentExpression)_eContainer_1;
                Operation op = this.operation(argumentExpression);
                int _index = index = argumentExpression.getArguments().indexOf((Object)argument);
                int _size = op.getParameters().size();
                int _size_1 = argumentExpression.getArguments().size();
                int _minus = _size - _size_1;
                index = _index + _minus;
                _xifexpression_1 = _xblockexpression = this.inferTypeDispatch((EObject)((Parameter)op.getParameters().get(index)).getType());
            } else {
                _xifexpression_1 = this.inferTypeDispatch((EObject)this.registry.getType(INT_LITERAL_TYPE));
            }
            _xifexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    protected Operation _operation(ArgumentExpression it) {
        return null;
    }

    protected Operation _operation(ElementReferenceExpression it) {
        EObject _reference = it.getReference();
        return (Operation)_reference;
    }

    protected Operation _operation(FeatureCall it) {
        EObject _feature = it.getFeature();
        return (Operation)_feature;
    }

    protected ITypeSystemInferrer.InferenceResult inferOperation(ArgumentExpression e, Operation op, Map<TypeParameter, ITypeSystemInferrer.InferenceResult> typeParameterMapping) {
        ITypeSystemInferrer.InferenceResult ownerType;
        boolean _isExtensionMethodOn;
        Comparator<TypeParameter> _function = new Comparator<TypeParameter>(){

            @Override
            public int compare(TypeParameter x, TypeParameter y) {
                return x.getName().compareTo(y.getName());
            }
        };
        TreeMap<TypeParameter, ITypeSystemInferrer.InferenceResult> typeParameterMapping2 = new TreeMap<TypeParameter, ITypeSystemInferrer.InferenceResult>(_function);
        typeParameterMapping2.putAll(typeParameterMapping);
        if (op instanceof GeneratedFunctionDefinition && op.getParameters().isEmpty()) {
            ReturnStatement retStmt;
            EObject parentDecl = EcoreUtil2.getContainerOfType((EObject)e, VariableDeclaration.class);
            if (parentDecl == null && (retStmt = (ReturnStatement)EcoreUtil2.getContainerOfType((EObject)e, ReturnStatement.class)) != null) {
                parentDecl = EcoreUtil2.getContainerOfType((EObject)retStmt, FunctionDefinition.class);
            }
            if (parentDecl == null) {
                AssignmentExpression assignmentExpr = (AssignmentExpression)EcoreUtil2.getContainerOfType((EObject)e, AssignmentExpression.class);
                Expression _varRef = null;
                if (assignmentExpr != null) {
                    _varRef = assignmentExpr.getVarRef();
                }
                Expression varRef = _varRef;
                while (varRef instanceof ArrayAccessExpression) {
                    varRef = ((ArrayAccessExpression)varRef).getOwner();
                }
                while (varRef instanceof FeatureCall) {
                    varRef = ((FeatureCall)varRef).getOwner();
                }
                if (varRef instanceof ElementReferenceExpression) {
                    parentDecl = ((ElementReferenceExpression)varRef).getReference();
                }
            }
            TypeSpecifier _xifexpression = null;
            if (parentDecl instanceof VariableDeclaration) {
                TypeSpecifier _xifexpression_1 = null;
                if (parentDecl != null && ((VariableDeclaration)parentDecl).getTypeSpecifier() != null) {
                    _xifexpression_1 = ((VariableDeclaration)parentDecl).getTypeSpecifier();
                }
                _xifexpression = _xifexpression_1;
            } else {
                TypeSpecifier _xifexpression_2 = null;
                if (parentDecl instanceof FunctionDefinition) {
                    _xifexpression_2 = ModelUtils.toSpecifier(this.inferTypeDispatch(parentDecl));
                }
                _xifexpression = _xifexpression_2;
            }
            final TypeSpecifier parentTypeSpec = _xifexpression;
            if (parentTypeSpec != null && Objects.equal((Object)parentTypeSpec.getType().getName(), (Object)op.getType().getName())) {
                final TreeMap<TypeParameter, ITypeSystemInferrer.InferenceResult> finalMap = typeParameterMapping2;
                Consumer<Pair<Integer, TypeParameter>> _function_1 = new Consumer<Pair<Integer, TypeParameter>>(){

                    @Override
                    public void accept(Pair<Integer, TypeParameter> idx_tp) {
                        finalMap.put((TypeParameter)idx_tp.getValue(), ProgramDslTypeInferrer.this.inferTypeDispatch((EObject)parentTypeSpec.getTypeArguments().get(((Integer)idx_tp.getKey()).intValue())));
                    }
                };
                IterableExtensions.indexed((Iterable)op.getTypeParameters()).forEach(_function_1);
            }
        }
        if (e instanceof FeatureCall && (_isExtensionMethodOn = this._extensionMethodHelper.isExtensionMethodOn(op, (ownerType = this.inferTypeDispatch((EObject)((FeatureCall)e).getOwner())).getType()))) {
            return super.inferOperation(e, op, this.adjustForExtensionMethod(typeParameterMapping2, op));
        }
        return super.inferOperation(e, op, typeParameterMapping2);
    }

    public Map<TypeParameter, ITypeSystemInferrer.InferenceResult> validateParameters(Map<TypeParameter, ITypeSystemInferrer.InferenceResult> typeParameterMapping, Operation operation, List<Expression> args, IValidationIssueAcceptor acceptor) {
        Map _xblockexpression = null;
        EList parameters = operation.getParameters();
        int parameter = 0;
        while (parameter < parameters.size()) {
            boolean _greaterThan;
            int _size = args.size();
            boolean bl = _greaterThan = _size > parameter;
            if (_greaterThan) {
                Parameter varArgs = (Parameter)parameters.get(parameter);
                ITypeSystemInferrer.InferenceResult argType = this.inferTypeDispatch((EObject)varArgs);
                Expression parameterValue = args.get(parameter);
                this.assertWithinRange(argType, parameterValue, (EObject)parameterValue);
            }
            ++parameter;
        }
        _xblockexpression = super.validateParameters(typeParameterMapping, operation, args, acceptor);
        return _xblockexpression;
    }

    protected void assertWithinRange(ITypeSystemInferrer.InferenceResult result, Expression expression, EObject target) {
        List range;
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        };
        Object staticValue = StaticValueInferrer.infer((EObject)expression, (Procedures.Procedure1<? super EObject>)_function);
        if (!(staticValue instanceof Integer)) {
            return;
        }
        Integer staticIntValue = (Integer)staticValue;
        Long _long = new Long(0L);
        Long _long_1 = new Long(255L);
        Pair _mappedTo = Pair.of((Object)"uint8", Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Long[]{_long, _long_1})));
        Long _long_2 = new Long(-128L);
        Long _long_3 = new Long(127L);
        Pair _mappedTo_1 = Pair.of((Object)"int8", Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Long[]{_long_2, _long_3})));
        Long _long_4 = new Long(0L);
        Long _long_5 = new Long(65535L);
        Pair _mappedTo_2 = Pair.of((Object)"uint16", Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Long[]{_long_4, _long_5})));
        Long _long_6 = new Long(-32768L);
        Long _long_7 = new Long(32767L);
        Pair _mappedTo_3 = Pair.of((Object)"int16", Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Long[]{_long_6, _long_7})));
        Long _long_8 = new Long(0L);
        Long _long_9 = new Long("4294967295");
        Pair _mappedTo_4 = Pair.of((Object)"uint32", Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Long[]{_long_8, _long_9})));
        Long _long_10 = new Long("-2147483648");
        Long _long_11 = new Long("2147483647");
        Pair _mappedTo_5 = Pair.of((Object)INT_LITERAL_TYPE, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Long[]{_long_10, _long_11})));
        Map ranges = Collections.unmodifiableMap(CollectionLiterals.newHashMap((Pair[])new Pair[]{_mappedTo, _mappedTo_1, _mappedTo_2, _mappedTo_3, _mappedTo_4, _mappedTo_5}));
        Type _type = null;
        if (result != null) {
            _type = result.getType();
        }
        Type type = _type;
        String _name = null;
        if (type != null) {
            _name = type.getName();
        }
        if ((range = (List)ranges.getOrDefault(_name, null)) != null && ((long)staticIntValue.intValue() < (Long)range.get(0) || (long)staticIntValue.intValue() > (Long)range.get(1))) {
            String errorMessage = String.format(INTEGER_VALUE_OUT_OF_RANGE_MSG, range.get(0), range.get(1));
            IValidationIssueAcceptor.ValidationIssue _validationIssue = new IValidationIssueAcceptor.ValidationIssue(IValidationIssueAcceptor.ValidationIssue.Severity.ERROR, errorMessage, target, null, INTEGER_VALUE_OUT_OF_RANGE_CODE);
            this.acceptor.accept(_validationIssue);
        }
    }

    public ITypeSystemInferrer.InferenceResult doInfer(ForEachLoopIteratorVariableDeclaration e) {
        EObject _eContainer = e.eContainer();
        Expression _iterable = null;
        if ((ForEachStatement)_eContainer != null) {
            _iterable = ((ForEachStatement)_eContainer).getIterable();
        }
        Expression iterableExpr = _iterable;
        ITypeSystemInferrer.InferenceResult iterableType = this.inferTypeDispatch((EObject)iterableExpr);
        this.assertIsSubType(iterableType, ITypeSystemInferrer.InferenceResult.from((Type)this.registry.getType("iterable")), null);
        ITypeSystemInferrer.InferenceResult elementType = (ITypeSystemInferrer.InferenceResult)IterableExtensions.head((Iterable)iterableType.getBindings());
        return elementType;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(InterpolatedStringExpression e) {
        return this.getResultFor("string");
    }

    public ITypeSystemInferrer.InferenceResult doInfer(SystemResourceAlias e) {
        return ITypeSystemInferrer.InferenceResult.from((Type)e.getDelegate());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(FeatureCall fc) {
        EObject _feature = fc.getFeature();
        if (_feature instanceof SumAlternative) {
            EObject ref;
            Expression owner = fc.getOwner();
            if (owner instanceof ElementReferenceExpression && (ref = ((ElementReferenceExpression)owner).getReference()) instanceof SumType) {
                return ITypeSystemInferrer.InferenceResult.from((Type)((Type)ref));
            }
        } else {
            return super.doInfer(fc);
        }
        return null;
    }

    public ITypeSystemInferrer.InferenceResult doInfer(SystemResourceSetup e) {
        return this.inferTypeDispatch((EObject)e.getType());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(ReturnStatement returnStatement) {
        return this.inferTypeDispatch((EObject)returnStatement.getValue());
    }

    public List<Expression> getOperationArguments(ArgumentExpression e) {
        if (e instanceof FeatureCall) {
            boolean _tripleNotEquals;
            EObject _feature = ((FeatureCall)e).getFeature();
            Operation operation = (Operation)_feature;
            boolean _and = false;
            Expression _owner = ((FeatureCall)e).getOwner();
            boolean bl = _tripleNotEquals = _owner != null;
            if (!_tripleNotEquals) {
                _and = false;
            } else {
                boolean _isExtensionMethodOn;
                ITypeSystemInferrer.InferenceResult _inferTypeDispatch = this.inferTypeDispatch((EObject)((FeatureCall)e).getOwner());
                Type _type = null;
                if (_inferTypeDispatch != null) {
                    _type = _inferTypeDispatch.getType();
                }
                _and = _isExtensionMethodOn = this._extensionMethodHelper.isExtensionMethodOn(operation, _type);
            }
            if (_and) {
                return this._extensionMethodHelper.combine(((FeatureCall)e).getOwner(), (List<Expression>)((FeatureCall)e).getExpressions());
            }
        }
        return e.getExpressions();
    }

    public ITypeSystemInferrer.InferenceResult doInfer(FunctionDefinition operation) {
        boolean _tripleEquals;
        TypeSpecifier _typeSpecifier = operation.getTypeSpecifier();
        boolean bl = _tripleEquals = _typeSpecifier == null;
        if (_tripleEquals) {
            return this.inferTypeFromReturnStatements(operation.getBody());
        }
        return this.doInfer(operation.getTypeSpecifier());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(ArrayAccessExpression e) {
        Expression _arraySelector = e.getArraySelector();
        if (_arraySelector instanceof ValueRange) {
            return this.inferTypeDispatch((EObject)e.getOwner());
        }
        return (ITypeSystemInferrer.InferenceResult)IterableExtensions.head((Iterable)this.inferTypeDispatch((EObject)e.getOwner()).getBindings());
    }

    public ITypeSystemInferrer.InferenceResult doInfer(ElementReferenceExpression e) {
        boolean _isOperationCall = e.isOperationCall();
        if (_isOperationCall) {
            EObject ref = e.getReference();
            if (ref instanceof StructureType) {
                return ITypeSystemInferrer.InferenceResult.from((Type)((Type)ref));
            }
            if (ref instanceof SumAlternative) {
                EObject _eContainer = ((SumAlternative)ref).eContainer();
                return ITypeSystemInferrer.InferenceResult.from((Type)((SumType)_eContainer));
            }
            return super.doInfer(e);
        }
        return super.doInfer(e);
    }

    protected ITypeSystemInferrer.InferenceResult inferTypeFromReturnStatements(ProgramBlock body) {
        boolean _isEmpty = body.getContent().isEmpty();
        if (_isEmpty) {
            return this.getResultFor("void");
        }
        List returnStatements = EcoreUtil2.getAllContentsOfType((EObject)body, ReturnStatement.class);
        boolean _isEmpty_1 = returnStatements.isEmpty();
        if (_isEmpty_1) {
            return this.getResultFor("void");
        }
        ITypeSystemInferrer.InferenceResult returnType = this.doInfer((ReturnStatement)IterableExtensions.head((Iterable)returnStatements));
        int i = 1;
        while (i < returnStatements.size()) {
            ITypeSystemInferrer.InferenceResult next = this.doInfer((ReturnStatement)returnStatements.get(i));
            if ((returnType = this.getCommonReturnType(returnType, next)) == null) {
                return this.getResultFor("void");
            }
            ++i;
        }
        if (returnType != null && Objects.equal((Object)returnType.getType(), (Object)this.registry.getType("integer"))) {
            return ITypeSystemInferrer.InferenceResult.from((Type)this.registry.getType(INT_LITERAL_TYPE));
        }
        return returnType;
    }

    protected ITypeSystemInferrer.InferenceResult getCommonReturnType(ITypeSystemInferrer.InferenceResult left, ITypeSystemInferrer.InferenceResult right) {
        this.assertCompatible(left, right, NO_RETURN_TYPE_INFERRED);
        Type commonType = this.registry.getCommonType(left.getType(), right.getType());
        if (commonType == null) {
            return null;
        }
        return ITypeSystemInferrer.InferenceResult.from((Type)commonType, (List)left.getBindings());
    }

    public HashMap<TypeParameter, ITypeSystemInferrer.InferenceResult> adjustForExtensionMethod(Map<TypeParameter, ITypeSystemInferrer.InferenceResult> inferredTypeParameters, Operation operation) {
        Parameter p = (Parameter)IterableExtensions.head((Iterable)operation.getParameters());
        ITypeSystemInferrer.InferenceResult pType = this.inferTypeDispatch((EObject)p);
        final HashMap callerTypeParamToOperationTypeParam = Maps.newHashMap();
        this.typeParameterInferrer.inferTypeParametersFromOwner(pType, (Map)callerTypeParamToOperationTypeParam);
        final HashMap adjustedTypeParameterMapping = Maps.newHashMap();
        BiConsumer<TypeParameter, ITypeSystemInferrer.InferenceResult> _function = new BiConsumer<TypeParameter, ITypeSystemInferrer.InferenceResult>(){

            @Override
            public void accept(TypeParameter tp, ITypeSystemInferrer.InferenceResult t) {
                ITypeSystemInferrer.InferenceResult _get = (ITypeSystemInferrer.InferenceResult)callerTypeParamToOperationTypeParam.get(tp);
                Type _type = null;
                if (_get != null) {
                    _type = _get.getType();
                }
                if (_type instanceof TypeParameter) {
                    Type _type_1 = ((ITypeSystemInferrer.InferenceResult)callerTypeParamToOperationTypeParam.get(tp)).getType();
                    adjustedTypeParameterMapping.put((TypeParameter)_type_1, t);
                } else {
                    adjustedTypeParameterMapping.put(tp, t);
                }
            }
        };
        inferredTypeParameters.forEach(_function);
        return adjustedTypeParameterMapping;
    }

    protected ITypeSystemInferrer.InferenceResult inferByUsage(EObject reference) {
        if (reference instanceof ElementReferenceExpression) {
            return this._inferByUsage((ElementReferenceExpression)reference);
        }
        if (reference != null) {
            return this._inferByUsage(reference);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(reference).toString());
    }

    public Operation operation(ArgumentExpression it) {
        if (it instanceof ElementReferenceExpression) {
            return this._operation((ElementReferenceExpression)it);
        }
        if (it instanceof FeatureCall) {
            return this._operation((FeatureCall)it);
        }
        if (it != null) {
            return this._operation(it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

