/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.inferrer;

import com.google.inject.Inject;
import java.util.Map;
import org.eclipse.mita.base.expressions.inferrer.TypeParameterInferrer;
import org.eclipse.mita.base.types.Type;
import org.eclipse.mita.base.types.TypeParameter;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.base.types.inferrer.ITypeSystemInferrer;
import org.eclipse.mita.base.types.validation.IValidationIssueAcceptor;
import org.eclipse.mita.program.inferrer.OptionalTypeExtensions;
import org.eclipse.xtext.xbase.lib.Extension;

public class ProgramDslTypeParameterInferrer
extends TypeParameterInferrer {
    @Inject
    @Extension
    private OptionalTypeExtensions _optionalTypeExtensions;

    public void assertArgumentAndParameterSoftCompatible(ITypeSystemInferrer.InferenceResult argumentResult, TypeSpecifier parameter, IValidationIssueAcceptor acceptor) {
        if (this._optionalTypeExtensions.isOptional(parameter.getType()) || this._optionalTypeExtensions.isOptional(argumentResult.getType())) {
            return;
        }
        super.assertArgumentAndParameterSoftCompatible(argumentResult, parameter, acceptor);
    }

    public boolean parameterContainsTypeParameter(TypeSpecifier specifier) {
        return super.parameterContainsTypeParameter(this._optionalTypeExtensions.getOptionalBaseType(specifier));
    }

    public void inferTypeParametersFromOwner(ITypeSystemInferrer.InferenceResult operationOwnerResult, Map<TypeParameter, ITypeSystemInferrer.InferenceResult> inferredTypeParameterTypes) {
        boolean _tripleEquals;
        Type _type = null;
        if (operationOwnerResult != null) {
            _type = operationOwnerResult.getType();
        }
        boolean bl = _tripleEquals = _type == null;
        if (_tripleEquals) {
            return;
        }
        super.inferTypeParametersFromOwner(operationOwnerResult, inferredTypeParameterTypes);
    }
}

