/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.inferrer;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.expressions.Argument;
import org.eclipse.mita.base.expressions.BoolLiteral;
import org.eclipse.mita.base.expressions.DoubleLiteral;
import org.eclipse.mita.base.expressions.ElementReferenceExpression;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.base.expressions.FeatureCall;
import org.eclipse.mita.base.expressions.FloatLiteral;
import org.eclipse.mita.base.expressions.IntLiteral;
import org.eclipse.mita.base.expressions.Literal;
import org.eclipse.mita.base.expressions.NumericalUnaryExpression;
import org.eclipse.mita.base.expressions.PrimitiveValueExpression;
import org.eclipse.mita.base.expressions.StringLiteral;
import org.eclipse.mita.base.expressions.UnaryOperator;
import org.eclipse.mita.base.types.AnonymousProductType;
import org.eclipse.mita.base.types.Enumerator;
import org.eclipse.mita.base.types.NamedProductType;
import org.eclipse.mita.base.types.Parameter;
import org.eclipse.mita.base.types.Singleton;
import org.eclipse.mita.base.types.SumAlternative;
import org.eclipse.mita.base.types.SumType;
import org.eclipse.mita.base.types.TypeSpecifier;
import org.eclipse.mita.base.util.BaseUtils;
import org.eclipse.mita.program.ArrayLiteral;
import org.eclipse.mita.program.ConfigurationItemValue;
import org.eclipse.mita.program.ValueRange;
import org.eclipse.mita.program.VariableDeclaration;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IntegerRange;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;

public class StaticValueInferrer {
    protected static Object _infer(Singleton constr, ElementReferenceExpression expression, Procedures.Procedure1<? super EObject> inferenceBlockerAcceptor) {
        HashMap<String, Expression> props = new HashMap<String, Expression>(0);
        return new SumTypeRepr(props, (SumAlternative)constr, (Expression)expression);
    }

    protected static Object _infer(NamedProductType constr, ElementReferenceExpression expression, Procedures.Procedure1<? super EObject> inferenceBlockerAcceptor) {
        TreeMap<Parameter, Argument> propsRaw = ModelUtils.getSortedArgumentsAsMap((Iterable<Parameter>)constr.getParameters(), (Iterable<Argument>)expression.getArguments());
        int _size = propsRaw.size();
        final HashMap<String, Expression> props = new HashMap<String, Expression>(_size);
        BiConsumer<Parameter, Argument> _function = new BiConsumer<Parameter, Argument>(){

            @Override
            public void accept(Parameter p, Argument a) {
                props.put(p.getName(), a.getValue());
            }
        };
        propsRaw.forEach(_function);
        return new SumTypeRepr(props, (SumAlternative)constr, (Expression)expression);
    }

    protected static Object _infer(AnonymousProductType constr, ElementReferenceExpression expression, Procedures.Procedure1<? super EObject> inferenceBlockerAcceptor) {
        Iterable<Pair<TypeSpecifier, Argument>> propsRaw = ModelUtils.getFunctionCallArguments((EObject)expression);
        int argc = IterableExtensions.size(propsRaw);
        final HashMap<String, Expression> props = new HashMap<String, Expression>(argc);
        IntegerRange idxs = new IntegerRange(1, argc);
        Consumer<Pair<Integer, Pair<TypeSpecifier, Argument>>> _function = new Consumer<Pair<Integer, Pair<TypeSpecifier, Argument>>>(){

            @Override
            public void accept(Pair<Integer, Pair<TypeSpecifier, Argument>> idx__t_p) {
                Pair t_p = (Pair)idx__t_p.getValue();
                Integer _key = (Integer)idx__t_p.getKey();
                String _plus = "_" + _key;
                props.put(_plus, ((Argument)t_p.getValue()).getValue());
            }
        };
        BaseUtils.zip((Iterable)idxs, propsRaw).forEach(_function);
        return new SumTypeRepr(props, (SumAlternative)constr, (Expression)expression);
    }

    protected static Object _infer(EObject constr, ElementReferenceExpression expression, Procedures.Procedure1<? super EObject> inferenceBlockerAcceptor) {
        return StaticValueInferrer.infer(constr, inferenceBlockerAcceptor);
    }

    protected static Object _infer(ArrayLiteral expression, final Procedures.Procedure1<? super EObject> inferenceBlockerAcceptor) {
        Functions.Function1<Literal, Object> _function = new Functions.Function1<Literal, Object>(){

            public Object apply(Literal it) {
                return StaticValueInferrer.infer((EObject)it, (Procedures.Procedure1<? super EObject>)inferenceBlockerAcceptor);
            }
        };
        return IterableExtensions.toList((Iterable)ListExtensions.map(expression.getValues(), (Functions.Function1)_function));
    }

    protected static Object _infer(BoolLiteral expression, Procedures.Procedure1<? super EObject> inferenceBlockerAcceptor) {
        return expression.isValue();
    }

    protected static Object _infer(DoubleLiteral expression, Procedures.Procedure1<? super EObject> inferenceBlockerAcceptor) {
        return expression.getValue();
    }

    protected static Object _infer(FloatLiteral expression, Procedures.Procedure1<? super EObject> inferenceBlockerAcceptor) {
        return Float.valueOf(expression.getValue());
    }

    protected static Object _infer(StringLiteral expression, Procedures.Procedure1<? super EObject> inferenceBlockerAcceptor) {
        return expression.getValue();
    }

    protected static Object _infer(IntLiteral expression, Procedures.Procedure1<? super EObject> inferenceBlockerAcceptor) {
        return expression.getValue();
    }

    protected static Object _infer(Enumerator expression, Procedures.Procedure1<? super EObject> inferenceBlockerAcceptor) {
        return expression;
    }

    protected static Object _infer(NumericalUnaryExpression expression, Procedures.Procedure1<? super EObject> inferenceBlockerAcceptor) {
        Object inner = StaticValueInferrer.infer((EObject)expression.getOperand(), inferenceBlockerAcceptor);
        if (inner == null || !(inner instanceof Integer) && !(inner instanceof Float)) {
            return null;
        }
        UnaryOperator op = expression.getOperator();
        if (op != null) {
            switch (op) {
                case NEGATIVE: {
                    if (inner instanceof Integer) {
                        return -1 * (Integer)inner;
                    }
                    if (!(inner instanceof Float)) break;
                    return Float.valueOf(-1.0f * ((Float)inner).floatValue());
                }
            }
        }
        return null;
    }

    protected static Object _infer(PrimitiveValueExpression expression, Procedures.Procedure1<? super EObject> inferenceBlockerAcceptor) {
        return StaticValueInferrer.infer((EObject)expression.getValue(), inferenceBlockerAcceptor);
    }

    protected static Object _infer(ElementReferenceExpression expression, Procedures.Procedure1<? super EObject> inferenceBlockerAcceptor) {
        EObject ref = expression.getReference();
        if (ref != null) {
            return StaticValueInferrer.infer(ref, expression, inferenceBlockerAcceptor);
        }
        inferenceBlockerAcceptor.apply((Object)expression);
        return null;
    }

    protected static Object _infer(VariableDeclaration expression, Procedures.Procedure1<? super EObject> inferenceBlockerAcceptor) {
        boolean _isWriteable = expression.isWriteable();
        if (_isWriteable) {
            inferenceBlockerAcceptor.apply((Object)expression);
            return null;
        }
        Expression _initialization = expression.getInitialization();
        Object _infer = null;
        if (_initialization != null) {
            _infer = StaticValueInferrer.infer((EObject)_initialization, inferenceBlockerAcceptor);
        }
        return _infer;
    }

    protected static Object _infer(ValueRange expression, Procedures.Procedure1<? super EObject> inferenceBlockerAcceptor) {
        Expression _lowerBound = expression.getLowerBound();
        Object _infer = null;
        if (_lowerBound != null) {
            _infer = StaticValueInferrer.infer((EObject)_lowerBound, inferenceBlockerAcceptor);
        }
        Object lower = _infer;
        if (expression.getLowerBound() != null && lower == null) {
            return null;
        }
        Expression _upperBound = expression.getUpperBound();
        Object _infer_1 = null;
        if (_upperBound != null) {
            _infer_1 = StaticValueInferrer.infer((EObject)_upperBound, inferenceBlockerAcceptor);
        }
        Object upper = _infer_1;
        if (expression.getUpperBound() != null && upper == null) {
            return null;
        }
        return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new Object[]{lower, upper}));
    }

    protected static Object _infer(ConfigurationItemValue configItemValue, Procedures.Procedure1<? super EObject> inferenceBlockerAcceptor) {
        return StaticValueInferrer.infer((EObject)configItemValue.getValue(), inferenceBlockerAcceptor);
    }

    protected static Object _infer(Void expression, Procedures.Procedure1<? super EObject> inferenceBlockerAcceptor) {
        inferenceBlockerAcceptor.apply(null);
        return null;
    }

    protected static Object _infer(FeatureCall expression, Procedures.Procedure1<? super EObject> inferenceBlockerAcceptor) {
        return StaticValueInferrer.infer(expression.getFeature(), inferenceBlockerAcceptor);
    }

    protected static Object _infer(Expression expression, Procedures.Procedure1<? super EObject> inferenceBlockerAcceptor) {
        inferenceBlockerAcceptor.apply((Object)expression);
        return null;
    }

    protected static Object _infer(EObject expression, Procedures.Procedure1<? super EObject> inferenceBlockerAcceptor) {
        inferenceBlockerAcceptor.apply((Object)expression);
        return null;
    }

    public static Object infer(EObject constr, ElementReferenceExpression expression, Procedures.Procedure1<? super EObject> inferenceBlockerAcceptor) {
        if (constr instanceof AnonymousProductType && inferenceBlockerAcceptor != null) {
            return StaticValueInferrer._infer((AnonymousProductType)constr, expression, inferenceBlockerAcceptor);
        }
        if (constr instanceof NamedProductType && inferenceBlockerAcceptor != null) {
            return StaticValueInferrer._infer((NamedProductType)constr, expression, inferenceBlockerAcceptor);
        }
        if (constr instanceof Singleton && inferenceBlockerAcceptor != null) {
            return StaticValueInferrer._infer((Singleton)constr, expression, inferenceBlockerAcceptor);
        }
        if (constr != null && inferenceBlockerAcceptor != null) {
            return StaticValueInferrer._infer(constr, expression, inferenceBlockerAcceptor);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(constr, expression, inferenceBlockerAcceptor).toString());
    }

    public static Object infer(EObject expression, Procedures.Procedure1<? super EObject> inferenceBlockerAcceptor) {
        if (expression instanceof VariableDeclaration && inferenceBlockerAcceptor != null) {
            return StaticValueInferrer._infer((VariableDeclaration)expression, inferenceBlockerAcceptor);
        }
        if (expression instanceof Enumerator && inferenceBlockerAcceptor != null) {
            return StaticValueInferrer._infer((Enumerator)expression, inferenceBlockerAcceptor);
        }
        if (expression instanceof ElementReferenceExpression && inferenceBlockerAcceptor != null) {
            return StaticValueInferrer._infer((ElementReferenceExpression)expression, inferenceBlockerAcceptor);
        }
        if (expression instanceof FeatureCall && inferenceBlockerAcceptor != null) {
            return StaticValueInferrer._infer((FeatureCall)expression, inferenceBlockerAcceptor);
        }
        if (expression instanceof NumericalUnaryExpression && inferenceBlockerAcceptor != null) {
            return StaticValueInferrer._infer((NumericalUnaryExpression)expression, inferenceBlockerAcceptor);
        }
        if (expression instanceof BoolLiteral && inferenceBlockerAcceptor != null) {
            return StaticValueInferrer._infer((BoolLiteral)expression, inferenceBlockerAcceptor);
        }
        if (expression instanceof DoubleLiteral && inferenceBlockerAcceptor != null) {
            return StaticValueInferrer._infer((DoubleLiteral)expression, inferenceBlockerAcceptor);
        }
        if (expression instanceof FloatLiteral && inferenceBlockerAcceptor != null) {
            return StaticValueInferrer._infer((FloatLiteral)expression, inferenceBlockerAcceptor);
        }
        if (expression instanceof IntLiteral && inferenceBlockerAcceptor != null) {
            return StaticValueInferrer._infer((IntLiteral)expression, inferenceBlockerAcceptor);
        }
        if (expression instanceof PrimitiveValueExpression && inferenceBlockerAcceptor != null) {
            return StaticValueInferrer._infer((PrimitiveValueExpression)expression, inferenceBlockerAcceptor);
        }
        if (expression instanceof StringLiteral && inferenceBlockerAcceptor != null) {
            return StaticValueInferrer._infer((StringLiteral)expression, inferenceBlockerAcceptor);
        }
        if (expression instanceof ArrayLiteral && inferenceBlockerAcceptor != null) {
            return StaticValueInferrer._infer((ArrayLiteral)expression, inferenceBlockerAcceptor);
        }
        if (expression instanceof ValueRange && inferenceBlockerAcceptor != null) {
            return StaticValueInferrer._infer((ValueRange)expression, inferenceBlockerAcceptor);
        }
        if (expression instanceof Expression && inferenceBlockerAcceptor != null) {
            return StaticValueInferrer._infer((Expression)expression, inferenceBlockerAcceptor);
        }
        if (expression instanceof ConfigurationItemValue && inferenceBlockerAcceptor != null) {
            return StaticValueInferrer._infer((ConfigurationItemValue)expression, inferenceBlockerAcceptor);
        }
        if (expression != null && inferenceBlockerAcceptor != null) {
            return StaticValueInferrer._infer(expression, inferenceBlockerAcceptor);
        }
        if (expression == null && inferenceBlockerAcceptor != null) {
            return StaticValueInferrer._infer(null, inferenceBlockerAcceptor);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(expression, inferenceBlockerAcceptor).toString());
    }

    public static class SumTypeRepr {
        public final String name;
        public final Map<String, Expression> properties;
        public final SumType typ;
        public final SumAlternative constructor;
        public final Expression underlyingExpression;

        public SumTypeRepr(Map<String, Expression> p, SumAlternative c, Expression e) {
            this.name = c.getName();
            this.properties = p;
            EObject _eContainer = c.eContainer();
            this.typ = (SumType)_eContainer;
            this.constructor = c;
            this.underlyingExpression = e;
        }

        public String toString() {
            String _name = this.typ.getName();
            String _plus = String.valueOf(_name) + ".";
            String _plus_1 = String.valueOf(_plus) + this.name;
            String _plus_2 = String.valueOf(_plus_1) + "(";
            Functions.Function1<Map.Entry<String, Expression>, Object> _function = new Functions.Function1<Map.Entry<String, Expression>, Object>(){

                public Object apply(Map.Entry<String, Expression> name_expr) {
                    Object _xblockexpression = null;
                    String _key = name_expr.getKey();
                    Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

                        public void apply(EObject it) {
                        }
                    };
                    _xblockexpression = StaticValueInferrer.infer((EObject)name_expr.getValue(), (Procedures.Procedure1<? super EObject>)_function);
                    return _xblockexpression;
                }
            };
            String _join = IterableExtensions.join((Iterable)IterableExtensions.map(this.properties.entrySet(), (Functions.Function1)_function), (CharSequence)", ");
            String _plus_3 = String.valueOf(_plus_2) + _join;
            return String.valueOf(_plus_3) + ")";
        }
    }
}

