/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.program.model;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.mita.base.types.TypesPackage;
import org.eclipse.mita.library.extension.LibraryExtensions;
import org.eclipse.xtext.resource.IContainer;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceDescriptionsProvider;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ImportHelper {
    @Inject
    @Extension
    private IResourceDescriptionsProvider _iResourceDescriptionsProvider;
    @Inject
    @Extension
    private IContainer.Manager _manager;

    public List<String> getVisiblePackages(Resource resource) {
        IResourceDescriptions index = this._iResourceDescriptionsProvider.getResourceDescriptions(resource.getResourceSet());
        IResourceDescription resDesc = index.getResourceDescription(resource.getURI());
        List visibleContainers = this._manager.getVisibleContainers(resDesc, index);
        Functions.Function1<IContainer, Iterable<IEObjectDescription>> _function = new Functions.Function1<IContainer, Iterable<IEObjectDescription>>(){

            public Iterable<IEObjectDescription> apply(IContainer it) {
                return it.getExportedObjectsByType(TypesPackage.Literals.PACKAGE_ASSOCIATION);
            }
        };
        Functions.Function1<IEObjectDescription, String> _function_1 = new Functions.Function1<IEObjectDescription, String>(){

            public String apply(IEObjectDescription it) {
                return it.getName().toString();
            }
        };
        List visiblePackages = IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)visibleContainers, (Functions.Function1)_function)), (Functions.Function1)_function_1));
        Functions.Function1<LibraryExtensions.LibraryDescriptor, String> _function_2 = new Functions.Function1<LibraryExtensions.LibraryDescriptor, String>(){

            public String apply(LibraryExtensions.LibraryDescriptor it) {
                return it.getId();
            }
        };
        List _map = ListExtensions.map((List)LibraryExtensions.getAvailablePlatforms(), (Functions.Function1)_function_2);
        Iterables.addAll((Collection)visiblePackages, (Iterable)_map);
        return visiblePackages;
    }
}

