/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.io;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.program.SignalInstance;
import org.eclipse.mita.program.generator.AbstractSystemResourceGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.IPlatformLoggingGenerator;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Procedures;

public class SDCardGenerator
extends AbstractSystemResourceGenerator {
    @Inject(optional=true)
    protected IPlatformLoggingGenerator loggingGenerator;

    public CodeFragment generateSetup() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
            }
        };
        CodeFragment _addHeader = this.codeFragmentProvider.create(_client).addHeader("BCDS_Basics.h", true, 1000).addHeader("BCDS_Retcode.h", true, 1000).addHeader("FreeRTOS.h", true, 750).addHeader("task.h", true).addHeader("string.h", true).addHeader("XdkCommonInfo.h", true).addHeader("ff.h", true).addHeader("BCDS_SDCard_Driver.h", true);
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"static FATFS StorageSDCardFatFSObject; /** File system specific objects */");
                _builder.newLine();
                _builder.append((Object)"/**< Macro to define default logical drive */");
                _builder.newLine();
                _builder.append((Object)"#define STORAGE_DEFAULT_LOGICAL_DRIVE           \"\"");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/**< Macro to define force mount */");
                _builder.newLine();
                _builder.append((Object)"#define STORAGE_SDCARD_FORCE_MOUNT              UINT8_C(1)");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"/**< SD Card Drive 0 location */");
                _builder.newLine();
                _builder.append((Object)"#define STORAGE_SDCARD_DRIVE_NUMBER             UINT8_C(0)");
                _builder.newLine();
                _builder.newLine();
                EList _signalInstances = SDCardGenerator.this.setup.getSignalInstances();
                for (SignalInstance sigInst : _signalInstances) {
                    boolean _startsWith = sigInst.getInstanceOf().getName().startsWith("resuming");
                    if (!_startsWith) continue;
                    _builder.append((Object)"static uint16_t ");
                    String _name = sigInst.getName();
                    _builder.append((Object)_name);
                    _builder.append((Object)"FilePosition = 0UL;");
                    _builder.newLineIfNotEmpty();
                }
                _builder.newLine();
            }
        };
        return _addHeader.setPreamble(_client_1);
    }

    public CodeFragment getSize(SignalInstance instance) {
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        };
        final Object result = StaticValueInferrer.infer((EObject)ModelUtils.getArgumentValue((SignalInstance)instance, (String)SDCardGenerator.getSizeName(instance)), (Procedures.Procedure1)_function);
        if (result instanceof Integer) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)((Integer)result));
                }
            };
            return this.codeFragmentProvider.create(_client);
        }
        StringConcatenationClient _client_1 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"-1");
            }
        };
        return this.codeFragmentProvider.create(_client_1);
    }

    public static String getSizeName(SignalInstance instance) {
        boolean _startsWith = instance.getInstanceOf().getName().startsWith("rewinding");
        if (_startsWith) {
            return "fileSize";
        }
        return "blockSize";
    }

    public CodeFragment generateEnable() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T retcode = RETCODE_OK;");
                _builder.newLine();
                _builder.append((Object)"retcode = SDCardDriver_Initialize();");
                _builder.newLine();
                _builder.append((Object)"if (RETCODE_OK == retcode)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"if (SDCARD_INSERTED != SDCardDriver_GetDetectStatus())");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                CodeFragment _generateLogStatement = SDCardGenerator.this.loggingGenerator.generateLogStatement(IPlatformLoggingGenerator.LogLevel.Error, "SD card was not detected for Storage", new CodeFragment[0]);
                _builder.append((Object)_generateLogStatement, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"retcode = RETCODE(RETCODE_SEVERITY_WARNING, RETCODE_STORAGE_SDCARD_NOT_AVAILABLE);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"if (RETCODE_OK == retcode)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"retcode = SDCardDriver_DiskInitialize(STORAGE_SDCARD_DRIVE_NUMBER); /* Initialize SD card */");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"if (RETCODE_OK == retcode)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"/* Initialize file system */");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"if (FR_OK != f_mount(&StorageSDCardFatFSObject, STORAGE_DEFAULT_LOGICAL_DRIVE, STORAGE_SDCARD_FORCE_MOUNT))");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"retcode = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_STORAGE_SDCARD_MOUNT_FAILED);");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"return retcode;");
                _builder.newLine();
            }
        };
        return this.codeFragmentProvider.create(_client);
    }

    public CodeFragment generateSignalInstanceGetter(final SignalInstance sigInst, final String valueVariableName) {
        CodeFragment _xblockexpression = null;
        final String signalName = sigInst.getInstanceOf().getName();
        boolean _endsWith = signalName.endsWith("Write");
        if (_endsWith) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"BCDS_UNUSED(");
                    _builder.append((Object)valueVariableName);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"return RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_FAILURE);");
                    _builder.newLine();
                }
            };
            return this.codeFragmentProvider.create(_client);
        }
        final CodeFragment data = this.dataAccessor(sigInst, valueVariableName);
        final CodeFragment len = this.getSize(sigInst);
        final CodeFragment filename = this.filenameAccessor(sigInst, valueVariableName);
        CodeFragment _xifexpression = null;
        boolean _startsWith = signalName.startsWith("resuming");
        if (_startsWith) {
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    String _name = sigInst.getName();
                    _builder.append((Object)_name);
                    _builder.append((Object)"FilePosition");
                }
            };
            _xifexpression = this.codeFragmentProvider.create(_client_1);
        } else {
            StringConcatenationClient _client_2 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"0");
                }
            };
            _xifexpression = this.codeFragmentProvider.create(_client_2);
        }
        final CodeFragment fileSeekIndex = _xifexpression;
        StringConcatenationClient _client_3 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T retcode = RETCODE_OK;");
                _builder.newLine();
                _builder.append((Object)"FRESULT sdCardReturn = FR_OK, fileOpenReturn = FR_OK;");
                _builder.newLine();
                _builder.append((Object)"FILINFO sdCardFileInfo;");
                _builder.newLine();
                _builder.append((Object)"#if _USE_LFN");
                _builder.newLine();
                _builder.append((Object)"sdCardFileInfo.lfname = NULL;");
                _builder.newLine();
                _builder.append((Object)"#endif");
                _builder.newLine();
                _builder.append((Object)"FIL fileReadHandle;");
                _builder.newLine();
                _builder.append((Object)"UINT bytesRead;");
                _builder.newLine();
                _builder.newLine();
                _builder.append((Object)"sdCardReturn = f_stat(");
                _builder.append((Object)filename);
                _builder.append((Object)", &sdCardFileInfo);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"if (FR_OK == sdCardReturn)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"if(");
                _builder.append((Object)fileSeekIndex, "\t");
                _builder.append((Object)" >= sdCardFileInfo.fsize)");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"return EXCEPTION_ENDOFFILEEXCEPTION;");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"else");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t\t");
                _builder.append((Object)"fileOpenReturn = f_open(&fileReadHandle, ");
                _builder.append((Object)filename, "\t\t");
                _builder.append((Object)", FA_OPEN_EXISTING | FA_READ);");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"if ((FR_OK == sdCardReturn) && (FR_OK == fileOpenReturn))");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"sdCardReturn = f_lseek(&fileReadHandle, ");
                _builder.append((Object)fileSeekIndex, "    ");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"if ((FR_OK == sdCardReturn) && (FR_OK == fileOpenReturn))");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"sdCardReturn = f_read(&fileReadHandle, ");
                _builder.append((Object)data, "    ");
                _builder.append((Object)", ");
                _builder.append((Object)len, "    ");
                _builder.append((Object)", &bytesRead); /* Read a chunk of source file */");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"if ((FR_OK == sdCardReturn) && (FR_OK == fileOpenReturn))");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                boolean _startsWith = signalName.startsWith("resuming");
                if (_startsWith) {
                    _builder.append((Object)"\t");
                    String _name = sigInst.getName();
                    _builder.append((Object)_name, "\t");
                    _builder.append((Object)"FilePosition += bytesRead;");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"if (FR_OK == fileOpenReturn)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"sdCardReturn = f_close(&fileReadHandle);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"if ((FR_OK != sdCardReturn) || (FR_OK != fileOpenReturn))");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"retcode = RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_STORAGE_SDCARD_READ_FAILED);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"return retcode;");
                _builder.newLine();
            }
        };
        _xblockexpression = this.codeFragmentProvider.create(_client_3).addHeader("MitaExceptions.h", false);
        return _xblockexpression;
    }

    public CodeFragment generateSignalInstanceSetter(final SignalInstance sigInst, final String valueVariableName) {
        CodeFragment _xblockexpression = null;
        String signalName = sigInst.getInstanceOf().getName();
        final boolean isAppending = signalName.startsWith("appending");
        boolean _endsWith = signalName.endsWith("Read");
        if (_endsWith) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"BCDS_UNUSED(");
                    _builder.append((Object)valueVariableName);
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"return RETCODE(RETCODE_SEVERITY_ERROR, RETCODE_FAILURE);");
                    _builder.newLine();
                }
            };
            return this.codeFragmentProvider.create(_client);
        }
        final CodeFragment data = this.dataAccessor(sigInst, valueVariableName);
        final CodeFragment len = this.lenAccessor(sigInst, valueVariableName);
        final CodeFragment filename = this.filenameAccessor(sigInst, valueVariableName);
        CodeFragment _xifexpression = null;
        if (isAppending) {
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    String _name = sigInst.getName();
                    _builder.append((Object)_name);
                    _builder.append((Object)"FilePosition");
                }
            };
            _xifexpression = this.codeFragmentProvider.create(_client_1);
        } else {
            StringConcatenationClient _client_2 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"0");
                }
            };
            _xifexpression = this.codeFragmentProvider.create(_client_2);
        }
        final CodeFragment fileSeekIndex = _xifexpression;
        String _xifexpression_1 = null;
        _xifexpression_1 = isAppending ? "FA_WRITE | FA_OPEN_ALWAYS" : "FA_WRITE | FA_CREATE_ALWAYS";
        final String fileOpenMode = _xifexpression_1;
        StringConcatenationClient _client_3 = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Retcode_T retcode = RETCODE_OK;");
                _builder.newLine();
                _builder.append((Object)"FRESULT sdCardReturn = FR_OK, fileOpenReturn = FR_OK;");
                _builder.newLine();
                _builder.append((Object)"FIL fileWriteHandle;");
                _builder.newLine();
                _builder.append((Object)"UINT bytesWritten;");
                _builder.newLine();
                if (isAppending) {
                    _builder.append((Object)"FILINFO sdCardFileInfo;");
                    _builder.newLine();
                    _builder.append((Object)"#if _USE_LFN");
                    _builder.newLine();
                    _builder.append((Object)"sdCardFileInfo.lfname = NULL;");
                    _builder.newLine();
                    _builder.append((Object)"#endif");
                    _builder.newLine();
                    _builder.append((Object)"uint16_t ");
                    _builder.append((Object)fileSeekIndex);
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"fileOpenReturn = f_open(&fileWriteHandle, ");
                _builder.append((Object)filename);
                _builder.append((Object)", ");
                _builder.append((Object)fileOpenMode);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                if (isAppending) {
                    _builder.append((Object)"if ((FR_OK == sdCardReturn) && (FR_OK == fileOpenReturn))");
                    _builder.newLine();
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    _builder.append((Object)"sdCardReturn = f_stat(");
                    _builder.append((Object)filename, "\t");
                    _builder.append((Object)", &sdCardFileInfo);");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)fileSeekIndex, "\t");
                    _builder.append((Object)" = sdCardFileInfo.fsize;");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                }
                _builder.append((Object)"if ((FR_OK == sdCardReturn) && (FR_OK == fileOpenReturn))");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"sdCardReturn = f_lseek(&fileWriteHandle, ");
                _builder.append((Object)fileSeekIndex, "    ");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"if ((FR_OK == sdCardReturn) && (FR_OK == fileOpenReturn))");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"sdCardReturn = f_write(&fileWriteHandle, ");
                _builder.append((Object)data, "    ");
                _builder.append((Object)", ");
                _builder.append((Object)len, "    ");
                _builder.append((Object)", &bytesWritten); /* Write it to the destination file */");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"if (FR_OK == fileOpenReturn)");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                _builder.append((Object)"sdCardReturn = f_close(&fileWriteHandle);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"if ((FR_OK != sdCardReturn) || (FR_OK != fileOpenReturn))");
                _builder.newLine();
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"    ");
                _builder.append((Object)"retcode = RETCODE(RETCODE_SEVERITY_WARNING, RETCODE_STORAGE_ERROR_IN_FILE_WRITE);");
                _builder.newLine();
                _builder.append((Object)"}");
                _builder.newLine();
                _builder.append((Object)"return retcode;");
                _builder.newLine();
            }
        };
        _xblockexpression = this.codeFragmentProvider.create(_client_3);
        return _xblockexpression;
    }

    public CodeFragment dataAccessor(SignalInstance sigInst, final String varName) {
        CodeFragment _xifexpression = null;
        boolean _contains = sigInst.getInstanceOf().getName().contains("Text");
        if (_contains) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"*");
                    _builder.append((Object)varName);
                }
            };
            _xifexpression = this.codeFragmentProvider.create(_client);
        } else {
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)varName);
                    _builder.append((Object)"->data");
                }
            };
            _xifexpression = this.codeFragmentProvider.create(_client_1);
        }
        return _xifexpression;
    }

    public CodeFragment lenAccessor(SignalInstance sigInst, final String varName) {
        CodeFragment _xifexpression = null;
        boolean _contains = sigInst.getInstanceOf().getName().contains("Text");
        if (_contains) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"strlen(*");
                    _builder.append((Object)varName);
                    _builder.append((Object)")");
                }
            };
            _xifexpression = this.codeFragmentProvider.create(_client);
        } else {
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)varName);
                    _builder.append((Object)"->length");
                }
            };
            _xifexpression = this.codeFragmentProvider.create(_client_1);
        }
        return _xifexpression;
    }

    public CodeFragment filenameAccessor(SignalInstance sigInst, String varName) {
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
            }
        };
        final Object filenameRaw = StaticValueInferrer.infer((EObject)ModelUtils.getArgumentValue((SignalInstance)sigInst, (String)"filePath"), (Procedures.Procedure1)_function);
        CodeFragment _xifexpression = null;
        if (filenameRaw instanceof String) {
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"\"");
                    _builder.append((Object)((String)filenameRaw));
                    _builder.append((Object)"\"");
                }
            };
            _xifexpression = this.codeFragmentProvider.create(_client);
        } else {
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)"INVALID_ARGUMENT");
                }
            };
            _xifexpression = this.codeFragmentProvider.create(_client_1);
        }
        return _xifexpression;
    }
}

