/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.sensors;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mita.base.types.Enumerator;
import org.eclipse.mita.program.ModalityAccess;
import org.eclipse.mita.program.ModalityAccessPreparation;
import org.eclipse.mita.program.generator.AbstractSystemResourceGenerator;
import org.eclipse.mita.program.generator.CodeFragment;
import org.eclipse.mita.program.generator.GeneratorUtils;
import org.eclipse.mita.program.generator.IComponentConfiguration;
import org.eclipse.mita.program.generator.IPlatformExceptionGenerator;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtend2.lib.StringConcatenationClient;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class Bmm150Generator
extends AbstractSystemResourceGenerator {
    @Inject
    @Extension
    protected GeneratorUtils _generatorUtils;
    @Inject
    protected IPlatformExceptionGenerator exceptionGenerator;

    public CodeFragment generateSetup() {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                CodeFragment _exceptionType = Bmm150Generator.this.exceptionGenerator.getExceptionType();
                _builder.append((Object)_exceptionType);
                _builder.append((Object)" exception = ");
                CodeFragment _noExceptionStatement = Bmm150Generator.this.exceptionGenerator.getNoExceptionStatement();
                _builder.append((Object)_noExceptionStatement);
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"exception = Magnetometer_init(XdkMagnetometer_BMM150_Handle);");
                _builder.newLine();
                CharSequence _generateExceptionHandler = Bmm150Generator.this._generatorUtils.generateExceptionHandler((EObject)Bmm150Generator.this.component, "exception");
                _builder.append((Object)_generateExceptionHandler);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"return Magnetometer_setPresetMode(XdkMagnetometer_BMM150_Handle, ");
                String _bmmPresetEnumValue = Bmm150Generator.this.getBmmPresetEnumValue(Bmm150Generator.this.configuration);
                _builder.append((Object)_bmmPresetEnumValue);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("BCDS_Magnetometer.h", true).addHeader("XDK_SensorHandle.h", true);
    }

    public CodeFragment generateEnable() {
        return CodeFragment.EMPTY;
    }

    public String getBmmPresetEnumValue(IComponentConfiguration config) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("MAGNETOMETER_BMM150_PRESETMODE_");
        Enumerator _enumerator = config.getEnumerator("mode");
        String _name = null;
        if (_enumerator != null) {
            _name = _enumerator.getName();
        }
        String _upperCase = null;
        if (_name != null) {
            _upperCase = _name.toUpperCase();
        }
        _builder.append(_upperCase);
        return _builder.toString();
    }

    public CodeFragment generateAccessPreparationFor(final ModalityAccessPreparation accessPreparation) {
        StringConcatenationClient _client = new StringConcatenationClient(){

            protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                _builder.append((Object)"Magnetometer_XyzData_T ");
                String _dataVariable = Bmm150Generator.this.getDataVariable(accessPreparation);
                _builder.append((Object)_dataVariable);
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"exception = Magnetometer_readXyzLsbData(XdkMagnetometer_BMM150_Handle, &");
                String _dataVariable_1 = Bmm150Generator.this.getDataVariable(accessPreparation);
                _builder.append((Object)_dataVariable_1);
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                CharSequence _generateExceptionHandler = Bmm150Generator.this._generatorUtils.generateExceptionHandler((EObject)Bmm150Generator.this.component, "exception");
                _builder.append((Object)_generateExceptionHandler);
                _builder.newLineIfNotEmpty();
            }
        };
        return this.codeFragmentProvider.create(_client).addHeader("BCDS_Magnetometer.h", true).addHeader("XdkSensorHandle.h", true);
    }

    public String getDataVariable(ModalityAccessPreparation preparation) {
        return StringExtensions.toFirstLower((String)this._generatorUtils.getUniqueIdentifier((EObject)preparation));
    }

    public CodeFragment generateModalityAccessFor(ModalityAccess modalityAccess) {
        final String dataVariable = this.getDataVariable(modalityAccess.getPreparation());
        String modalityName = modalityAccess.getModality().getName();
        CodeFragment _switchResult = null;
        boolean _matched = false;
        if (Objects.equal((Object)modalityName, (Object)"x_axis")) {
            _matched = true;
            StringConcatenationClient _client = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)dataVariable);
                    _builder.append((Object)".xAxisData");
                }
            };
            _switchResult = this.codeFragmentProvider.create(_client);
        }
        if (!_matched && Objects.equal((Object)modalityName, (Object)"y_axis")) {
            _matched = true;
            StringConcatenationClient _client_1 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)dataVariable);
                    _builder.append((Object)".yAxisData");
                }
            };
            _switchResult = this.codeFragmentProvider.create(_client_1);
        }
        if (!_matched && Objects.equal((Object)modalityName, (Object)"z_axis")) {
            _matched = true;
            StringConcatenationClient _client_2 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)dataVariable);
                    _builder.append((Object)".zAxisData");
                }
            };
            _switchResult = this.codeFragmentProvider.create(_client_2);
        }
        if (!_matched && Objects.equal((Object)modalityName, (Object)"resistance")) {
            _matched = true;
            StringConcatenationClient _client_3 = new StringConcatenationClient(){

                protected void appendTo(StringConcatenationClient.TargetStringConcatenation _builder) {
                    _builder.append((Object)dataVariable);
                    _builder.append((Object)".resistance");
                }
            };
            _switchResult = this.codeFragmentProvider.create(_client_3);
        }
        return _switchResult;
    }
}

