/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mita.platform.xdk110.sensors;

import com.google.common.base.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.mita.base.expressions.Expression;
import org.eclipse.mita.platform.Sensor;
import org.eclipse.mita.program.ConfigurationItemValue;
import org.eclipse.mita.program.Program;
import org.eclipse.mita.program.ProgramPackage;
import org.eclipse.mita.program.SystemResourceSetup;
import org.eclipse.mita.program.inferrer.StaticValueInferrer;
import org.eclipse.mita.program.model.ModelUtils;
import org.eclipse.mita.program.validation.IResourceValidator;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class Max44009Validator
implements IResourceValidator {
    public static final String NEEDS_MANUAL_MODE_MSG = "Please set manual_mode to true for %s to take effect.";
    public static final String NEEDS_MANUAL_MODE_CODE = "NEEDS_MANUAL_MODE_CODE";

    public void validate(Program program, EObject context, ValidationMessageAcceptor acceptor) {
        SystemResourceSetup sensorSetup = ModelUtils.findSetupFor((Program)program, Sensor.class, (String)"MAX44009");
        if (sensorSetup != null) {
            Functions.Function1<ConfigurationItemValue, Boolean> _function = new Functions.Function1<ConfigurationItemValue, Boolean>(){

                public Boolean apply(ConfigurationItemValue x) {
                    String _name = x.getItem().getName();
                    return Objects.equal((Object)_name, (Object)"manual_mode");
                }
            };
            ConfigurationItemValue _findFirst = (ConfigurationItemValue)IterableExtensions.findFirst((Iterable)sensorSetup.getConfigurationItemValues(), (Functions.Function1)_function);
            Expression _value = null;
            if (_findFirst != null) {
                _value = _findFirst.getValue();
            }
            Expression manualModeConfigItemValue = _value;
            Object _xifexpression = null;
            if (manualModeConfigItemValue == null) {
                _xifexpression = null;
            } else {
                Procedures.Procedure1<EObject> _function_1 = new Procedures.Procedure1<EObject>(){

                    public void apply(EObject x) {
                    }
                };
                _xifexpression = StaticValueInferrer.infer((EObject)manualModeConfigItemValue, (Procedures.Procedure1)_function_1);
            }
            Object manualMode = _xifexpression;
            if (manualMode == null || manualMode instanceof Boolean && Objects.equal((Object)manualMode, (Object)false)) {
                Max44009Validator.warnIfConfigItemPresent(acceptor, sensorSetup, "high_brightness");
                Max44009Validator.warnIfConfigItemPresent(acceptor, sensorSetup, "integration_time");
            }
        }
    }

    private static void warnIfConfigItemPresent(ValidationMessageAcceptor acceptor, SystemResourceSetup sensorSetup, final String configItemName) {
        Functions.Function1<ConfigurationItemValue, Boolean> _function = new Functions.Function1<ConfigurationItemValue, Boolean>(){

            public Boolean apply(ConfigurationItemValue x) {
                String _name = x.getItem().getName();
                return Objects.equal((Object)_name, (Object)configItemName);
            }
        };
        ConfigurationItemValue configItemIntegrationTime = (ConfigurationItemValue)IterableExtensions.findFirst((Iterable)sensorSetup.getConfigurationItemValues(), (Functions.Function1)_function);
        if (configItemIntegrationTime != null) {
            acceptor.acceptWarning(String.format(NEEDS_MANUAL_MODE_MSG, configItemName), (EObject)configItemIntegrationTime, (EStructuralFeature)ProgramPackage.eINSTANCE.getConfigurationItemValue_Item(), -1, NEEDS_MANUAL_MODE_CODE, new String[0]);
        }
    }
}

