/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.am3.ui.action;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.am3.core.AM3CorePlugin;
import org.eclipse.am3.core.AM3CoreTools;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.m2m.atl.engine.AtlLauncher;
import org.eclipse.m2m.atl.engine.AtlModelHandler;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

public class ActionATLExtractor
extends Action {
    private AtlModelHandler amh = AtlModelHandler.getDefault((String)"EMF");
    private IFile file;
    private EObject extractor;
    private EObject metamodel;

    public ActionATLExtractor(String text, IFile file, EObject extractor, EObject metamodel) {
        super(text);
        this.file = file;
        this.extractor = extractor;
        this.metamodel = metamodel;
    }

    public void run() {
        try {
            InputStream in = this.file.getContents();
            ASMModel mm = AM3CoreTools.loadMetamodel((AtlModelHandler)this.amh, (String)((String)AM3CorePlugin.getDefault().getHandler().get(this.metamodel, "name")), (String)((String)AM3CorePlugin.getDefault().getHandler().get(this.metamodel, "uri")));
            ASMModel model = this.amh.loadModel(this.file.getName(), mm, in);
            HashMap<Object, ASMModel> models = new HashMap<Object, ASMModel>();
            models.put(AM3CorePlugin.getDefault().getHandler().get(this.extractor, "paramMetamodel"), mm);
            models.put(AM3CorePlugin.getDefault().getHandler().get(this.extractor, "paramModel"), model);
            Map params = Collections.EMPTY_MAP;
            Map libs = Collections.EMPTY_MAP;
            URL asmUrl = new File(String.valueOf(AM3CorePlugin.getPluginRep()) + (String)AM3CorePlugin.getDefault().getHandler().get(this.extractor, "uri")).toURL();
            ASMOclAny s = (ASMOclAny)AtlLauncher.getDefault().launch(asmUrl, libs, models, params, Collections.EMPTY_LIST, Collections.EMPTY_MAP);
            if (s == null) {
                return;
            }
            if (!(s instanceof ASMString)) {
                System.err.println("Query is not an instance of ASMString");
            }
            String name = this.file.getName();
            name = String.valueOf(name.substring(0, name.length() - this.file.getFileExtension().length())) + AM3CorePlugin.getDefault().getHandler().get(this.extractor, "extension");
            if (((ASMString)s).getSymbol() != null) {
                IWorkspace wks = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot wksroot = wks.getRoot();
                IFile fileCreated = wksroot.getFile(this.file.getFullPath().removeLastSegments(1).append(name));
                InputStream stream = this.openContentStream(((ASMString)s).getSymbol());
                if (fileCreated.exists()) {
                    fileCreated.setContents(stream, true, true, null);
                } else {
                    fileCreated.create(stream, true, null);
                }
                try {
                    stream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e1) {
            System.err.println(e1);
        }
    }

    private InputStream openContentStream(String contents) {
        return new ByteArrayInputStream(contents.getBytes());
    }
}

