/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.drivers.emf4atl.tcs.injector;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.m2m.atl.dsls.tcs.injector.ModelAdapter;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBoolean;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMCollection;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMEnumLiteral;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMInteger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMReal;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMSequence;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

public class ASMModelAdapter
implements ModelAdapter {
    private ASMModel model;

    public ASMModelAdapter(Object model) {
        this.model = (ASMModel)model;
    }

    public Object getModel() {
        return this.model;
    }

    private void actualSet(Object ame_, String propertyName, Object value) {
        ASMModelElement ame = (ASMModelElement)ame_;
        ame.set(null, propertyName, (ASMOclAny)value);
    }

    public Object get(Object ame_, String propertyName) {
        Object ret = null;
        ASMModelElement ame = (ASMModelElement)ame_;
        ret = ame.get(null, propertyName);
        if (ret instanceof ASMInteger) {
            ret = new Integer(((ASMInteger)ret).getSymbol());
        } else if (ret instanceof ASMReal) {
            ret = new Double(((ASMReal)ret).getSymbol());
        } else if (ret instanceof ASMBoolean) {
            ret = ((ASMBoolean)ret).getSymbol() ? Boolean.TRUE : Boolean.FALSE;
        } else if (ret instanceof ASMString) {
            ret = ((ASMString)ret).getSymbol();
        }
        return ret;
    }

    public Object createElement(String typeName) {
        ASMModelElement ret = null;
        ret = this.model.newModelElement(typeName);
        return ret;
    }

    public Set getElementsByType(String typeName) {
        ASMModelElement valueType = this.model.getMetamodel().findModelElement(typeName);
        return this.model.getElementsByType(valueType);
    }

    public void set(Object ame, String prop, Object value) {
        ASMOclAny v = this.java2asm(value);
        if (v != null) {
            this.actualSet(ame, prop, v);
        }
    }

    private ASMOclAny java2asm(Object value) {
        ASMModelElement ret = null;
        if (value instanceof ASMModelElement) {
            ret = (ASMModelElement)value;
        } else if (value instanceof ASMEnumLiteral) {
            ret = (ASMEnumLiteral)value;
        } else if (value instanceof ASMCollection) {
            ret = (ASMCollection)value;
        } else if (value instanceof Collection) {
            ASMSequence seq = new ASMSequence();
            Iterator i = ((Collection)value).iterator();
            while (i.hasNext()) {
                seq.add(this.java2asm(i.next()));
            }
            ret = seq;
        } else if (value instanceof Integer) {
            ret = new ASMInteger(((Integer)value).intValue());
        } else if (value instanceof Double) {
            ret = new ASMReal(((Double)value).doubleValue());
        } else if (value instanceof Boolean) {
            ret = new ASMBoolean(((Boolean)value).booleanValue());
        } else if (value instanceof String) {
            ret = new ASMString((String)value);
        }
        return ret;
    }

    public boolean isCandidate(Object ame, String typeName) {
        boolean ret = false;
        ASMModelElement valueType = this.model.getMetamodel().findModelElement(typeName);
        ret = ((ASMModelElement)ame).getType().conformsTo((ASMOclType)valueType).getSymbol();
        return ret;
    }

    public Object getType(Object me_) {
        return ((ASMModelElement)me_).getType();
    }

    public boolean isAModelElement(Object me) {
        return me instanceof ASMModelElement;
    }

    public String getString(Object ame, String propName) {
        return ((ASMString)this.get(ame, propName)).getSymbol();
    }

    public Object createEnumLiteral(String name) {
        ASMEnumLiteral ret = new ASMEnumLiteral(name);
        return ret;
    }
}

