/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.EmftvmPackage;
import org.eclipse.m2m.atl.emftvm.ExecEnv;
import org.eclipse.m2m.atl.emftvm.Field;
import org.eclipse.m2m.atl.emftvm.InputRuleElement;
import org.eclipse.m2m.atl.emftvm.Model;
import org.eclipse.m2m.atl.emftvm.OutputRuleElement;
import org.eclipse.m2m.atl.emftvm.Rule;
import org.eclipse.m2m.atl.emftvm.RuleElement;
import org.eclipse.m2m.atl.emftvm.RuleMode;
import org.eclipse.m2m.atl.emftvm.trace.SourceElement;
import org.eclipse.m2m.atl.emftvm.trace.SourceElementList;
import org.eclipse.m2m.atl.emftvm.trace.TargetElement;
import org.eclipse.m2m.atl.emftvm.trace.TraceFactory;
import org.eclipse.m2m.atl.emftvm.trace.TraceLink;
import org.eclipse.m2m.atl.emftvm.trace.TraceLinkSet;
import org.eclipse.m2m.atl.emftvm.trace.TracedRule;
import org.eclipse.m2m.atl.emftvm.util.EMFTVMUtil;
import org.eclipse.m2m.atl.emftvm.util.LazyList;
import org.eclipse.m2m.atl.emftvm.util.StackFrame;
import org.eclipse.m2m.atl.emftvm.util.TimingData;
import org.eclipse.m2m.atl.emftvm.util.VMException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Matcher {
    private final TraceFactory factory = TraceFactory.eINSTANCE;
    private final StackFrame frame;
    private final Rule rule;
    private TraceLinkSet matches;
    private TraceLinkSet traces;

    public Matcher(StackFrame frame, Rule rule) {
        this.frame = frame;
        this.rule = rule;
    }

    public static void matchAll(StackFrame frame, TimingData timingData) {
        Matcher.matchAllSingle(frame, timingData);
        Matcher.matchAllRecursive(frame);
        timingData.finishRecursive();
    }

    public static Object matchOne(StackFrame frame, Rule rule, EObject[] values) {
        Matcher matcher = new Matcher(frame, rule);
        Map<String, EObject> valuesMap = Matcher.createValuesMap(rule, values);
        if (matcher.matchOne(valuesMap)) {
            TraceLink trace = matcher.createTrace(valuesMap);
            HashMap<Rule, Object[]> ruleApplyArgs = new HashMap<Rule, Object[]>();
            StackFrame applyResult = matcher.applyFor(trace, rule, ruleApplyArgs);
            StackFrame postResult = matcher.postApplyFor(trace, rule, ruleApplyArgs);
            StackFrame result = postResult == null || postResult.stackEmpty() ? applyResult : postResult;
            return result == null || result.stackEmpty() ? null : result.pop();
        }
        return null;
    }

    private static List<Rule> getRulesOfKind(List<Rule> rules, RuleMode kind) {
        ArrayList<Rule> rulesOfKind = new ArrayList<Rule>(rules.size());
        for (Rule rule : rules) {
            if (rule.getMode() != kind) continue;
            rulesOfKind.add(rule);
        }
        return rulesOfKind;
    }

    private static void matchAllSingle(StackFrame frame, TimingData timingData) {
        Matcher matcher;
        boolean match;
        ExecEnv env = frame.getEnv();
        List<Rule> rules = Matcher.getRulesOfKind(env.getRules(), RuleMode.AUTOMATIC_SINGLE);
        LinkedHashSet<Rule> matchedRules = new LinkedHashSet<Rule>();
        do {
            match = false;
            for (Rule rule : rules) {
                if (matchedRules.contains(rule) || !matchedRules.containsAll((Collection<?>)rule.getESuperRules()) || !(matcher = new Matcher(frame, rule)).match()) continue;
                match = true;
                matchedRules.add(rule);
            }
        } while (match);
        for (Rule rule : matchedRules) {
            if (rule.isAbstract()) continue;
            matcher = new Matcher(frame, rule);
            matcher.createTraces();
        }
        timingData.finishMatch();
        for (Rule rule : matchedRules) {
            if (rule.isAbstract()) continue;
            matcher = new Matcher(frame, rule);
            matcher.apply();
        }
        timingData.finishApply();
        for (Rule rule : matchedRules) {
            if (rule.isAbstract()) continue;
            matcher = new Matcher(frame, rule);
            matcher.postApply();
        }
        env.deleteQueue();
        timingData.finishPostApply();
    }

    private static void matchAllRecursive(StackFrame frame) {
        boolean outerMatch;
        ExecEnv env = frame.getEnv();
        List<Rule> rules = Matcher.getRulesOfKind(env.getRules(), RuleMode.AUTOMATIC_RECURSIVE);
        LinkedHashSet<Rule> matchedRules = new LinkedHashSet<Rule>();
        block0: do {
            Matcher matcher;
            boolean match;
            outerMatch = false;
            matchedRules.clear();
            block1: do {
                match = false;
                for (Rule rule : rules) {
                    if (matchedRules.contains(rule) || !matchedRules.containsAll((Collection<?>)rule.getESuperRules())) continue;
                    if (rule.getESubRules().isEmpty()) {
                        if (rule.isAbstract() || !(matcher = new Matcher(frame, rule)).matchOne()) continue;
                        outerMatch = true;
                        matchedRules.add(rule);
                        break block1;
                    }
                    matcher = new Matcher(frame, rule);
                    if (!matcher.match()) continue;
                    match = true;
                    outerMatch |= !rule.isAbstract();
                    matchedRules.add(rule);
                }
            } while (match);
            block3: for (Rule rule : matchedRules) {
                if (rule.isAbstract()) continue;
                for (Rule subRule : rule.getESubRules()) {
                    if (matchedRules.contains(subRule) && !subRule.isAbstract()) continue block3;
                }
                matcher = new Matcher(frame, rule);
                TraceLink trace = matcher.createFirstTrace();
                assert (trace != null);
                matcher.getMatches().getRules().clear();
                matcher.getMatches().getDefaultSourceElements().clear();
                HashMap<Rule, Object[]> ruleApplyArgs = new HashMap<Rule, Object[]>();
                matcher.applyFor(trace, rule, ruleApplyArgs);
                matcher.postApplyFor(trace, rule, ruleApplyArgs);
                env.deleteQueue();
                continue block0;
            }
        } while (outerMatch);
    }

    public boolean match() {
        ExecEnv env = this.frame.getEnv();
        EList<Rule> superRules = this.rule.getESuperRules();
        if (superRules.isEmpty()) {
            EList<InputRuleElement> allInputs = this.rule.getInputElements();
            ArrayList<Iterable<EObject>> iterables = new ArrayList<Iterable<EObject>>(allInputs.size());
            for (InputRuleElement re : allInputs) {
                if (re.getBinding() != null) {
                    iterables.add(null);
                    continue;
                }
                iterables.add(Matcher.createIterableFor(env, re));
            }
            EObject[] values = new EObject[iterables.size()];
            return this.matchFor(values, 0, iterables);
        }
        ArrayList<TracedRule> superMatches = new ArrayList<TracedRule>();
        HashSet<String> superRuleElementNames = new HashSet<String>();
        TraceLinkSet matches = this.getMatches();
        for (Rule superRule : superRules) {
            TracedRule superMatch = matches.getLinksByRule(superRule.getName(), false);
            assert (superMatch != null);
            superMatches.add(superMatch);
            for (RuleElement re : superRule.getInputElements()) {
                superRuleElementNames.add(re.getName());
            }
        }
        HashMap<String, Iterable<EObject>> iterables = new HashMap<String, Iterable<EObject>>();
        EList<InputRuleElement> allInput = this.rule.getInputElements();
        for (InputRuleElement re : allInput) {
            String name = re.getName();
            if (superRuleElementNames.contains(name) || re.getBinding() != null) continue;
            iterables.put(name, Matcher.createIterableFor(env, re));
        }
        HashMap<String, EObject> values = new HashMap<String, EObject>(allInput.size());
        return this.matchFor(values, 0, superMatches, iterables, new HashMap<TracedRule, TraceLink>(superRules.size()));
    }

    private boolean matchFor(Map<String, EObject> values, int index, List<TracedRule> superMatches, Map<String, Iterable<EObject>> iterables, Map<TracedRule, TraceLink> currentMatches) {
        boolean result;
        block6: {
            block7: {
                block5: {
                    result = false;
                    int superSize = superMatches.size();
                    if (index >= superSize) break block5;
                    HashMap<String, EObject> newValues = new HashMap<String, EObject>(values);
                    TracedRule tr = superMatches.get(index);
                    block0: for (TraceLink match : tr.getLinks()) {
                        for (SourceElement se : match.getSourceElements()) {
                            String seName = se.getName();
                            EObject seValue = se.getObject();
                            if (values.containsKey(seName)) {
                                if (values.get(seName) == seValue) continue;
                                continue block0;
                            }
                            if (this.rule.isDistinctElements() && values.containsValue(seValue)) continue block0;
                            newValues.put(seName, seValue);
                        }
                        for (RuleElement re : this.rule.getInputElements()) {
                            String reName = re.getName();
                            if (newValues.containsKey(reName) && !re.getEType().isInstance(newValues.get(reName))) continue block0;
                        }
                        currentMatches.put(tr, match);
                        result |= this.matchFor(newValues, index + 1, superMatches, iterables, currentMatches);
                    }
                    break block6;
                }
                if (iterables.isEmpty()) break block7;
                result = this.matchFor(values, iterables, new ArrayList<String>(iterables.keySet()), 0);
                break block6;
            }
            result = this.matchFor(values, Matcher.createValuesArray(this.rule, values), 0);
            if (!result) break block6;
            for (TraceLink link : currentMatches.values()) {
                link.setOverridden(true);
            }
        }
        return result;
    }

    private boolean matchFor(Map<String, EObject> values, Map<String, Iterable<EObject>> iterables, List<String> keys, int keyIndex) {
        int size = iterables.size();
        if (keyIndex < size) {
            boolean result = false;
            String key = keys.get(keyIndex);
            assert (!values.containsKey(key));
            for (EObject o : iterables.get(key)) {
                if (this.rule.isDistinctElements() && values.containsValue(o)) continue;
                values.put(key, o);
                result |= this.matchFor(values, iterables, keys, keyIndex + 1);
                values.remove(key);
            }
            return result;
        }
        return this.matchFor(values, Matcher.createValuesArray(this.rule, values), 0);
    }

    private static EObject[] createValuesArray(Rule rule, Map<String, EObject> values) {
        EList<InputRuleElement> allInput = rule.getInputElements();
        EObject[] valuesArray = new EObject[allInput.size()];
        int i = 0;
        for (InputRuleElement re : allInput) {
            valuesArray[i++] = values.get(re.getName());
            assert (re.getBinding() != null || valuesArray[i - 1] != null);
            assert (valuesArray[i - 1] == null || re.getEType().isInstance((Object)valuesArray[i - 1]));
        }
        return valuesArray;
    }

    private static Map<String, EObject> createValuesMap(Rule rule, EObject[] values) {
        EList<InputRuleElement> allInput = rule.getInputElements();
        HashMap<String, EObject> valuesMap = new HashMap<String, EObject>(allInput.size());
        assert (allInput.size() == values.length);
        int i = 0;
        for (RuleElement re : allInput) {
            valuesMap.put(re.getName(), values[i++]);
            assert (values[i - 1] != null);
        }
        return valuesMap;
    }

    private boolean checkDistinct(EObject[] values, int index, Object value) {
        if (this.rule.isDistinctElements()) {
            int i = 0;
            while (i < index) {
                if (values[i] == value) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private boolean matchFor(EObject[] values, int index, List<Iterable<EObject>> iterables) {
        assert (values.length == iterables.size());
        int newIndex = index;
        while (newIndex < values.length && iterables.get(newIndex) == null) {
            ++newIndex;
        }
        if (newIndex < values.length) {
            boolean result = false;
            for (EObject o : iterables.get(newIndex)) {
                if (!this.checkDistinct(values, newIndex, o)) continue;
                values[newIndex] = o;
                result |= this.matchFor(values, newIndex + 1, iterables);
                values[newIndex] = null;
            }
            return result;
        }
        return this.matchFor(values, 0);
    }

    private boolean matchFor(EObject[] values, int index) {
        EList<InputRuleElement> inputs = this.rule.getInputElements();
        if (index < inputs.size()) {
            InputRuleElement ire = (InputRuleElement)inputs.get(index);
            CodeBlock binding = ire.getBinding();
            if (binding != null) {
                Object value = binding.execute(this.frame.getSubFrame(binding, (Object[])values)).pop();
                if (value == null) {
                    return false;
                }
                if (values[index] != null) {
                    if (value instanceof Collection ? !((Collection)value).contains(values[index]) : !values[index].equals(value)) {
                        return false;
                    }
                } else {
                    if (value instanceof Collection) {
                        boolean result = false;
                        for (EObject v : (Collection)value) {
                            if (!ire.getEType().isInstance((Object)v) || !this.checkDistinct(values, values.length - 1, v)) continue;
                            values[index] = v;
                            result |= this.matchFor(values, index + 1);
                            values[index] = null;
                        }
                        return result;
                    }
                    if (!ire.getEType().isInstance(value) || !this.checkDistinct(values, values.length - 1, value)) {
                        return false;
                    }
                    values[index] = (EObject)value;
                    boolean result = this.matchFor(values, index + 1);
                    values[index] = null;
                    return result;
                }
            }
            return this.matchFor(values, index + 1);
        }
        return this.matchFor(values);
    }

    private boolean matchFor(Map<String, EObject> valuesMap, EObject[] values, int index) {
        EList<InputRuleElement> inputs = this.rule.getInputElements();
        if (index < inputs.size()) {
            InputRuleElement ire = (InputRuleElement)inputs.get(index);
            CodeBlock binding = ire.getBinding();
            if (binding != null) {
                Object value = binding.execute(this.frame.getSubFrame(binding, (Object[])values)).pop();
                if (value == null) {
                    return false;
                }
                if (values[index] != null) {
                    if (value instanceof Collection ? !((Collection)value).contains(values[index]) : !values[index].equals(value)) {
                        return false;
                    }
                } else {
                    if (value instanceof Collection) {
                        String key = ire.getName();
                        boolean result = false;
                        for (EObject v : (Collection)value) {
                            if (!ire.getEType().isInstance((Object)v) || this.rule.isDistinctElements() && valuesMap.containsValue(v)) continue;
                            values[index] = v;
                            valuesMap.put(key, v);
                            result |= this.matchFor(valuesMap, values, index + 1);
                            valuesMap.remove(key);
                            values[index] = null;
                        }
                        return result;
                    }
                    if (!ire.getEType().isInstance(value) || this.rule.isDistinctElements() && valuesMap.containsValue(value)) {
                        return false;
                    }
                    String key = ire.getName();
                    values[index] = (EObject)value;
                    valuesMap.put(key, (EObject)value);
                    boolean result = this.matchFor(valuesMap, values, index + 1);
                    valuesMap.remove(key);
                    values[index] = null;
                    return result;
                }
            }
            return this.matchFor(valuesMap, values, index + 1);
        }
        return this.matchFor(valuesMap, values);
    }

    private boolean matchFor(EObject[] values) {
        CodeBlock cb = this.rule.getMatcher();
        if (cb == null || ((Boolean)cb.execute(this.frame.getSubFrame(cb, (Object[])values)).pop()).booleanValue()) {
            String ruleName = this.rule.getName();
            TraceLinkSet matches = this.getMatches();
            TracedRule tr = matches.getLinksByRule(ruleName, true);
            TraceLink match = this.factory.createTraceLink();
            tr.getLinks().add((Object)match);
            EList ses = match.getSourceElements();
            int i = 0;
            for (RuleElement re : this.rule.getInputElements()) {
                SourceElement se = this.factory.createSourceElement();
                se.setName(re.getName());
                se.setObject(values[i++]);
                ses.add((Object)se);
            }
            return true;
        }
        return false;
    }

    private boolean matchFor(Map<String, EObject> valuesMap, EObject[] values) {
        CodeBlock cb = this.rule.getMatcher();
        if (cb == null || ((Boolean)cb.execute(this.frame.getSubFrame(cb, (Object[])values)).pop()).booleanValue()) {
            String ruleName = this.rule.getName();
            TraceLinkSet matches = this.getMatches();
            TracedRule tr = matches.getLinksByRule(ruleName, true);
            TraceLink match = this.factory.createTraceLink();
            tr.getLinks().add((Object)match);
            EList ses = match.getSourceElements();
            for (Map.Entry<String, EObject> v : valuesMap.entrySet()) {
                SourceElement se = this.factory.createSourceElement();
                se.setName(v.getKey());
                se.setObject(v.getValue());
                ses.add((Object)se);
            }
            return true;
        }
        return false;
    }

    public boolean matchOne() {
        ExecEnv env = this.frame.getEnv();
        EList<Rule> superRules = this.rule.getESuperRules();
        if (superRules.isEmpty()) {
            EList<InputRuleElement> allInputs = this.rule.getInputElements();
            ArrayList<Iterable<EObject>> iterables = new ArrayList<Iterable<EObject>>(allInputs.size());
            for (InputRuleElement re : allInputs) {
                if (re.getBinding() != null) {
                    iterables.add(null);
                    continue;
                }
                iterables.add(Matcher.createIterableFor(env, re));
            }
            EObject[] values = new EObject[iterables.size()];
            return this.matchOneFor(values, 0, iterables);
        }
        ArrayList<TracedRule> superMatches = new ArrayList<TracedRule>();
        HashSet<String> superRuleElementNames = new HashSet<String>();
        TraceLinkSet matches = this.getMatches();
        for (Rule superRule : superRules) {
            TracedRule superMatch = matches.getLinksByRule(superRule.getName(), false);
            assert (superMatch != null);
            superMatches.add(superMatch);
            for (RuleElement re : superRule.getInputElements()) {
                superRuleElementNames.add(re.getName());
            }
        }
        HashMap<String, Iterable<EObject>> iterables = new HashMap<String, Iterable<EObject>>();
        EList<InputRuleElement> allInput = this.rule.getInputElements();
        for (InputRuleElement re : allInput) {
            String name = re.getName();
            if (superRuleElementNames.contains(name) || re.getBinding() != null) continue;
            iterables.put(name, Matcher.createIterableFor(env, re));
        }
        HashMap<String, EObject> values = new HashMap<String, EObject>(allInput.size());
        return this.matchOneFor(values, 0, superMatches, iterables, new HashMap<TracedRule, TraceLink>(superRules.size()));
    }

    private boolean matchOneFor(Map<String, EObject> values, int index, List<TracedRule> superMatches, Map<String, Iterable<EObject>> iterables, Map<TracedRule, TraceLink> currentMatches) {
        int superSize = superMatches.size();
        if (index < superSize) {
            HashMap<String, EObject> newValues = new HashMap<String, EObject>(values);
            TracedRule tr = superMatches.get(index);
            block0: for (TraceLink match : tr.getLinks()) {
                for (SourceElement se : match.getSourceElements()) {
                    String seName = se.getName();
                    EObject seValue = se.getObject();
                    if (values.containsKey(seName)) {
                        if (values.get(seName) == seValue) continue;
                        continue block0;
                    }
                    if (this.rule.isDistinctElements() && values.containsValue(seValue)) continue block0;
                    newValues.put(seName, seValue);
                }
                for (RuleElement re : this.rule.getInputElements()) {
                    String reName = re.getName();
                    if (newValues.containsKey(reName) && !re.getEType().isInstance(newValues.get(reName))) continue block0;
                }
                currentMatches.put(tr, match);
                if (!this.matchOneFor(newValues, index + 1, superMatches, iterables, currentMatches)) continue;
                return true;
            }
            return false;
        }
        if (!iterables.isEmpty()) {
            return this.matchOneFor(values, iterables, new ArrayList<String>(iterables.keySet()), 0);
        }
        boolean result = this.matchOneFor(values, Matcher.createValuesArray(this.rule, values), 0);
        if (result) {
            for (TraceLink link : currentMatches.values()) {
                link.setOverridden(true);
            }
        }
        return result;
    }

    private boolean matchOneFor(Map<String, EObject> values, Map<String, Iterable<EObject>> iterables, List<String> keys, int keyIndex) {
        int size = iterables.size();
        if (keyIndex < size) {
            String key = keys.get(keyIndex);
            assert (!values.containsKey(key));
            for (EObject o : iterables.get(key)) {
                if (this.rule.isDistinctElements() && values.containsValue(o)) continue;
                values.put(key, o);
                if (this.matchOneFor(values, iterables, keys, keyIndex + 1)) {
                    values.remove(key);
                    return true;
                }
                values.remove(key);
            }
            return false;
        }
        return this.matchOneFor(values, Matcher.createValuesArray(this.rule, values), 0);
    }

    private boolean matchOneFor(EObject[] values, int index, List<Iterable<EObject>> iterables) {
        assert (values.length == iterables.size());
        int newIndex = index;
        while (newIndex < values.length && iterables.get(newIndex) == null) {
            ++newIndex;
        }
        if (newIndex < values.length) {
            for (EObject o : iterables.get(newIndex)) {
                if (!this.checkDistinct(values, newIndex, o)) continue;
                values[newIndex] = o;
                if (this.matchOneFor(values, newIndex + 1, iterables)) {
                    values[newIndex] = null;
                    return true;
                }
                values[newIndex] = null;
            }
            return false;
        }
        return this.matchOneFor(values, 0);
    }

    private boolean matchOneFor(EObject[] values, int index) {
        EList<InputRuleElement> inputs = this.rule.getInputElements();
        if (index < inputs.size()) {
            InputRuleElement ire = (InputRuleElement)inputs.get(index);
            CodeBlock binding = ire.getBinding();
            if (binding != null) {
                Object value = binding.execute(this.frame.getSubFrame(binding, (Object[])values)).pop();
                if (value == null) {
                    return false;
                }
                if (values[index] != null) {
                    if (value instanceof Collection ? !((Collection)value).contains(values[index]) : !values[index].equals(value)) {
                        return false;
                    }
                } else {
                    if (value instanceof Collection) {
                        for (EObject v : (Collection)value) {
                            if (!ire.getEType().isInstance((Object)v) || !this.checkDistinct(values, values.length - 1, v)) continue;
                            values[index] = v;
                            if (this.matchOneFor(values, index + 1)) {
                                values[index] = null;
                                return true;
                            }
                            values[index] = null;
                        }
                        return false;
                    }
                    if (!ire.getEType().isInstance(value) || !this.checkDistinct(values, values.length - 1, value)) {
                        return false;
                    }
                    values[index] = (EObject)value;
                    boolean result = this.matchOneFor(values, index + 1);
                    values[index] = null;
                    return result;
                }
            }
            return this.matchOneFor(values, index + 1);
        }
        return this.matchFor(values);
    }

    private boolean matchOneFor(Map<String, EObject> valuesMap, EObject[] values, int index) {
        EList<InputRuleElement> inputs = this.rule.getInputElements();
        if (index < inputs.size()) {
            InputRuleElement ire = (InputRuleElement)inputs.get(index);
            CodeBlock binding = ire.getBinding();
            if (binding != null) {
                Object value = binding.execute(this.frame.getSubFrame(binding, (Object[])values)).pop();
                if (value == null) {
                    return false;
                }
                if (values[index] != null) {
                    if (value instanceof Collection ? !((Collection)value).contains(values[index]) : !values[index].equals(value)) {
                        return false;
                    }
                } else {
                    if (value instanceof Collection) {
                        String key = ire.getName();
                        for (EObject v : (Collection)value) {
                            if (!ire.getEType().isInstance((Object)v) || this.rule.isDistinctElements() && valuesMap.containsValue(v)) continue;
                            values[index] = v;
                            valuesMap.put(key, v);
                            if (this.matchOneFor(valuesMap, values, index + 1)) {
                                values[index] = null;
                                return true;
                            }
                            valuesMap.remove(key);
                            values[index] = null;
                        }
                        return false;
                    }
                    if (!ire.getEType().isInstance(value) || this.rule.isDistinctElements() && valuesMap.containsValue(value)) {
                        return false;
                    }
                    String key = ire.getName();
                    values[index] = (EObject)value;
                    valuesMap.put(key, (EObject)value);
                    boolean result = this.matchFor(valuesMap, values, index + 1);
                    valuesMap.remove(key);
                    values[index] = null;
                    return result;
                }
            }
            return this.matchOneFor(valuesMap, values, index + 1);
        }
        return this.matchFor(valuesMap, values);
    }

    public boolean matchOne(Map<String, EObject> valuesMap) {
        ExecEnv env = this.frame.getEnv();
        Object[] values = Matcher.createValuesArray(this.rule, valuesMap);
        EList<InputRuleElement> inputs = this.rule.getInputElements();
        int index = 0;
        while (index < inputs.size()) {
            CodeBlock binding;
            InputRuleElement re = (InputRuleElement)inputs.get(index);
            EObject value = valuesMap.get(re.getName());
            if (value == null) {
                throw new VMException(this.frame, String.format("Cannot match rule input element %s against null value for %s", re, this.rule));
            }
            EList<Model> inmodels = re.getEModels();
            if (!re.getEType().isInstance((Object)value) || !inmodels.isEmpty() && !inmodels.contains((Object)env.getModelOf(value))) {
                return false;
            }
            if (this.checkDistinct((EObject[])values, index, value) && (binding = re.getBinding()) != null) {
                Object bvalue = binding.execute(this.frame.getSubFrame(binding, values)).pop();
                if (bvalue == null) {
                    return false;
                }
                if (bvalue instanceof Collection ? !((Collection)bvalue).contains(value) : !value.equals(bvalue)) {
                    return false;
                }
            }
            ++index;
        }
        for (Rule superRule : this.rule.getESuperRules()) {
            Matcher matcher = new Matcher(this.frame, superRule);
            if (matcher.matchOne(valuesMap)) continue;
            return false;
        }
        CodeBlock cb = this.rule.getMatcher();
        return cb == null ? true : (Boolean)cb.execute(this.frame.getSubFrame(cb, values)).pop();
    }

    private static Iterable<EObject> createIterableFor(ExecEnv env, InputRuleElement re) {
        if (re.getEModels().isEmpty()) {
            return EMFTVMUtil.findAllInstances(env, (EClass)re.getEType());
        }
        LazyList<EObject> allInstances = new LazyList<EObject>();
        for (Model m : re.getEModels()) {
            allInstances = allInstances.union(m.allInstancesOf((EClass)re.getEType()));
        }
        return allInstances;
    }

    public void createTraces() {
        TracedRule tr = this.getMatches().getLinksByRule(this.rule.getName(), false);
        if (tr == null) {
            throw new VMException(this.frame, String.format("Cannot create traces for %s; no matches exist", this.rule));
        }
        Iterator links = tr.getLinks().iterator();
        while (links.hasNext()) {
            TraceLink trace = (TraceLink)links.next();
            if (trace.isOverridden()) {
                links.remove();
                continue;
            }
            this.completeTraceFor(trace, this.rule);
        }
        TraceLinkSet traces = this.getTraces();
        traces.getRules().add((Object)tr);
        if (this.rule.isDefault()) {
            for (TraceLink trace : tr.getLinks()) {
                EList ses = trace.getSourceElements();
                if (ses.size() == 1) {
                    ((SourceElement)ses.get(0)).setDefaultFor(traces);
                    continue;
                }
                assert (ses.size() > 1);
                SourceElementList sel = TraceFactory.eINSTANCE.createSourceElementList();
                sel.getSourceElements().addAll((Collection)ses);
                sel.setDefaultFor(traces);
            }
        }
    }

    public TraceLink createFirstTrace() {
        TracedRule tr = this.getMatches().getLinksByRule(this.rule.getName(), false);
        if (tr == null) {
            throw new VMException(this.frame, String.format("Cannot create a trace for rule %s; no matches exist", this.rule));
        }
        Iterator links = tr.getLinks().iterator();
        while (links.hasNext()) {
            TraceLink trace = (TraceLink)links.next();
            if (trace.isOverridden()) {
                links.remove();
                continue;
            }
            this.completeTraceFor(trace, this.rule);
            String ruleName = this.rule.getName();
            TraceLinkSet traces = this.getTraces();
            TracedRule ntr = traces.getLinksByRule(ruleName, true);
            ntr.getLinks().add((Object)trace);
            if (this.rule.isDefault()) {
                EList ses = trace.getSourceElements();
                if (ses.size() == 1) {
                    ((SourceElement)ses.get(0)).setDefaultFor(traces);
                } else {
                    assert (ses.size() > 1);
                    SourceElementList sel = TraceFactory.eINSTANCE.createSourceElementList();
                    sel.getSourceElements().addAll((Collection)ses);
                    sel.setDefaultFor(traces);
                }
            }
            return trace;
        }
        return null;
    }

    public TraceLink createTrace(Map<String, EObject> values) {
        TraceLinkSet traces = this.getTraces();
        String ruleName = this.rule.getName();
        TracedRule tr = traces.getLinksByRule(ruleName, true);
        TraceLink trace = this.factory.createTraceLink();
        tr.getLinks().add((Object)trace);
        EList ses = trace.getSourceElements();
        for (InputRuleElement ire : this.rule.getInputElements()) {
            String ireName = ire.getName();
            EObject source = values.get(ireName);
            assert (source != null);
            SourceElement se = this.factory.createSourceElement();
            se.setName(ireName);
            se.setObject(source);
            ses.add((Object)se);
        }
        this.completeTraceFor(trace, this.rule);
        if (this.rule.isDefault()) {
            if (ses.size() == 1) {
                ((SourceElement)ses.get(0)).setDefaultFor(traces);
            } else {
                SourceElementList sel = TraceFactory.eINSTANCE.createSourceElementList();
                sel.getSourceElements().addAll((Collection)ses);
                sel.setDefaultFor(traces);
            }
        }
        return trace;
    }

    private void completeTraceFor(TraceLink trace, Rule rule) {
        ExecEnv env = this.frame.getEnv();
        TraceLinkSet traces = this.getTraces();
        boolean isDefault = rule.isDefault();
        for (OutputRuleElement ore : rule.getOutputElements()) {
            EClass type;
            String oreName = ore.getName();
            if (trace.getTargetElement(oreName) != null) continue;
            TargetElement te = TraceFactory.eINSTANCE.createTargetElement();
            te.setName(oreName);
            te.setTargetOf(trace);
            InputRuleElement source = ore.getMapsTo();
            if (source != null) {
                SourceElement mapsTo = trace.getSourceElement(source.getName(), false);
                assert (mapsTo != null);
                te.setMapsTo(mapsTo);
                if (isDefault) {
                    mapsTo.setDefaultFor(traces);
                }
            }
            try {
                type = (EClass)env.findType(ore.getTypeModel(), ore.getType());
            }
            catch (ClassNotFoundException e) {
                throw new VMException(this.frame);
            }
            EList<Model> models = ore.getEModels();
            assert (models.size() == 1);
            te.setObject(((Model)models.get(0)).newElement(type));
            assert (te.getObject() != null);
            assert (te.getObject().eResource() != null);
            assert (te.getObject().eResource() == ((Model)models.get(0)).getResource());
        }
        for (Rule superRule : rule.getESuperRules()) {
            this.completeTraceFor(trace, superRule);
        }
    }

    public void apply() {
        TraceLinkSet traces = this.getTraces();
        TracedRule tr = traces.getLinksByRule(this.rule.getName(), false);
        if (tr == null) {
            throw new VMException(this.frame, String.format("Cannot apply rule %s; no traces exist", this.rule));
        }
        HashMap<Rule, Object[]> ruleApplyArgs = new HashMap<Rule, Object[]>();
        for (TraceLink trace : tr.getLinks()) {
            assert (!trace.isOverridden());
            this.applyFor(trace, this.rule, ruleApplyArgs);
        }
    }

    private StackFrame applyFor(TraceLink trace, Rule rule, Map<Rule, Object[]> ruleApplyArgs) {
        for (Rule superRule : rule.getESuperRules()) {
            this.applyFor(trace, superRule, ruleApplyArgs);
        }
        CodeBlock cb = rule.getApplier();
        if (cb == null) {
            return null;
        }
        Object[] args = ruleApplyArgs.containsKey(rule) ? ruleApplyArgs.get(rule) : new Object[1 + rule.getInputElements().size() + rule.getOutputElements().size()];
        Matcher.createArgs(rule, trace, args);
        return cb.execute(this.frame.getSubFrame(cb, args));
    }

    public void postApply() {
        TraceLinkSet traces = this.getTraces();
        TracedRule tr = traces.getLinksByRule(this.rule.getName(), false);
        if (tr == null) {
            throw new VMException(this.frame, String.format("Cannot post-apply rule %s; no traces exist", this.rule));
        }
        HashMap<Rule, Object[]> ruleApplyArgs = new HashMap<Rule, Object[]>();
        for (TraceLink trace : tr.getLinks()) {
            this.postApplyFor(trace, this.rule, ruleApplyArgs);
        }
    }

    private StackFrame postApplyFor(TraceLink trace, Rule rule, Map<Rule, Object[]> ruleApplyArgs) {
        for (Rule superRule : rule.getESuperRules()) {
            this.postApplyFor(trace, superRule, ruleApplyArgs);
        }
        CodeBlock cb = rule.getPostApply();
        if (cb == null) {
            return null;
        }
        Object[] args = ruleApplyArgs.containsKey(rule) ? ruleApplyArgs.get(rule) : new Object[1 + rule.getInputElements().size() + rule.getOutputElements().size()];
        Matcher.createArgs(rule, trace, args);
        return cb.execute(this.frame.getSubFrame(cb, args));
    }

    private static void createArgs(Rule rule, TraceLink trace, Object[] args) {
        EList<InputRuleElement> input = rule.getInputElements();
        EList<OutputRuleElement> output = rule.getOutputElements();
        assert (args.length == 1 + input.size() + output.size());
        args[0] = trace;
        int i = 1;
        for (InputRuleElement ire : input) {
            args[i++] = trace.getSourceElement(ire.getName(), false).getObject();
            assert (args[i - 1] != null);
        }
        for (OutputRuleElement ore : output) {
            args[i++] = trace.getTargetElement(ore.getName()).getObject();
            assert (args[i - 1] != null);
        }
        assert (i == args.length);
    }

    public StackFrame getFrame() {
        return this.frame;
    }

    public Rule getRule() {
        return this.rule;
    }

    public TraceLinkSet getMatches() {
        if (this.matches == null) {
            Field matchesField = this.frame.getEnv().findStaticField(EmftvmPackage.eINSTANCE.getExecEnv(), "matches");
            this.matches = (TraceLinkSet)matchesField.getStaticValue(this.frame);
            if (this.matches == null) {
                throw new VMException(this.frame, "matches field not initialised");
            }
        }
        return this.matches;
    }

    public TraceLinkSet getTraces() {
        if (this.traces == null) {
            Field tracesField = this.frame.getEnv().findStaticField(EmftvmPackage.eINSTANCE.getExecEnv(), "traces");
            this.traces = (TraceLinkSet)tracesField.getStaticValue(this.frame);
            if (this.traces == null) {
                throw new VMException(this.frame, "traces field not initialised");
            }
        }
        return this.traces;
    }
}

