/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.m2m.atl.emftvm.CodeBlock;
import org.eclipse.m2m.atl.emftvm.util.LazyBag;
import org.eclipse.m2m.atl.emftvm.util.LazyCollection;
import org.eclipse.m2m.atl.emftvm.util.StackFrame;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LazySet<E>
extends LazyCollection<E>
implements Set<E> {
    public LazySet() {
    }

    public LazySet(Iterable<E> dataSource) {
        super(dataSource);
    }

    @Override
    protected void createCache() {
        super.createCache();
        if (this.cache == null) {
            this.cache = new LinkedHashSet();
        }
    }

    @Override
    public Iterator<E> iterator() {
        if (this.dataSource == null) {
            return Collections.unmodifiableCollection(this.cache).iterator();
        }
        return new LazyCollection.CachingSetIterator();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        try {
            return this.containsAll((Collection)o);
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (E obj : this) {
            if (obj == null) continue;
            hashCode += obj.hashCode();
        }
        return hashCode;
    }

    @Override
    public int count(E o) {
        return this.contains(o) ? 1 : 0;
    }

    public LazySet<E> union(final LazySet<E> s) {
        return new LazySet<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return (LazyCollection)this.new LazyCollection.UnionSetIterator(s);
            }
        };
    }

    public LazyBag<E> union(LazyBag<E> bag) {
        return new LazyBag.UnionBag<E>(bag, this);
    }

    public LazySet<E> intersection(final LazySet<E> s) {
        return new LazySet<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return (LazyCollection)this.new LazyCollection.IntersectionIterator(s);
            }
        };
    }

    public LazySet<E> intersection(final LazyBag<E> s) {
        return new LazySet<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return (LazyCollection)this.new LazyCollection.IntersectionIterator(s);
            }
        };
    }

    public LazySet<E> subtract(final LazySet<E> s) {
        return new LazySet<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return (LazyCollection)this.new LazyCollection.SubtractionIterator(s);
            }
        };
    }

    @Override
    public LazySet<E> including(E object) {
        return new IncludingSet<E>(object, this);
    }

    public LazySet<E> excluding(E object) {
        return new ExcludingSet<E>(object, this);
    }

    public LazySet<E> symmetricDifference(LazySet<E> s) {
        return this.union(s).subtract(this.intersection(s));
    }

    public LazySet<?> flatten() {
        final LazySet inner = this;
        return new LazySet<Object>(new Iterable<Object>(){

            @Override
            public Iterator<Object> iterator() {
                return new LazyCollection.FlattenSetIterator(inner);
            }
        });
    }

    @Override
    public LazySet<E> asSet() {
        return this;
    }

    public LazySet<E> select(final CodeBlock condition) {
        final StackFrame parentFrame = condition.getParentFrame();
        return new LazySet<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return new LazyCollection.SelectIterator(condition, parentFrame);
            }
        };
    }

    public LazySet<E> reject(final CodeBlock condition) {
        final StackFrame parentFrame = condition.getParentFrame();
        return new LazySet<E>(this){

            @Override
            public Iterator<E> iterator() {
                if (this.dataSource == null) {
                    return Collections.unmodifiableCollection(this.cache).iterator();
                }
                return new LazyCollection.RejectIterator(condition, parentFrame);
            }
        };
    }

    public <T> LazyBag<T> collect(final CodeBlock function) {
        final StackFrame parentFrame = function.getParentFrame();
        final LazySet inner = this;
        return new LazyBag(new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new LazyCollection.CollectIterator(inner, function, parentFrame);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExcludingSet<E>
    extends NonCachingSet<E> {
        protected final E object;
        protected boolean containsExcluded;
        protected boolean containsExcludedSet;

        public ExcludingSet(E object, LazySet<E> dataSource) {
            super(dataSource);
            this.object = object;
        }

        @Override
        public boolean contains(Object o) {
            return (this.object == null ? o != null : !this.object.equals(o)) && ((Collection)this.dataSource).contains(o);
        }

        @Override
        public int count(E o) {
            return (this.object == null ? o == null : this.object.equals(o)) ? 0 : ((LazyCollection)this.dataSource).count(o);
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public Iterator<E> iterator() {
            if (this.containsExcludedSet && !this.containsExcluded) {
                return ((Collection)this.dataSource).iterator();
            }
            return new ExcludingSetIterator();
        }

        @Override
        public int size() {
            int size = ((Collection)this.dataSource).size();
            if (!this.containsExcludedSet) {
                this.containsExcluded = ((Collection)this.dataSource).contains(this.object);
                this.containsExcludedSet = true;
            }
            return size - (this.containsExcluded ? 1 : 0);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class ExcludingSetIterator
        extends LazyCollection.WrappedIterator {
            protected E next;
            protected boolean nextSet;

            @Override
            public boolean hasNext() {
                boolean hasNext;
                if (!this.nextSet && this.inner.hasNext()) {
                    this.next = this.inner.next();
                    this.nextSet = true;
                }
                if (this.nextSet && (ExcludingSet.this.object == null ? this.next == null : ExcludingSet.this.object.equals(this.next))) {
                    ExcludingSet.this.containsExcluded = true;
                    ExcludingSet.this.containsExcludedSet = true;
                    if (this.inner.hasNext()) {
                        this.next = this.inner.next();
                        assert (!(ExcludingSet.this.object == null ? this.next == null : ExcludingSet.this.object.equals(this.next)));
                    }
                }
                boolean bl = this.nextSet && (ExcludingSet.this.object == null ? this.next != null : !ExcludingSet.this.object.equals(this.next)) ? true : (hasNext = false);
                if (!hasNext && !ExcludingSet.this.containsExcludedSet) {
                    ExcludingSet.this.containsExcluded = false;
                    ExcludingSet.this.containsExcludedSet = true;
                }
                return hasNext;
            }

            @Override
            public E next() {
                if (!this.nextSet) {
                    this.next = this.inner.next();
                } else {
                    this.nextSet = false;
                }
                if (ExcludingSet.this.object == null ? this.next == null : ExcludingSet.this.object.equals(this.next)) {
                    ExcludingSet.this.containsExcluded = true;
                    ExcludingSet.this.containsExcludedSet = true;
                    this.next = this.inner.next();
                }
                assert (!this.nextSet && this.next != ExcludingSet.this.object);
                return this.next;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IncludingSet<E>
    extends NonCachingSet<E> {
        protected final E object;
        protected boolean containsObject;
        protected boolean containsSet;

        public IncludingSet(E object, LazySet<E> dataSource) {
            super(dataSource);
            this.object = object;
        }

        @Override
        public boolean contains(Object o) {
            return !(this.object == null ? o != null : !this.object.equals(o)) || ((Collection)this.dataSource).contains(o);
        }

        @Override
        public int count(E o) {
            return (this.object == null ? o == null : this.object.equals(o)) ? 1 : ((LazyCollection)this.dataSource).count(o);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Iterator<E> iterator() {
            return new IncludingSetIterator(this.object);
        }

        @Override
        public int size() {
            int size = ((Collection)this.dataSource).size();
            if (!this.containsSet) {
                this.containsObject = ((Collection)this.dataSource).contains(this.object);
                this.containsSet = true;
            }
            assert (this.containsSet);
            return size + (this.containsObject ? 0 : 1);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class IncludingSetIterator
        extends LazyCollection.WrappedIterator {
            protected final E object;
            protected boolean beforeTail = true;
            protected boolean innerNext;

            public IncludingSetIterator(E object) {
                this.object = object;
            }

            @Override
            public boolean hasNext() {
                this.innerNext = this.inner.hasNext();
                if (this.innerNext) {
                    return true;
                }
                if (this.beforeTail) {
                    if (!IncludingSet.this.containsSet) {
                        IncludingSet.this.containsObject = ((Collection)IncludingSet.this.dataSource).contains(this.object);
                        IncludingSet.this.containsSet = true;
                    }
                    assert (IncludingSet.this.containsSet);
                    return !IncludingSet.this.containsObject;
                }
                return false;
            }

            @Override
            public E next() {
                if (this.innerNext || this.inner.hasNext()) {
                    this.innerNext = false;
                    return this.inner.next();
                }
                if (this.beforeTail) {
                    if (!IncludingSet.this.containsSet) {
                        IncludingSet.this.containsObject = ((Collection)IncludingSet.this.dataSource).contains(this.object);
                        IncludingSet.this.containsSet = true;
                    }
                    assert (IncludingSet.this.containsSet);
                    if (!IncludingSet.this.containsObject) {
                        this.beforeTail = false;
                        return this.object;
                    }
                }
                throw new NoSuchElementException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class NonCachingSet<E>
    extends LazySet<E> {
        public NonCachingSet(LazySet<E> dataSource) {
            super(dataSource);
            assert (dataSource != null);
        }

        @Override
        protected void createCache() {
        }
    }
}

