/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.preferences;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.actions.StatusInfo;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.m2m.atl.adt.ui.preferences.ProfileManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AlreadyExistsDialog
extends StatusDialog {
    private Composite fComposite;
    protected Text fNameText;
    private Button fRenameRadio;
    private Button fOverwriteRadio;
    private final int NUM_COLUMNS = 2;
    private final StatusInfo fOk;
    private final StatusInfo fEmpty;
    private final StatusInfo fDuplicate;
    private final ProfileManager.CustomProfile fProfile;
    private final ProfileManager fProfileManager;

    public AlreadyExistsDialog(Shell parentShell, ProfileManager.CustomProfile profile, ProfileManager profileManager) {
        super(parentShell);
        this.fProfile = profile;
        this.fProfileManager = profileManager;
        this.fOk = new StatusInfo();
        this.fDuplicate = new StatusInfo(4, "There is already a profile with this name");
        this.fEmpty = new StatusInfo(4, "The profile name is empty");
        this.setHelpAvailable(false);
    }

    public void create() {
        super.create();
        this.setTitle("Duplicate name...");
    }

    public Control createDialogArea(Composite parent) {
        this.fComposite = (Composite)super.createDialogArea(parent);
        ((GridLayout)this.fComposite.getLayout()).numColumns = 2;
        this.createLabel(this.fProfile.getName());
        this.fRenameRadio = this.createRadioButton("Rename the profile");
        this.fNameText = this.createTextField();
        this.fOverwriteRadio = this.createRadioButton("Overwrite the existing profile");
        this.fRenameRadio.setSelection(true);
        this.fNameText.setText(this.fProfile.getName());
        this.fNameText.setSelection(0, this.fProfile.getName().length());
        this.fNameText.setFocus();
        this.fNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AlreadyExistsDialog.this.doValidation();
            }
        });
        this.fRenameRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AlreadyExistsDialog.this.fNameText.setEnabled(true);
                AlreadyExistsDialog.this.fNameText.setFocus();
                AlreadyExistsDialog.this.fNameText.setSelection(0, AlreadyExistsDialog.this.fNameText.getText().length());
                AlreadyExistsDialog.this.doValidation();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fOverwriteRadio.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AlreadyExistsDialog.this.fNameText.setEnabled(false);
                AlreadyExistsDialog.this.doValidation();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.updateStatus((IStatus)this.fDuplicate);
        AlreadyExistsDialog.applyDialogFont((Control)this.fComposite);
        return this.fComposite;
    }

    private Label createLabel(String text) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        Label label = new Label(this.fComposite, 64);
        label.setText(text);
        label.setLayoutData((Object)gd);
        return label;
    }

    private Button createRadioButton(String text) {
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.widthHint = this.convertWidthInCharsToPixels(60);
        Button radio = new Button(this.fComposite, 16);
        radio.setLayoutData((Object)gd);
        radio.setText(text);
        return radio;
    }

    private Text createTextField() {
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 15;
        Text text = new Text(this.fComposite, 2052);
        text.setLayoutData((Object)gd);
        return text;
    }

    protected void doValidation() {
        if (this.fOverwriteRadio.getSelection()) {
            this.updateStatus((IStatus)this.fOk);
            return;
        }
        String name = this.fNameText.getText().trim();
        if (name.length() == 0) {
            this.updateStatus((IStatus)this.fEmpty);
            return;
        }
        if (this.fProfileManager.containsName(name)) {
            this.updateStatus((IStatus)this.fDuplicate);
            return;
        }
        this.updateStatus((IStatus)this.fOk);
    }

    protected void okPressed() {
        if (!this.getStatus().isOK()) {
            return;
        }
        if (this.fRenameRadio.getSelection()) {
            this.fProfile.rename(this.fNameText.getText(), this.fProfileManager);
        }
        super.okPressed();
    }
}

