/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text;

import java.io.IOException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.ICharacterPairMatcher;
import org.eclipse.m2m.atl.adt.ui.text.AtlCodeReader;

public class AtlPairMatcher
implements ICharacterPairMatcher {
    private int anchor;
    private IDocument document;
    private int endPos;
    private int offset;
    private char[] pairs;
    private AtlCodeReader reader = new AtlCodeReader();
    private int startPos;

    public AtlPairMatcher(char[] pairs) {
        this.pairs = pairs;
    }

    public AtlPairMatcher(String[] pairs) {
        this.pairs = new char[pairs.length];
        int i = 0;
        while (i < pairs.length) {
            this.pairs[i] = pairs[i].charAt(0);
            ++i;
        }
    }

    public void clear() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void dispose() {
        this.clear();
        this.document = null;
        this.reader = null;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public char getMatchingPair(char singleton) {
        int i = 0;
        while (i < this.pairs.length) {
            if (singleton == this.pairs[i]) {
                if (i % 2 == 0) {
                    return this.pairs[i + 1];
                }
                return this.pairs[i - 1];
            }
            ++i;
        }
        return '\u0000';
    }

    public IRegion match(IDocument iDocument, int i) {
        this.offset = i;
        if (this.offset < 0) {
            return null;
        }
        this.document = iDocument;
        if (this.document != null && this.matchPairsAt() && this.startPos != this.endPos) {
            return new Region(this.startPos, this.endPos - this.startPos + 1);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean matchPairsAt() {
        int pairIndex1 = this.pairs.length;
        int pairIndex2 = this.pairs.length;
        this.startPos = -1;
        this.endPos = -1;
        try {
            char prevChar = this.document.getChar(Math.max(this.offset - 1, 0));
            int i = 0;
            while (i < this.pairs.length) {
                if (prevChar == this.pairs[i]) {
                    this.startPos = this.offset - 1;
                    pairIndex1 = i;
                }
                i += 2;
            }
            i = 1;
            while (i < this.pairs.length) {
                if (prevChar == this.pairs[i]) {
                    this.endPos = this.offset - 1;
                    pairIndex2 = i;
                }
                i += 2;
            }
            if (this.endPos > -1) {
                this.anchor = 0;
                this.startPos = this.searchForOpeningPeer(this.endPos, this.pairs[pairIndex2 - 1], this.pairs[pairIndex2], this.document);
                if (this.startPos > -1) {
                    return true;
                }
                this.endPos = -1;
                return false;
            }
            if (this.startPos <= -1) return false;
            this.anchor = 1;
            this.endPos = this.searchForClosingPeer(this.startPos, this.pairs[pairIndex1], this.pairs[pairIndex1 + 1], this.document);
            if (this.endPos > -1) {
                return true;
            }
            this.startPos = -1;
            return false;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public int searchForClosingPeer(int offset, int openingPeer, int closingPeer, IDocument document) throws IOException {
        this.reader.configureForwardReader(document, offset + 1, document.getLength(), true, true);
        int stack = 1;
        int c = this.reader.read();
        while (c != -1) {
            if (c == openingPeer && c != closingPeer) {
                ++stack;
            } else if (c == closingPeer) {
                --stack;
            }
            if (stack == 0) {
                return this.reader.getOffset();
            }
            c = this.reader.read();
        }
        return -1;
    }

    public int searchForOpeningPeer(int offset, int openingPeer, int closingPeer, IDocument document) throws IOException {
        this.reader.configureBackwardReader(document, offset, true, true);
        int stack = 1;
        int c = this.reader.read();
        while (c != -1) {
            if (c == closingPeer && c != openingPeer) {
                ++stack;
            } else if (c == openingPeer) {
                --stack;
            }
            if (stack == 0) {
                return this.reader.getOffset();
            }
            c = this.reader.read();
        }
        return -1;
    }
}

